/***************************************************************************
  hops.h
  -------------------
  A hops class
  -------------------
  begin         October 20th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999-2002, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef HOPS_H
#define HOPS_H

#include <qlistview.h>
#include <qstring.h>
#include <qvaluelist.h>

#include "quantity.h"

// TODO: use STL

class Hops {
public:
    // default constructor
    Hops();
    // full constructor
    Hops(const QString &nam, const Weight &weight,
         const QString &form, const double &alpha,
         const unsigned &time);
    // copy constructor
    Hops(const Hops &h);
    // assignment operator
    Hops operator=(const Hops &h);
    // comparison operator
    bool operator==(const Hops &h);
    // destructor
    ~Hops();

    // set name
    void setName(const QString &name);
    // return name
    QString name() const;
    // set weight
    void setWeight(const Weight &weight);
    // return weight
    Weight &weight();
    // set form
    void setForm(const QString &form);
    // return hops form
    QString form();
    // set alpha content
    void setAlpha(double alpha);
    // return hops alpha content
    double alpha();
    // set boil time
    void setTime(unsigned time);
    // return boil time
    unsigned time();
    
    // return precalculated values for bitterness
    double HBU();

private:
    QString name_;
    Weight weight_;
    QString form_;
    double alpha_;
    unsigned time_;
    // TODO: I don't want hbu here, do I?
    double hbu_;
};

// TODO: more efficient to use a map
typedef QValueList<Hops> HopsList;
typedef QValueList<Hops>::Iterator HopIterator;

// TODO: remove this from the model
class HopsListItem : public QListViewItem {
public:
    // constructor
    HopsListItem(QListView * parent, QString, QString = QString::null,
                 QString = QString::null, QString = QString::null,
                 QString = QString::null, QString = QString::null,
                 QString = QString::null, QString = QString::null );
    // destructor
    ~HopsListItem();
    // get iterator to Hop item
    HopIterator hopIterator();
    // set iterator to Hop item
    void setHopIterator(HopIterator &it);
    // set hop to match iterator
    void setToIterator();
private:
    HopIterator hit_;
};

//////////////////////////////////////////////////////////////////////////////
// Inlined Operators

inline void Hops::setName(const QString &name) { name_ = name; }

inline QString Hops::name() const { return name_; }

inline void Hops::setWeight(const Weight &weight) { weight_ = weight; }

inline Weight &Hops::weight() { return weight_; }

inline void Hops::setForm(const QString &form) { form_ = form; }

inline QString Hops::form() { return form_; }

inline void Hops::setAlpha(double alpha) { alpha_ = alpha; }

inline double Hops::alpha() { return alpha_; }

inline void Hops::setTime(unsigned time) { time_ = time; }

inline unsigned Hops::time() { return time_; }

inline double Hops::HBU() { return hbu_; }

inline HopsListItem::~HopsListItem() { ; }

inline HopIterator HopsListItem::hopIterator() { return hit_; }

inline void HopsListItem::setHopIterator(HopIterator &it) { hit_ = it; }

#endif // HOPS_H
