/***************************************************************************
  resource.h
  -------------------
  Global resources for QBrew. Constants, enumerations and strings.
  -------------------
  Copyright 1999-2002, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  3. Neither the name of the author nor the names of the contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <qstring.h>
#include <qmap.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#define PACKAGE "qbrew"
#define VERSION "0.3.3"
#define PACKAGE_BUGREPORT "<bugs@usermode.org>"
#endif

// some stuff to differentiate between systems
#if defined(_WS_X11_) || defined(Q_WS_X11)
#define QPREFIX		PREFIX
#define QDIR_HOME	QDir::homeDirPath()
#define OWNBASEDIR	false
#else
#define QPREFIX		""
#define QDIR_HOME	QDir::currentDirPath()
#define OWNBASEDIR	true
#endif
#if QT_VERSION < 300
#define LARGEICONS  false
#else
#define LARGEICONS  true
#endif

namespace AppResource {

///////////////////////////////////////////////////////////////////
// Units

const QString UNIT_METRIC               = "Metric";
const QString UNIT_US                   = "US";

///////////////////////////////////////////////////////////////////
// Hop Forms

const QString HOP_PELLET                = "pellet";
const QString HOP_PLUG                  = "plug";
const QString HOP_WHOLE                 = "whole";

///////////////////////////////////////////////////////////////////
// general application values

const QString ID_TITLE           = "QBrew";
const QString ID_DESCRIPTION     = "A Homebrewer's Recipe Calculator";
const QString ID_COPYRIGHT       = "Copyright 1999-2003";
const QString ID_AUTHOR          = "David Johnson";
const QString ID_AUTHOR_EMAIL    = "david@usermode.org";
const QString ID_CONTRIBUTORS    = "Abe Kabakoff, Stephen Lowrie";

const QString ID_READY           = "Ready";

const QChar CHAR_LATIN_DEGREE    = QChar(0xB0);  // TODO: make portable
const QChar CHAR_NBSP            = QChar(0xA0);  // TODO: make portable

///////////////////////////////////////////////////////////////////
// file locations and stuff

const QString ID_FILE_EXT               = "qbrew";
const QString ID_FILE_FILTER
    = ID_TITLE + " files (*." + ID_FILE_EXT + ");;All files (*)";
const QString ID_PREFERENCES_FILE       = ".qbrewrc";
const QString ID_HELP_FILE              = "qbrew-handbook.html";
const QString ID_PRIMER_FILE            = "primer.html";
const QString ID_DEFAULT_FILE           = "untitled";

// define file format versions
const QString QBREW_PREVIOUS        = "0.1.7";

//////////////////////////////////////////////////////////////////////////////
// XML Format Strings

// TODO: keep these tags with calc.h
const QString tagRecipe             = "recipe";
const QString attrGenerator         = "generator";
const QString tagTitle              = "title";
const QString tagBrewer             = "brewer";
const QString tagBatch              = "batch";
const QString attrSize              = "size"; // TODO: deprecated tag (2.1 prev)
const QString attrMash              = "mash";
const QString tagNotes              = "notes";
const QString attrClass             = "class";
const QString classRecipe           = tagRecipe;
const QString classBatch            = tagBatch;

// the rest of the tags/attrs are defined in calc.h

// group types to build oldsettings hash with
const QString groupRecipe           = "RECIPE";
const int gidRecipe                 = 10010;
const QString groupDocGrains        = "GRAINS";
const int gidDocGrains              = 10011;
const QString groupDocHops          = "HOPS";
const int gidDocHops                = 10012;
const QString groupDocMisc          = "MISC";
const int gidDocMisc                = 10013;

// data fields to build oldsettings hash with
const QString fieldTitle            = "Title";
const int fidTitle                  = 10100;
const QString fieldBrewer           = "Brewer";
const int fidBrewer                 = 10101;
const QString fieldStyle            = "Style";
const int fidStyle                  = 10102;
const QString fieldSize             = "BatchSize";
const int fidSize                   = 10103;
const QString fieldMash             = "Mash";
const int fidMash                   = 10104;

///////////////////////////////////////////////////////////////////
// preferences values

const QString ID_NULL                   = "NULL";
const QString ID_PREF_STATUSBAR         = "StatusBar";
const bool ID_PREF_STATUSBAR_DEFAULT    = true;
const QString ID_PREF_TOOLBAR           = "Toolbar";
const bool ID_PREF_TOOLBAR_DEFAULT      = true;
const QString ID_PREF_APPDIR            = "QBrewDir";
const QString ID_PREF_APPDIR_DEFAULT    = QPREFIX;
const QString ID_PREF_WIDGET_STYLE      = "WidgetStyle";
 const QString ID_PREF_WIDGET_STYLE_DEFAULT  = "Qt"; // non-existant
const QString ID_PREF_BATCH             = "Batch";
const double ID_PREF_BATCH_DEFAULT      = 5.00;
const QString ID_PREF_EFFICIENCY        = "Efficiency";
const double ID_PREF_EFFICIENCY_DEFAULT = 0.75;
const QString ID_PREF_TINSETH           = "Tinseth";
const bool ID_PREF_TINSETH_DEFAULT      = false;
const QString ID_PREF_RECIPE_STYLE      = "RecipeStyle";
const QString ID_PREF_RECIPE_STYLE_DEFAULT  = "Generic Ale";
const QString ID_PREF_UNITS             = "Units";
const QString ID_PREF_UNITS_DEFAULT     = UNIT_US;
const QString ID_PREF_LARGE_ICONS       = "LargeIcons";
const bool ID_PREF_LARGE_ICONS_DEFAULT  = LARGEICONS;

}; // namespace AppResource

#endif // RESOURCE_H
