/***************************************************************************
  style.h
  -------------------
  AHA-like style class
  -------------------
  begin         September 26th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999-2002, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef STYLE_H
#define STYLE_H

#include <qvaluelist.h>

class QString;

class Style {
  public:
    // full constructor
    Style(const QString name="Generic Ale", const double &oglow=0.0,
          const double &oghi=1.0, const double &ibulow=0.0,
          const double &ibuhi=100.0, const double &srmlow=0.0,
          const double &srmhi=40.0);
    // copy constructor
    Style(const Style &s);
    // assignment operator
    Style operator=(const Style &s);
    // equivalence operator
    bool operator==(const Style &s) const;
    // destructor
    ~Style();

    // return name of style
    const QString &name();
    // return high end of OG
    double OGHi();
    // return low end of OG
    double OGLow();
    // return high end of IBU
    double IBUHi();
    // return low end of IBU
    double IBULow();
    // return high end of SRM
    double SRMHi();
    // return low end of SRM
    double SRMLow();
    
  private:
    QString name_;
    double oglow_;
    double oghi_;
    double ibulow_;
    double ibuhi_;
    double srmlow_;
    double srmhi_;
};

typedef QValueList<Style> StyleList;
typedef QValueList<Style>::Iterator StyleIterator;

//////////////////////////////////////////////////////////////////////////////
// Inlined Methods

inline const QString &Style::name() { return name_; }

inline double Style::OGHi() { return oghi_; }

inline double Style::OGLow() { return oglow_; }

inline double Style::IBUHi() { return ibuhi_; }

inline double Style::IBULow() { return ibulow_; }

inline double Style::SRMHi() { return srmhi_; }

inline double Style::SRMLow() { return srmlow_; }

#endif // STYLE_H
