/***************************************************************************
  alcoholtool.cpp
  -------------------
  An Alcohol Percentage Calculator utility for QBrew
  -------------------
  Copyright 2004-2005, David Johnson <david@usermode.org>
  Based on code Copyright 2004, Michal Palczewski <michalp@gmail.com>
  Please see the header file for copyright and license information
 ***************************************************************************/

#include <qlabel.h>
#include <qpushbutton.h>
#include <qwhatsthis.h>

#include "calc.h"
#include "fixedspinbox.h"
#include "resource.h"

#include "alcoholtool.h"

//////////////////////////////////////////////////////////////////////////////
// Constants

const double MINIMUM_GRAVITY = 0.900;
const double MAXIMUM_GRAVITY = 1.400;
const double GRAVITY_STEP = 0.001;

//////////////////////////////////////////////////////////////////////////////
// AbvcalcTool()
// ----------------
// Constructor

AlcoholTool::AlcoholTool(QWidget* parent, const char* name)
    : AlcoholDialog(parent, name, false, WDestructiveClose)
{
    setCaption(AppResource::ID_TITLE + " - Alcohol Tool");

    // additional setup for spinboxes
    oglabel->setBuddy(og);
    og->setMinimum(MINIMUM_GRAVITY);
    og->setMaximum(MAXIMUM_GRAVITY);
    og->setSingleStep(GRAVITY_STEP);
    og->setPrecision(3);
    og->setValue(1.050);
    QWhatsThis::add(og, "Enter the measured original gravity of your batch");

    fglabel->setBuddy(fg);
    fg->setMinimum(MINIMUM_GRAVITY);
    fg->setMaximum(MAXIMUM_GRAVITY);
    fg->setSingleStep(GRAVITY_STEP);
    fg->setPrecision(3);
    fg->setValue(1.010);
    QWhatsThis::add(fg, "Enter the measured final gravity of your batch");

    // connections
    connect(og, SIGNAL(valueChanged(double)), this, SLOT(recalc()));
    connect(fg, SIGNAL(valueChanged(double)), this, SLOT(recalc()));

    recalc();
}

//////////////////////////////////////////////////////////////////////////////
// recalc()
// --------
// the signal to calculate the Alcohol percentage

void AlcoholTool::recalc()
{
    abw->setText(QString::number(Calc::ABW(og->value(), fg->value()) * 100.0,
                                 'f', 1) + "%");
    abv->setText(QString::number(Calc::ABV(og->value(), fg->value()) * 100.0,
                                 'f', 1) + "%");
}
