//////////////////////////////////////////////////////////////////////////////
// configstate.h
// -------------------
// State for config dialog
// -------------------
// Copyright (c) 2004-2005 David Johnson <david@usermode.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
// IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//////////////////////////////////////////////////////////////////////////////

#ifndef CONFIGSTATE_H
#define CONFIGSTATE_H

#include <qstringlist.h>
#include "resource.h"

struct WinConfigState {
    WinConfigState() : toolbar(true), statusbar(true) { ; }
    bool toolbar;
    bool statusbar;
};

struct GenConfigState {
    GenConfigState()
        : appdir(""), lookfeel(""), largeicons(true), showsplash(true),
          autosave(true), saveinterval(5), autobackup(true), loadlast(true),
          recentnum(5), recentfiles() { ; }
    QString appdir;
    QString lookfeel;
    bool largeicons;
    bool showsplash;
    bool autosave;
    unsigned saveinterval;
    bool autobackup;
    bool loadlast;
    unsigned recentnum;
    QStringList recentfiles;
};

struct RecipeConfigState {
    RecipeConfigState()
        : batch(5.00), style("Generic Ale"), hopform("Pellet"),
         mash(false) { ; }
    double batch;
    QString style;
    QString hopform;
    bool mash;
};

struct CalcConfigState {
    CalcConfigState()
        : efficiency(0.75), morey(false), tinseth(false),
         units(AppResource::UNIT_US) { ; }
    double efficiency;
    bool morey;
    bool tinseth;
    QString units;
};

struct ConfigState
{
    WinConfigState window;
    GenConfigState general;
    RecipeConfigState recipe;
    CalcConfigState calc;
};

#endif // CONFIGSTATE_H
