/***************************************************************************
  hopdb.h
  -------------------
  A dialog page for hops
  -------------------
  Copyright 2005, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef HOPDB_H
#define HOPDB_H

#include "hopview.h"
#include "hops.h"

class Model;

class HopDB : public HopView {
   Q_OBJECT
public: 
    // constructor
    HopDB(QWidget *parent, const char *name, Model *model);
    // destructor
    virtual ~HopDB();

    // initialize list and fields
    void refresh();

signals:
    // emits on modification
    void modified();

private slots:
    // add clicked
    void addHop();    
    // remove clicked
    void removeHop();    
    // apply clicked
    void applyHop();    
    // update entry fields
    void updateFields(const QString &name);
    // an ingredient was selected
    void itemSelected(QListViewItem *item);

private:
    Model *model_;
    HopItem* currentitem_;
};

#endif // HOPDB_H
