/***************************************************************************
  notepage.cpp
  -------------------
  A dialog page for notes
  -------------------
  Copyright 2003-2005, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <qtextedit.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "model.h"

#include "notepage.h"

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// NotePage()
// ----------
// Constructor

NotePage::NotePage(QWidget *parent, const char *name, Model *model)
    : NoteView(parent, name), model_(model)
{
    // set up connections
    connect(recipeedit, SIGNAL(textChanged()),
            this, SLOT(updateRecipeNotes()));
    connect(batchedit, SIGNAL(textChanged()),
            this, SLOT(updateBatchNotes()));
}

NotePage::~NotePage() { ; }

//////////////////////////////////////////////////////////////////////////////
// refresh()
// ---------
// initialize

void NotePage::refresh()
{
    recipeedit->setText(model_->recipe()->recipeNotes());
    batchedit->setText(model_->recipe()->batchNotes());
}

//////////////////////////////////////////////////////////////////////////////
// updateRecipeNotes()
// -----------------
// Update the notes in the model

void NotePage::updateRecipeNotes()
{
    model_->recipe()->setRecipeNotes(recipeedit->text());
    model_->setModified(true);
    emit modified();
}

//////////////////////////////////////////////////////////////////////////////
// updateBatchNotes()
// -----------------
// Update the notes in the model

void NotePage::updateBatchNotes()
{
    model_->recipe()->setBatchNotes(batchedit->text());
    model_->setModified(true);
    emit modified();
}

