/***************************************************************************
                          rfile.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rfile.h 1998/09/25 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RFILE_H
#define RFILE_H

#include <qfile.h>
#include <qstring.h>
#include <qwidget.h>

/*! Copy file _source to _dest 
    \param _source String which contains absolute path of source file
    \param _dest   String which contains absolute path of destination file
    \param _what   What is this file? (A very brief description of the file for overwrite warning)
    \param _parent Parent Widget (used for overwrite warning)
    
    \return true if the file was copied
*/
bool     fileCopy(QString _source, QString _dest, const QString& _what, QWidget* _parent=0);

/*! Show file overwrite warning
    \param _file Path and name of the file
    \param _what   What is this file? (A very brief description of the file)
    \param _parent Parent Widget
    
    \return true if the user gave his OK for the overwriting
*/
bool     fileOverwriteWarning(const QString& _file, const QString& _what, QWidget* _parent=0);

/*! Delete a file with warning
    \param _file   Path and name of the file
    \param _what   What is this file? (A very brief description of the file)
    \param _parent Parent Widget
    
    \return true if the file was successfully removed
*/
bool     fileDelete(const QString& _file, const QString& _what, QWidget* _parent=0);

/*! Check file format<br>
    The file format must look like this example:<br>
    # Format: CAM Expert Font<br>
    # Version: 2.0.0<br>
    \param _file Path and name of the file
    \param _format String which must stand after "# Format:" or 0
    \param _version String which must stand after "# Version:" or 0
    
    \return true if the Format is OK
*/
bool     fileCheckFormat(const QString& _file, const QString& _format, const QString& _version=0);

/*! Get Format info
    The file format must look like this example:<br>
    # Format: CAM Expert Font<br>
    # Version: 2.0.0<br>
    \param _file Path and name of the file
    \param _name String which's value we want ("Format" for the value after "# Format:"
    
    \return The value after this string or a null string
*/
QString  fileGetFormatInfo(const QString& _file, const QString& _name );


/**
 * Searchs a file with a given subdir and a file name.
 */
QString  fileSearchFile(QString _subdir, QString _name);


/**
 * Searchs a subdir.
 */
QString  fileSearchSubdir(QString _subdir, int _prior=0);


/**
 * Replaces all strings _string with the binary pattern _bin.
 *
 * \param _len Length of the binary pattern. The pattern can
 *             contain \0 which are not the string terminator.
 */
void fileBinaryReplace(QString _fileName, QString _string, char* _bin, int _len);

/**
 * Replaces all strings _string with as many spaces as needed to 
 * fill the line to _num characters.
 *
 * \param _len Wished Length of the lines.
 * \param _char Space filling character
 */
void fileFillLines(QString _fileName, QString _string, int _len, char _char);


#endif


// EOF

