/***************************************************************************
                          rlibraryitem.cpp  -  description
                             -------------------
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Andrew Mustun
    email                : andrew@qcad.org
 ***************************************************************************/



#include "rlibraryitem.h"

#include <qapplication.h>
#include <qfileinfo.h>
#include <qlabel.h>

#include "rconfig.h"
#include "rgraphic.h"

RLibraryItem::RLibraryItem(QWidget *_parent, const char *_name )
  : RWidget(_parent,_name)
{
  graphic = new RGraphic( this, "graphic" );
  graphic->delFlag( G_GRID );
  graphic->setFlag( G_PREVIEW );
  graphic->disableEvents();
  connect( graphic, SIGNAL(mousePressed()), this, SLOT(slotActivated()) );

  label = new QLabel( this, "label" );
  label->setFont( RCONFIG->getFont(3) );
  label->setBackgroundColor( qApp->palette().normal().button() );
  label->setFrameStyle( WinPanel|Sunken );

  RLOG("\nLibrary Item constructed");
}


RLibraryItem::~RLibraryItem()
{
  RLOG("\nLibrary Item destructed");
}


/** Resize event:
*/
void
RLibraryItem::resizeEvent(QResizeEvent* _ev)
{
  RWidget::resizeEvent(_ev);
  resizeChildren();
}



/** Resize the children:
*/
void
RLibraryItem::resizeChildren()
{
  int labelHeight = RCONFIG->getSettingInt("Application:FontSize3")+6;

  graphic->setGeometry( 0, 0, width(), height()-labelHeight+1 );
  label->setGeometry( 0, height()-labelHeight, width(), labelHeight );
}


/** Sets a (DXF) file for this item. The file gets immediately loaded
    and shown in auto zoom mode.
*/
void
RLibraryItem::setFile( QFileInfo _file )
{
  label->setText( _file.baseName() );
  if( graphic->loadFile( _file.absFilePath() ) ) {
    RLOG("\nItem graphic loaded: ");
    RLOG( _file.absFilePath() );
    graphic->zoomAuto( 0, 6 );
    graphic->repaint();
  }
  else {
    RLOG("\nItem graphic NOT loaded: ");
    RLOG( _file.absFilePath() );
  }
}



/** Checks if the graphic of this item is selected.
*/
bool
RLibraryItem::isActive()
{
  if(graphic) return graphic->isActive();
  else return false;
}



/** Sets or clears the active flag for this item and updates the view.
*/
void
RLibraryItem::setActive( bool _on )
{
  if(graphic->isActive()!=_on) {
    graphic->setActive( _on );
    graphic->drawActiveBorder( _on );

    if(_on) label->setBackgroundColor( qApp->palette().normal().light() );
    else    label->setBackgroundColor( qApp->palette().normal().button() );
  }
}


/** Gets the reference height from the graphic.
*/
QString
RLibraryItem::getReferenceValue( QChar _code )
{
  QString layer = QString("_stretch_") + _code;
  QString elLayer;
  QString ret="";

  for( RElement* el=graphic->elementFirst(); el!=0; el=graphic->elementNext() ) {
    elLayer = graphic->getLayerName(el->getLayer());
    if( elLayer.left(10)==layer ) {
      ret=elLayer.right( elLayer.length()-12 );
      break;
    }
  }

  return ret;
}





















