/***************************************************************************
                          opmltree.hpp  -  description
                             -------------------
    begin                : Tue 20 JAN  12 16:54:22 CET 2007
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPMLTREE_H
#define OPMLTREE_H

/**
	@author Harald Krippel <harald@the-develop.net>
*/

#include <QDomDocument>
#include "listviews.hpp"

class OpmlTree : public QTreeWidget
{
    Q_OBJECT

public:
    OpmlTree(QWidget *parent = 0);

    bool read(QIODevice *device);
    bool write(QIODevice *device);
    FolderListItem * getStart();

private:
    int  getScene();


private slots:
    void updateDomElement(QTreeWidgetItem *item, int column);
    void slotRMB( const QPoint & pos );
    void slotDelete();

    void slotAddScene();
    void slotLoadObject();
    void slotAddBarrier();
    void slotAddBody(); 
    void slotAddFire();
    void slotAddPartSys();
    void slotAddWaveSys();
    void slotAddCamera();
    void slotViewCamera();
    void slotAddFog();
    void slotAddPlayer();
    void slotAddSky();
    void slotAddShader();
    void slotAddCursor();
    void slotAddSpl();
    void slotAddQts();
    void slotAddSound();
    void slotAddGUITXT();
    void slotAddGUIInput();
    void slotAddGUIButton();
    void slotAddGUIOSButton();
    void slotAddLamp();

private:
    void parseFolderElement(const QDomElement &element, FolderListItem *parentItem = 0 );
    void getListView(QDomDocument *domdoc);
//    void buildTopDomTree(QDomElement *parentElement, QDomDocument *domdoc);
    void buildDomTree( QDomElement *parentElement, FolderListItem *parentItem, QDomDocument *domdoc );
    void initRMB();

    QDomDocument domDocument;
    QTreeWidgetItem *folderitem;
//    QHash<FolderListItem *, QDomElement> domElementForItem;
//    QIcon folderIcon;
//    QIcon bookmarkIcon;

    QAction* rmbAddScene;
    QAction* rmbLoadObject;
    QAction* rmbAddBarrier;
    QAction* rmbAddBody;
    QAction* rmbAddFire;
    QAction* rmbAddPartSys;
    QAction* rmbAddWaveSys;
    QAction* rmbAddCamera;
    QAction* rmbViewCamera;
    QAction* rmbAddFog;
    QAction* rmbAddPlayer;
    QAction* rmbAddSky;
    QAction* rmbAddShader;
    QAction* rmbAddCursor;
    QAction* rmbAddSpl;
    QAction* rmbAddQts;
    QAction* rmbAddSound;
    QAction* rmbAddGUITXT;
    QAction* rmbAddGUIInput;
    QAction* rmbAddGUIButton;
    QAction* rmbAddGUIOSButton;
    QAction* rmbAddLamp;
    QAction* rmbDelete;
};

#endif
