/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/

#ifndef AUXILIAR_CPP
#define AUXILIAR_CPP

#include "auxiliar.h"

//Variables to adjust
int Auxiliar::debugLevel=0;
QString Auxiliar::version = "0.5d";
QString Auxiliar::host = "www.catalandictionary.org";
QString Auxiliar::url = "/qdaccoReport.php";
QString Auxiliar::dictionaries_directory = "/usr/share/dacco-common/dictionaries";

QString Auxiliar::getDictionariesDirectory() {
	return dictionaries_directory;
}

QString Auxiliar::getVersion() {
	return version;
}

QString Auxiliar::getHost() {
	return host;
}

QString Auxiliar::getURL() {
	return url;
}

void Auxiliar::setDebug(int i) {
	debugLevel=i;
}

int Auxiliar::getDebug() {
	return debugLevel;
}

void Auxiliar::debug(QString s) {
	if (debugLevel) {
		printf("Debug: %s\n",qPrintable(s));
	}
}

bool Auxiliar::isWindows() {
	//is it not possible to know in run time?? ?
	#if defined(Q_OS_WIN32)
	return true;
	#else
	return false;
	#endif
}

#endif
