/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the <your project> project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "accessibleapplication.h"
#include "accessibleapplicationadaptor.h"

#include <QtGui/qapplication.h>
#include <QtGui/qwidget.h>
#include <QtCore/qdebug.h>

AccessibleApplication::AccessibleApplication()
    : AccessibleObject(QLatin1String("/org/freedesktop/accessibility"), QApplication::instance(), 0)
{
    new AccessibleApplicationAdaptor(this);
    QDBusConnection::sessionBus().connect(QString(), QString("/org/freedesktop/accessibility"),
             "org.freedesktop.accessibility", "ping", this, SLOT(pingReceived(QDBusMessage)));
}

void AccessibleApplication::pingReceived(const QDBusMessage &sender)
{
    QDBusConnection::sessionBus().send(
            QDBusMessage::createSignal(QString("/org/freedesktop/accessibility"),
                                       "org.freedesktop.accessibility", "pong"));
}

void AccessibleApplication::initAccessibility()
{
    connect(QApplication::instance(), SIGNAL(focusChanged(QWidget*,QWidget*)),
            this, SLOT(focusChanged(QWidget*,QWidget*)));
    QApplication::instance()->installEventFilter(this);
}

bool AccessibleApplication::eventFilter(QObject *obj, QEvent *event)
{
    switch (event->type()) {
    case QEvent::Create:
    case QEvent::ChildAdded: {
        QObject *newParent = static_cast<QChildEvent *>(event)->child()->parent();
        AccessibleObject *accObject = newParent
                ? AccessibleObject::exportedObject(newParent)
                : this;
        if (accObject)
            accObject->setChildrenDirty();
        break; }
    case QEvent::ChildRemoved:
        delete AccessibleObject::exportedObject(static_cast<QChildEvent *>(event)->child());
        break;
    case QEvent::Show:
        emit objectShown(QDBusObjectPath(ensureExported(obj)->path()));
        break;
    default:
        break;
    }
    return AccessibleObject::eventFilter(obj, event);
}

void AccessibleApplication::focusChanged(QWidget *, QWidget *now)
{
    AccessibleObject *accObject = AccessibleObject::ensureExported(now);
    if (!accObject)
        emit focusChanged(QString());
    else
        emit focusChanged(accObject->path());
}

QObjectList AccessibleApplication::clientChildren() const
{
    QWidgetList topLevels = QApplication::topLevelWidgets();
    return *reinterpret_cast<QList<QObject *> *>(&topLevels);
}

// debugging only
void AccessibleApplication::exportAll(AccessibleObject *obj)
{
    if (!obj)
        obj = this;
    obj->updateChildren();
    foreach (AccessibleObject *child, obj->findChildren<AccessibleObject *>())
        exportAll(child);
}

QString AccessibleApplication::toolkitName() const
{
    return QLatin1String("Qt");
}

QString AccessibleApplication::toolkitVersion() const
{
    return QLatin1String(QT_VERSION_STR);
}

QString AccessibleApplication::hitTest(int x, int y)
{
    AccessibleObject *accObj = ensureExported(QApplication::widgetAt(x, y));
    if (!accObj)
        return QString();
    return accObj->path();
}

QString AccessibleApplication::appName() const
{
    return QApplication::applicationName();
}

QString AccessibleApplication::appVersion() const
{
    // TODO - find out the app version
    return QString();
}
