/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "accessiblevalueadaptor.h"
#include "accessibleobject.h"

#include <qaccessible2.h>

AccessibleValueAdaptor::AccessibleValueAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    Q_ASSERT(qobject_cast<AccessibleObject *>(parent));
}

AccessibleValueAdaptor::~AccessibleValueAdaptor()
{
}

static inline QAccessibleValueInterface *valueInterface(QObject *parent)
{
    return static_cast<AccessibleObject *>(parent)->accessibleInterface()->valueInterface();
}

QDBusVariant AccessibleValueAdaptor::minimumValue()
{
    return QDBusVariant(valueInterface(parent())->minimumValue());
}

QDBusVariant AccessibleValueAdaptor::maximumValue()
{
    return QDBusVariant(valueInterface(parent())->maximumValue());
}

QDBusVariant AccessibleValueAdaptor::currentValue()
{
    return QDBusVariant(valueInterface(parent())->currentValue());
}

void AccessibleValueAdaptor::setCurrentValue(const QDBusVariant &value)
{
    valueInterface(parent())->setCurrentValue(value.variant());
}

