/*
	Copyright 2006-2015 The QElectroTech Team
	This file is part of QElectroTech.
	
	QElectroTech is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the License, or
	(at your option) any later version.
	
	QElectroTech is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with QElectroTech.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef QET_ICONS_H
#define QET_ICONS_H
#include <QIcon>
/**
	This namespace is meant to delare icons used within the QElectroTech
	application.
*/
namespace QET {
	namespace Icons {
		void initIcons();
		
		// using the extern keyword enables access to static objects from outside the
		// namespace
		extern QIcon Add;
		extern QIcon Allowed;
		extern QIcon ApplicationExit;
		extern QIcon ArrowLeft;
		extern QIcon ArrowLeftDouble;
		extern QIcon ArrowRight;
		extern QIcon ArrowRightDouble;
		extern QIcon Autoconnect;
		extern QIcon BringForward;
		extern QIcon Cancel;
		extern QIcon Conductor;
		extern QIcon ConductorSettings;
		extern QIcon Configure;
		extern QIcon ConfigureToolbars;
		extern QIcon CopyFile;
		extern QIcon DefaultConductor;
		extern QIcon DiagramAdd;
		extern QIcon Diagram;
		extern QIcon DiagramDelete;
		extern QIcon DialogCancel;
		extern QIcon DialogInformation;
		extern QIcon DialogOk;
		extern QIcon DocumentClose;
		extern QIcon DocumentExport;
		extern QIcon DocumentImport;
		extern QIcon DocumentNew;
		extern QIcon DocumentOpen;
		extern QIcon DocumentOpenRecent;
		extern QIcon DocumentPrint;
		extern QIcon DocumentPrintFrame;
		extern QIcon DocumentSave;
		extern QIcon DocumentSaveAll;
		extern QIcon DocumentSaveAs;
		extern QIcon East;
		extern QIcon EditClear;
		extern QIcon EditClearLocationBar;
		extern QIcon EditCopy;
		extern QIcon EditCut;
		extern QIcon EditDelete;
		extern QIcon EditPaste;
		extern QIcon EditRedo;
		extern QIcon EditRename;
		extern QIcon EditSelectAll;
		extern QIcon EditTableCellMerge;
		extern QIcon EditTableCellSplit;
		extern QIcon EditTableDeleteColumn;
		extern QIcon EditTableDeleteRow;
		extern QIcon EditTableInsertColumnLeft;
		extern QIcon EditTableInsertColumnRight;
		extern QIcon EditTableInsertRowAbove;
		extern QIcon EditTableInsertRowUnder;
		extern QIcon EditText;
		extern QIcon EditUndo;
		extern QIcon Element;
		extern QIcon ElementDelete;
		extern QIcon ElementEdit;
		extern QIcon ElementNew;
		extern QIcon EndLineCircle;
		extern QIcon EndLineDiamond;
		extern QIcon EndLineNone;
		extern QIcon EndLineSimple;
		extern QIcon EndLineTriangle;
		extern QIcon EPS;
		extern QIcon Folder;
		extern QIcon FolderDelete;
		extern QIcon FolderEdit;
		extern QIcon FolderNew;
		extern QIcon Forbidden;
		extern QIcon FullScreenEnter;
		extern QIcon FullScreenExit;
		extern QIcon GoDown;
		extern QIcon GoUp;
		extern QIcon Ground;
		extern QIcon Hide;
		extern QIcon Home;
		extern QIcon HotSpot;
		extern QIcon InsertImage;
		extern QIcon Lower;
		extern QIcon MoveFile;
		extern QIcon Names;
		extern QIcon Neutral;
		extern QIcon NewDiagram;
		extern QIcon NewDiagram;
		extern QIcon NewDiagram;
		extern QIcon North;
		extern QIcon ObjectLocked;
		extern QIcon ObjectRotateRight;
		extern QIcon ObjectUnlocked;
		extern QIcon Orientations;
		extern QIcon PartArc;
		extern QIcon PartCircle;
		extern QIcon PartEllipse;
		extern QIcon PartLine;
		extern QIcon PartPolygon;
		extern QIcon PartRectangle;
		extern QIcon PartSelect;
		extern QIcon PartText;
		extern QIcon PartTextField;
		extern QIcon PDF;
		extern QIcon Phase;
		extern QIcon PrintAllPages;
		extern QIcon Printer;
		extern QIcon PrintLandscape;
		extern QIcon PrintPortrait;
		extern QIcon PrintTwoPages;
		extern QIcon Project;
		extern QIcon ProjectFile;
		extern QIcon QETIcon;
		extern QIcon QETLogo;
		extern QIcon QETOxygenLogo;
		extern QIcon QtLogo;
		extern QIcon Raise;
		extern QIcon Remove;
		extern QIcon Restore;
		extern QIcon SendBackward;
		extern QIcon Settings;
		extern QIcon SinglePage;
		extern QIcon South;
		extern QIcon Start;
		extern QIcon Terminal;
		extern QIcon TitleBlock;
		extern QIcon UserInformations;
		extern QIcon ViewFitWidth;
		extern QIcon ViewFitWindow;
		extern QIcon ViewMove;
		extern QIcon ViewRefresh;
		extern QIcon West;
		extern QIcon WindowNew;
		extern QIcon XmlTextFile;
		extern QIcon ZoomDraw;
		extern QIcon ZoomFitBest;
		extern QIcon ZoomIn;
		extern QIcon ZoomOriginal;
		extern QIcon ZoomOut;
		extern QIcon adding_image;
		extern QIcon resize_image;
		extern QIcon ar;
		extern QIcon catalonia;
		extern QIcon cs;
		extern QIcon de;
		extern QIcon gr;
		extern QIcon en;
		extern QIcon es;
		extern QIcon fr;
		extern QIcon hr;
		extern QIcon it;
		extern QIcon pl;
		extern QIcon pt;
		extern QIcon ro;
		extern QIcon ru;
		extern QIcon sl;
		extern QIcon nl;
		extern QIcon be;
		extern QIcon translation;
		extern QIcon listDrawings;
		extern QIcon AutoNum;
	}
}
#endif
