/***************************************************************************
                          qgssymbol.h  -  description
                             -------------------
    begin                : Sat Jun 22 2002
    copyright            : (C) 2002 by Gary E.Sherman
    email                : sherman at mrcc.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgssymbol.h,v 1.16 2005/04/02 09:45:53 rabla Exp $ */

#ifndef QGSSYMBOL_H
#define QGSSYMBOL_H

#include <iostream>

#include <qbrush.h>
#include <qpen.h>
#include <qpixmap.h>
#include <qpicture.h>
#include <qdom.h>

class QString;

/**Encapsulates settings for drawing*/
class QgsSymbol{

 public:
    /**Constructor*/
    QgsSymbol();
    /**Constructor*/
    QgsSymbol(QColor c);
    /**Sets the brush*/
    virtual void setBrush(QBrush b);
    /**Gets a reference to m_brush, Don't use the brush to change color/style */
    virtual QBrush& brush();
    /**Set the color*/
    virtual void setColor(QColor c);
    /**Get the current color*/
    virtual QColor color() const;
    /**Get the fill color*/
    virtual QColor fillColor() const;
    /**Sets the fill color*/
    virtual void setFillColor(QColor c);
    /**Get the line width*/
    virtual int lineWidth() const;
    /**Sets the line width*/
    virtual void setLineWidth(int w);
    /**Sets the pen*/
    virtual void setPen(QPen p);
    /**Gets a reference to m_pen. Don't use the pen to change color/style  */
    virtual QPen& pen();

    /**Set the line (pen) style*/
    virtual void setLineStyle(Qt::PenStyle s);
    /**Set the fill (brush) style*/
    virtual void setFillStyle(Qt::BrushStyle s);

    /**Set point symbol from name*/
    virtual void setNamedPointSymbol(QString name);
    /**Get point symbol*/
    virtual QString pointSymbolName() const;
    /**Set size*/
    virtual void setPointSize(int s);
    /**Get size*/
    virtual int pointSize() const;
    //! Destructor
    virtual ~QgsSymbol();
    //! Get a little icon / image representation of this symbol
    virtual QPixmap getSymbolAsPixmap(int xDim, int yDim);

    //! Get a little icon / image representation of point symbol with current settings
    virtual QPixmap getPointSymbolAsPixmap(int oversampling = 1);
    
    /** Get QPicture representation of point symbol with current settings
      * \param oversampling oversampling factor
      *        >= 1 -> returns mPointSymbolPicture, widthScale ignored
      *        0    -> returns mPointSymbolPicture2, with widthScale
      */
    virtual QPicture getPointSymbolAsPicture(int oversampling = 1, double widthScale = 1., 
	               bool selected = false, QColor selectionColor = Qt::yellow );

    /**Writes the contents of the symbol to a configuration file
     @ return true in case of success*/
    virtual bool writeXML( QDomNode & item, QDomDocument & document );
    /**Reads the contents of the symbol from a configuration file
     @ return true in case of success*/
    virtual bool readXML( QDomNode & symbol );
 protected:
    QPen mPen;
    QBrush mBrush;
    /* Point symbol name */
    QString mPointSymbolName;
    /* Point size */
    int mPointSize; 

    /* TODO Because for printing we always need a symbol without oversampling but with line width scale, 
     *      we keep also separate picture with line width scale */

    /* Oversampling used for current mPointSymbolPixmap and mPointSymbolPicture */
    int mOversampling;
     
    /* Point symbol cache with oversampling mOversampling  */
    QPixmap mPointSymbolPixmap;

    /* Point symbol cache with oversampling mOversampling (but vector if mOversampling == 1) */
    QPicture mPointSymbolPicture;
    QPicture mPointSymbolPictureSelected;

    /* Current line width scale used by mPointSymbolVectorPicture */
    double mWidthScale;
    
    /* Point symbol cache without oversampling (always vector picture) but with line width scale mWidthScale */
    QPicture mPointSymbolPicture2;
    QPicture mPointSymbolPictureSelected2;
    
    /* Create point symbol mPointSymbolPixmap/mPointSymbolPicture cache */
    void cache( int oversampling, QColor selectionColor );

    /* Create point symbol mPointSymbolPicture2 cache */
    void cache2( double widthScale, QColor selectionColor );

    /* mPointSymbolPixmap/mPointSymbolPicture cache updated */
    bool mCacheUpToDate;

    /* mPointSymbolPicture2 cache updated */
    bool mCacheUpToDate2;

    /* Selection color used in cache */
    QColor mSelectionColor;
    QColor mSelectionColor2;
};

inline void QgsSymbol::setBrush(QBrush b)
{
    mBrush=b;
}

inline QBrush& QgsSymbol::brush()
{
    return mBrush;
}

inline void QgsSymbol::setPen(QPen p)
{
    mPen=p;
}

inline QPen& QgsSymbol::pen()
{
    return mPen;
}

#endif // QGSSYMBOL_H


