#!/usr/bin/perl
use Cwd;

#####################################################
# A script to automate creation of a new QGIS plugin
# using the plugin_template
# Authors GSherman TSutton
# Feb 21, 2004
#####################################################
# $Id: plugin_builder.pl 5212 2006-04-07 23:21:38Z timlinux $ #

#make sure we are in a the plugins directory otherwise the changes this script will make will 
#wreak havoc....
$myDir = fastgetcwd;
print "\n\nChecking that we are in the <qgis dir>/src/plugins/ directory....";
if ($myDir =~ m/src\/plugins$/) {
  print "yes\n";
}else {
  print "no\n";
  print $myDir;
  print "\nPlease relocate to the plugins directory before attempting to run this script.\n";
  exit;
}
# get the needed information from the user
print "\n\nEnter the directory name under qgis/src/plugins/ where your new plugin will be created.\n";
print "We suggest using a lowercase underscore separated name e.g. clever_plugin\n";
print "Directory for the new plugin:";
$pluginDir =<STDIN>;
chop $pluginDir;

print "\n\nEnter the name that will be used when creating the plugin library.\n";
print "The name should be entered as a mixed case name with no spaces. e.g. CleverTool\n";
print "The plugin name will be used in the following ways:\n";
print "1) it will be 'lower cased' and used as the root of the generated lib name \n";
print "   e.g. libqgis_plugin_clevertool\n";
print "2) in its upper cased form it will be used as the basis for class names, in particular\n";
print "   CleverToolGuiBase <- The base class for the plugins configuration dialog / gui generated by uic\n";
print "   CleverToolGui     <- The concrete class for the plugins configuration dialog\n";
print "3) CleverTool     <- The class that includes the plugin loader instructions and\n";
print "                     and calls to your custom application logic\n";
print "4) clevertool.h, clevertool.cpp  etc. <- the filenames used to hold the above derived classes\n";
print "Plugin name: " ;
$pluginName = <STDIN>;
chop $pluginName;
$pluginLCaseName = lc($pluginName); #todo convert to lower case 

print "\n\nEnter a short description (typically one line)\n";
print "e.g. The clever plugin does clever stuff in QGIS\n";
print "Plugin description: " ;
$pluginDescription = <STDIN>;
chop $pluginDescription;

print "\n\n Enter the name of the application menu that will be created for your plugin\n";
print "Clever Tools\n";
print "Menu name: ";
$menuName = <STDIN>;
chop $menuName;

print "\n\n Enter the name of the menu entry  (under the menu that you have just defined) that\n";
print "will be used to invoke your plugin. e.g. Clever Plugin\n";
print "Menu item name: ";
$menuItemName = <STDIN>;
chop $menuItemName;

# print a summary of what's about to happen
print << "EOF";

Summary of plugin parameters:
---------------------------------------------
Plugin directory      $pluginDir
Name of the plugin:   $pluginName
Library name of the plugin:   libqgis_plugin_$pluginLCaseName
Description of the plugin:   $pluginDescription
Menu name:            $menuName
Menu item name:       $menuItemName

Warning - Proceeding will make changes to Makefile.am in this directory,
as well as ../../configure.in. Please use caution.
EOF
# ask if we should proceed
print "Create the plugin? [y/n]: ";
$createIt = <STDIN>;
chop $createIt;

if(($createIt eq 'y') || ($createIt eq 'Y')){
  #
  # its a go -- create the plugin and modify the build files
  #
  # create the new plugin directory
  system("mkdir $pluginDir");
  # copy files to appropriate names
  system("cp plugin_template/Makefile.am $pluginDir/");
  system("cp plugin_template/README.whatnext $pluginDir/README");
  system("cp plugin_template/plugin.qrc $pluginDir/$pluginLCaseName.qrc");
  system("cp plugin_template/plugin.png $pluginDir/$pluginLCaseName.png");
  system("cp plugin_template/plugin.cpp $pluginDir/$pluginLCaseName.cpp");
  system("cp plugin_template/plugin.h $pluginDir/$pluginLCaseName.h");
  system("cp plugin_template/plugingui.cpp $pluginDir/${pluginLCaseName}gui.cpp");
  system("cp plugin_template/plugingui.h $pluginDir/${pluginLCaseName}gui.h");
  system("cp plugin_template/pluginguibase.ui $pluginDir/${pluginLCaseName}guibase.ui");
  system("cp plugin_template/pluginguibase.ui.h $pluginDir/${pluginLCaseName}guibase.ui.h");
  
  # Substitute the plugin specific vars in the various files
  # This is a brute force approach but its quick and dirty :)
  #
  # replace [pluginlcasename] in template with the new plugin name
  system("perl -pi -e 's/\\\[pluginlcasename\\\]/$pluginLCaseName/g' $pluginDir/*.qrc $pluginDir/*.cpp $pluginDir/*.h $pluginDir/*.am $pluginDir/*.ui");
  # replace [pluginname] in template with the new plugin name
  system("perl -pi -e 's/\\\[pluginname\\\]/$pluginName/g' $pluginDir/*.cpp $pluginDir/*.h $pluginDir/*.am $pluginDir/*.ui");
  # replace [plugindescription] in template with the description
  system("perl -pi -e 's/\\\[plugindescription\\\]/$pluginDescription/g' $pluginDir/*.cpp $pluginDir/*.h $pluginDir/*.am");
  # replace [menuname] in the template with the menu name
  system("perl -pi -e 's/\\\[menuname\\\]/$menuName/g' $pluginDir/*.cpp $pluginDir/*.h $pluginDir/*.am");
  # replace [menuitemname] in the template with the menu item name
  system("perl -pi -e 's/\\\[menuitemname\\\]/$menuItemName/g' $pluginDir/*.cpp $pluginDir/*.h $pluginDir/*.am");
  
  # Add an entry to qgis/plugins/Makefile.am
  # We won't add it the EXTRA_DIST since we don't want to necesarily distribute
  # third party plugins
  open MAKEFILE, "<./Makefile.am" || die 'Unable to open Makefile.am';
  open MAKEFILEMOD, ">./Makefile.am.mod" || die 'Unable to create Makefile.am.mod';
  # read through Makefile.am and write each line to Makefile.am.mod
  while(<MAKEFILE>){
    if(/^\s*SUBDIRS =*/){
      # add our plugin dir to the next line after SUBDIRS line
      print MAKEFILEMOD;
      print MAKEFILEMOD "\t\t$pluginDir \\\n";
    }else{
      print MAKEFILEMOD;
    }
  }
  # close the Makefile file handles
  close MAKEFILEMOD;
  close MAKEFILE;
  
  # save Makefile.am in case we die before done moving things around
  system("mv Makefile.am Makefile.am.save");
  # move the new Makefile.am to where it belongs
  system("mv Makefile.am.mod Makefile.am");
  # delete the original Makefile.am
  unlink("Makefile.am.save");

  # Add an entry to qgis/configure.in
  # Do we really want to do this or add a message telling the user how to do
  # it?
  open CONFIGUREIN, "<../../configure.in" || die 'Unable to open ../../configure.in';
  open CONFIGUREINMOD, ">../../configure.in.mod" || die 'Unable to create ../../configure.in.mod';
  # read through configure.in until we find the AC_CONFIG_FILES section
   while(<CONFIGUREIN>){
    if(/^\s*AC_CONFIG_FILES*/){
      # set the flag so we can look for the closing ])
      $inConfigFile = 1;
      print CONFIGUREINMOD;
      
    }else{
      if($inConfigFile){
        if(/^\s*\]\)*/){
          # write our entry 
          print CONFIGUREINMOD "\tsrc/plugins/$pluginDir/Makefile\n";
          $inConfigFile = 0;
        }
      }
      print CONFIGUREINMOD;
    }
  }
  close CONFIGUREIN;
  close CONFIGUREINMOD;
  
   # save configure.in in case we die before done moving things around
  system("mv ../../configure.in ../../configure.in.save");
  # move the new configure.in to where it belongs
  system("mv ../../configure.in.mod ../../configure.in");
  # delete the original configure.in
  unlink("../../configure.in.save");
  
# print out some end of processing info
print << "EOP";

Your plugin ($pluginName) has been created in $pluginDir.
Makefile.am and configure.in have been modified.
To build the plugin, you must change to the top level of the source tree and
run autoreconf, configure, then make.

Once your plugin has successfully built, please see $pluginDir/README for 
hints on how to get started.

EOP

}else{
  # user cancelled
  print "Plugin not created\n";
}

