/***************************************************************************
                          qgsspitplugin.h 
 Shapefile to PostgreSQL Import Tool plugin 
                             -------------------
    begin                : Jan 30, 2004
    copyright            : (C) 2004 by Gary E.Sherman
    email                : sherman at mrcc.com
  
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 /*  $Id: qgsspitplugin.h 5450 2006-05-14 04:54:03Z g_j_m $ */
#ifndef QGSSPITPLUGIN_H
#define QGSSPITPLUGIN_H
#include "../qgisplugin.h"

extern "C"
{
#include <libpq-fe.h>
}

#include "qgisapp.h"

/**
* \class QgsSpitPlugin
* \brief SPIT PostgreSQL/PostGIS plugin for QGIS
*
*/
class QgsSpitPlugin:public QObject, public QgisPlugin
{
  Q_OBJECT public:
/** 
* Constructor for a plugin. The QgisApp and QgisIface pointers are passed by 
* QGIS when it attempts to instantiate the plugin.
* @param qgis Pointer to the QgisApp object
* @param qI Pointer to the QgisIface object. 
*/
    QgsSpitPlugin(QgisApp * qgis, QgisIface * qI);

    //! Destructor
      virtual ~ QgsSpitPlugin();
    public slots:
    //! init the gui
    virtual void initGui();
    void spit();
    //! unload the plugin
    void unload();
  private:
//! Name of the plugin
      QString pName;
    //! Version
    QString pVersion;
    //! Descrption of the plugin
    QString pDescription;
    //! Plugin type as defined in QgisPlugin::PLUGINTYPE
    int ptype;
    //! Pionter to QGIS main application object
    QgisApp *qgisMainWindow;
    //! Pointer to the QGIS interface object
    QgisIface *qI;
    //! Pointer to the QAction used in the menu and on the toolbar
    QAction *spitAction;
};

#endif
