# -*- coding: utf-8 -*-

"""
***************************************************************************
    acceptable_missing_doc.py
    ---------------------
    Date                 : March 2016
    Copyright            : (C) 2016 by Stéphane Brunner
    Email                : stephane dot brunner at camptocamp dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Stéphane Brunner'
__date__ = 'March 2016'
__copyright__ = '(C) 2016, Stéphane Brunner'

# -*- coding: utf-8 -*-
"""
The list of acceptable documentation missing
"""
__author__ = 'Stéphane Brunner'
__date__ = '18/03/2016'
__copyright__ = 'Copyright 2016, The QGIS Project'

ACCEPTABLE_MISSING_DOCS = {
    "QgsFeatureRequest": ["Flag"],
    "QgsValueRelationSearchWidgetWrapper": ["value() const"],
    "QgsRasterFileWriter": ["setPyramidsConfigOptions(const QStringList &list)", "createOptions() const", "tiledMode() const", "buildPyramidsFlag() const", "outputFormat() const", "outputProviderKey() const", "pyramidsFormat() const", "setOutputFormat(const QString &format)", "pyramidsResampling() const", "setCreateOptions(const QStringList &list)", "setPyramidsList(const QList< int > &list)", "setPyramidsResampling(const QString &str)", "maxTileWidth() const", "setMaxTileWidth(int w)", "setTiledMode(bool t)", "setMaxTileHeight(int h)", "Mode", "QgsRasterFileWriter(const QString &outputUrl)", "setPyramidsFormat(QgsRaster::RasterPyramidsFormat f)", "WriterError", "setBuildPyramidsFlag(QgsRaster::RasterBuildPyramids f)", "maxTileHeight() const", "setOutputProviderKey(const QString &key)", "pyramidsList() const", "pyramidsConfigOptions() const"],
    "QgsSingleBandPseudoColorRenderer": ["classificationMin() const", "create(const QDomElement &elem, QgsRasterInterface *input)", "classificationMax() const", "setClassificationMax(double max)", "setClassificationMin(double min)"],
    "QgsVectorFileWriter::StringOption": ["StringOption(const QString &docString, const QString &defaultValue=QString())"],
    "QgsPenCapStyleComboBox": ["setPenCapStyle(Qt::PenCapStyle style)", "penCapStyle() const", "QgsPenCapStyleComboBox(QWidget *parent=nullptr)"],
    "QgsAttributeEditorElement": ["AttributeEditorType"],
    "QgsDataDefinedValueDialog": ["dataDefinedChanged()"],
    "QgsOWSSourceSelect": ["enableLayersForCrs(QTreeWidgetItem *item)"],
    "QgsAttributeFormInterface": ["featureChanged()", "form()", "acceptChanges(const QgsFeature &feature)", "QgsAttributeFormInterface(QgsAttributeForm *form)", "initForm()", "feature()"],
    "QgsAttributeActionDialog": ["attributeTableWidgetStyle() const", "QgsAttributeActionDialog(const QgsActionManager &actions, QWidget *parent=nullptr)", "init(const QgsActionManager &action, const QgsAttributeTableConfig &attributeTableConfig)", "actions() const", "showWidgetInAttributeTable() const"],
    "QgsFeatureRenderer": ["setUsingSymbolLevels(bool usingSymbolLevels)", "type() const", "QgsFeatureRenderer(const QString &type)", "usingSymbolLevels() const"],
    "QgsGeometryContainedCheckError": ["QgsGeometryContainedCheckError(const QgsGeometryCheck *check, const QgsGeometryCheckerUtils::LayerFeature &layerFeature, const QgsPointXY &errorLocation, const QgsGeometryCheckerUtils::LayerFeature &containingFeature)", "containingFeature() const"],
    "QgsDetailedItemWidget": ["setData(const QgsDetailedItemData &data)", "setChecked(bool flag)"],
    "QgsRuleBasedLabeling": ["rootRule() const", "rootRule()"],
    "QgsFeatureSelectionModel": ["setFeatureSelectionManager(QgsIFeatureSelectionManager *featureSelectionManager)", "QgsFeatureSelectionModel(QAbstractItemModel *model, QgsFeatureModel *featureModel, QgsIFeatureSelectionManager *featureSelectionHandler, QObject *parent)"],
    "QgsVectorLayerEditPassthrough": ["QgsVectorLayerEditPassthrough(QgsVectorLayer *layer)"],
    "QgsLayerTreeGroup": ["nodeVisibilityChanged(QgsLayerTreeNode *node)", "QgsLayerTreeGroup(const QgsLayerTreeGroup &other)"],
    "QgsLayerItem": ["iconRaster()", "iconDefault()", "iconPoint()", "iconPolygon()", "iconTable()", "iconLine()"],
    "QgsRuleBasedRenderer::Rule": ["setLabel(const QString &label)", "dependsOnScale() const", "label() const", "symbol()", "save(QDomDocument &doc, QgsSymbolMap &symbolMap) const", "initFilter()"],
    "QgsMapSettings": ["readXml(QDomNode &node)", "updateDerived()", "mapToPixel() const", "writeXml(QDomNode &node, QDomDocument &doc)"],
    "QgsSingleCategoryDiagramRenderer": ["setDiagramSettings(const QgsDiagramSettings &s)"],
    "pal::LabelPosition": ["getNumOverlaps() const", "getProblemFeatureId() const", "getQuadrant() const", "getReversed() const", "getWidth() const", "getPartId() const", "setPartId(int id)", "getHeight() const", "resetNumOverlaps()", "getUpsideDown() const"],
    "pal::PointSet": ["invalidateGeos()", "PointSet(int nbPoints, double *x, double *y)", "createGeosGeom() const", "PointSet(double x, double y)", "getNumPoints() const", "PointSet(const PointSet &ps)", "getGeosType() const", "preparedGeom() const", "deleteCoords()", "getCentroid(double &px, double &py, bool forceInside=false) const"],
    "QgsRasterPyramidsOptionsWidget": ["setRasterFileName(const QString &file)", "createOptionsWidget()", "pyramidsFormat() const", "checkAllLevels(bool checked)", "resamplingMethod() const", "someValueChanged()", "setRasterLayer(QgsRasterLayer *rasterLayer)", "apply()", "overviewList() const", "overviewListChanged()", "configOptions() const"],
    "QgsRasterLayerSaveAsDialog": ["ResolutionState", "CrsState", "createOptions() const", "pyramidsResamplingMethod() const", "buildPyramidsFlag() const", "outputFormat() const", "tileMode() const", "maximumTileSizeY() const", "mode() const", "pyramidsFormat() const", "noData() const", "hideFormat()", "yResolution() const", "xResolution() const", "nRows() const", "hideOutput()", "outputCrs()", "Mode", "pyramidsList() const", "outputFileName() const", "pyramidsConfigOptions() const", "outputRectangle() const", "nColumns() const", "maximumTileSizeX() const"],
    "QgsGeometrySelfContactCheck": ["factoryId()", "ResolutionMethod", "QgsGeometrySelfContactCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsStyleGroupSelectionDialog": ["QgsStyleGroupSelectionDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsDiagramProperties": ["scalingTypeChanged()", "mAttributesTreeWidget_itemDoubleClicked(QTreeWidgetItem *item, int column)", "mDiagramTypeComboBox_currentIndexChanged(int index)", "mRemoveCategoryPushButton_clicked()", "mDiagramAttributesTreeWidget_itemDoubleClicked(QTreeWidgetItem *item, int column)", "auxiliaryFieldCreated()", "showSizeLegendDialog()", "mEngineSettingsButton_clicked()", "updatePlacementWidgets()", "mFindMaximumValueButton_clicked()", "mDiagramStackedWidget_currentChanged(int index)", "mAddCategoryPushButton_clicked()", "showAddAttributeExpressionDialog()", "apply()", "QgsDiagramProperties(QgsVectorLayer *layer, QWidget *parent, QgsMapCanvas *canvas)"],
    "QgsVectorFileWriter::SetOption": ["SetOption(const QString &docString, const QStringList &values, const QString &defaultValue, bool allowNone=false)"],
    "QgsAttributeDialog": ["attributeForm()", "feature()"],
    "QgsLayerTreeLayer": ["attachToLayer()", "QgsLayerTreeLayer(QgsMapLayer *layer)", "QgsLayerTreeLayer(const QgsLayerTreeLayer &other)"],
    "QgsMultiRenderChecker": ["setControlPathPrefix(const QString &prefix)"],
    "QgsColorEffectWidget": ["QgsColorEffectWidget(QWidget *parent=nullptr)", "create()"],
    "QgsSourceFieldsProperties": ["QgsSourceFieldsProperties(QgsVectorLayer *layer, QWidget *parent=nullptr)", "updateButtons()", "setRow(int row, int idx, const QgsField &field)", "apply()", "AttrColumns", "toggleEditing()", "loadRows()", "init()"],
    "QgsVertexMarker": ["setIconSize(int iconSize)", "setIconType(int iconType)", "QgsVertexMarker(QgsMapCanvas *mapCanvas)", "setPenWidth(int width)"],
    "QgsMapRendererParallelJob": ["QgsMapRendererParallelJob(const QgsMapSettings &settings)"],
    "QgsClipToMinMaxEnhancement": ["QgsClipToMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsRasterProjector": ["setPrecision(Precision precision)", "precisionLabel(Precision precision)", "precision() const"],
    "QgsGlowWidget": ["create()", "QgsGlowWidget(QWidget *parent=nullptr)"],
    "QgsJoinDialog": ["QgsJoinDialog(QgsVectorLayer *layer, QList< QgsMapLayer * > alreadyJoinedLayers, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags())"],
    "QgsPluginLayerType": ["QgsPluginLayerType(const QString &name)", "name()"],
    "QgsExternalResourceWidget": ["setDocumentPath(const QVariant &documentPath)", "DocumentViewerContent"],
    "QgsBrowserModel": ["beginInsertItems(QgsDataItem *parent, int first, int last)", "itemDataChanged(QgsDataItem *item)", "ItemDataRole", "endInsertItems()", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "endRemoveItems()", "removeRootItems()", "updateProjectHome()"],
    "QgsRuleBasedRendererWidget": ["selectedRules()", "setRenderingOrder()", "restoreSectionWidths()", "QgsRuleBasedRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "selectedRulesChanged()", "refineRule(int type)", "editRule(const QModelIndex &index)", "addRule()", "currentRule()", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "removeRule()", "editRule()", "countFeatures()", "refineRuleRanges()", "refineRuleScalesGui(const QModelIndexList &index)", "saveSectionWidth(int section, int oldSize, int newSize)", "refineRuleCategories()", "refineRuleScales()", "clearFeatureCounts()", "currentRuleChanged(const QModelIndex &current=QModelIndex(), const QModelIndex &previous=QModelIndex())"],
    "QgsRunProcess": ["create(const QString &action, bool capture)"],
    "pal::GeomFunction": ["cross_product(double x1, double y1, double x2, double y2, double x3, double y3)", "dist_euc2d_sq(double x1, double y1, double x2, double y2)", "findLineCircleIntersection(double cx, double cy, double radius, double x1, double y1, double x2, double y2, double &xRes, double &yRes)", "dist_euc2d(double x1, double y1, double x2, double y2)"],
    "QgsDataDefinedWidthDialog": ["QgsDataDefinedWidthDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsDefaultRasterLayerLegend": ["QgsDefaultRasterLayerLegend(QgsRasterLayer *rl)"],
    "QgsImageFillSymbolLayer": ["applyDataDefinedSettings(QgsSymbolRenderContext &context)"],
    "QgsGeometrySelfIntersectionCheck": ["QgsGeometrySelfIntersectionCheck(const QgsGeometryCheckContext *context, const QVariantMap &configuration=QVariantMap())", "ResolutionMethod"],
    "QgsAttributeTableFilterModel": ["mapFromMaster(const QModelIndex &sourceIndex) const", "mapToMaster(const QModelIndex &proxyIndex) const", "fidToIndexList(QgsFeatureId fid)"],
    "QgsSpatialIndexCopyVisitor": ["QgsSpatialIndexCopyVisitor(SpatialIndex::ISpatialIndex *newIndex)"],
    "QgsDiagramLayerSettings": ["Placement"],
    "QgsLongLongValidator": ["bottom() const", "setBottom(qint64 bottom)", "QgsLongLongValidator(QObject *parent)", "QgsLongLongValidator(qint64 bottom, qint64 top, QObject *parent)", "top() const", "setTop(qint64 top)", "setRange(qint64 bottom, qint64 top)"],
    "QgsRasterFormatSaveOptionsWidget": ["optionsChanged()", "Type", "apply()", "QgsRasterFormatSaveOptionsWidget(QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &format=\"GTiff\", QgsRasterFormatSaveOptionsWidget::Type type=Default, const QString &provider=\"gdal\")"],
    "QgsNewNameDialog": ["nameChanged()", "highlightText(const QString &text)", "fullNames(const QString &name, const QStringList &extensions)", "matching(const QStringList &newNames, const QStringList &existingNames, Qt::CaseSensitivity cs=Qt::CaseSensitive)"],
    "QgsFillSymbol": ["setAngle(double angle)"],
    "QgsSymbolSelectorDialog": ["lockLayer()", "addLayer()", "removeLayer()", "moveLayerUp()", "updateLayerPreview()", "layerChanged()", "moveLayerDown()", "updatePreview()", "symbolModified()"],
    "QgsBrushStyleComboBox": ["setBrushStyle(Qt::BrushStyle style)", "iconForBrush(Qt::BrushStyle style)", "QgsBrushStyleComboBox(QWidget *parent=nullptr)", "brushStyle() const"],
    "QgsCollapsibleGroupBox": ["QgsCollapsibleGroupBox(QWidget *parent=nullptr, QgsSettings *settings=nullptr)", "saveCollapsedState()", "QgsCollapsibleGroupBox(const QString &title, QWidget *parent=nullptr, QgsSettings *settings=nullptr)", "saveCheckedState()", "saveKey() const", "setSettings(QgsSettings *settings)", "init()"],
    "QgsGeometryPointInPolygonCheck": ["factoryId()", "QgsGeometryPointInPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsProject": ["relationManager() const"],
    "QgisPlugin": ["name()"],
    "QgsRasterChecker": ["report()"],
    "QgsRasterNuller": ["noData(int bandNo) const", "QgsRasterNuller(QgsRasterInterface *input=nullptr)", "setNoData(int bandNo, const QgsRasterRangeList &noData)"],
    "QgsBrightnessContrastFilter": ["QgsBrightnessContrastFilter(QgsRasterInterface *input=nullptr)"],
    "QgsCollapsibleGroupBoxBasic": ["QgsCollapsibleGroupBoxBasic(const QString &title, QWidget *parent=nullptr)", "checkClicked(bool ckd)", "titleRect() const", "updateStyle()", "clearModifiers()", "checkToggled(bool ckd)", "QgsCollapsibleGroupBoxBasic(QWidget *parent=nullptr)", "toggleCollapsed()", "init()"],
    "QgsPreviewEffect": ["QgsPreviewEffect(QObject *parent)", "PreviewMode"],
    "QgsGeos": ["fromGeosPolygon(const GEOSGeometry *geos)", "coordSeqPoint(const GEOSCoordSequence *cs, int i, bool hasZ, bool hasM)", "getGEOSHandler()"],
    "QgsPointLocator_VisitorNearestVertex": ["QgsPointLocator_VisitorNearestVertex(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsDartMeasurement": ["toString() const", "Type", "send() const", "QgsDartMeasurement(const QString &name, Type type, const QString &value)"],
    "QgsRasterInterface": ["yBlockSize() const", "ySize() const", "QgsRasterInterface(QgsRasterInterface *input=nullptr)"],
    "QgsCptCityColorRamp": ["setSchemeName(const QString &schemeName)", "variantList() const", "descFileName() const", "copyingFileName() const", "setVariantName(const QString &variantName)", "variantName() const", "hasMultiStops() const", "copyingInfo() const", "fileLoaded() const", "loadPalette()", "fileName() const", "cloneGradientRamp() const", "loadFile()", "setVariantList(const QStringList &variantList)", "copy(const QgsCptCityColorRamp *other)", "schemeName() const", "setName(const QString &schemeName, const QString &variantName=QString(), const QStringList &variantList=QStringList())"],
    "QgsIdentifyMenu": ["MenuLevel", "maxFeatureDisplay()", "showFeatureActions()", "resultsIfExternalAction()", "maxLayerDisplay()", "execWithSingleResult()", "allowMultipleReturn()"],
    "QgsLayerPropertiesWidget": ["updateSymbolLayerWidget(QgsSymbolLayer *layer)", "layerTypeChanged()", "changeLayer(QgsSymbolLayer *)", "populateLayerTypes()", "changed()", "emitSignalChanged()"],
    "QgsPointLocator_Stream": ["QgsPointLocator_Stream(const QLinkedList< RTree::Data * > &dataList)"],
    "QgsMapLayerProxyModel": ["Filter"],
    "QgsGradientFillSymbolLayerWidget": ["setColor(const QColor &color)", "setColor2(const QColor &color)", "setGradientSpread(int index)", "setGradientType(int index)", "setCoordinateMode(int index)"],
    "QgsVectorFileWriter::Option": ["Option(const QString &docString, QgsVectorFileWriter::OptionType type)"],
    "QgsLineSymbolLayer": ["setWidthMapUnitScale(const QgsMapUnitScale &scale)", "QgsLineSymbolLayer(bool locked=false)", "widthMapUnitScale() const"],
    "QgsConstWkbPtr": ["operator const unsigned char *() const", "operator-=(int n)", "operator>>(int &v) const", "operator>>(double &v) const", "QgsConstWkbPtr(const unsigned char *p, int size)", "operator>>(float &r) const", "operator+=(int n)", "operator>>(unsigned int &v) const", "operator>>(char &v) const"],
    "QgsSymbolLayerUtils": ["opacityFromSldElement(QDomElement &element, QString &alphaFunc)", "decodeBrushStyle(const QString &str)", "createOnlineResourceElement(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format)", "decodeSldBrushStyle(const QString &str)", "externalGraphicToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &mime, const QColor &color, double size=-1)", "externalMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format, int *markIndex=nullptr, const QColor &color=QColor(), double size=-1)", "geometryFromSldElement(QDomElement &element, QString &geomFunc)", "fillToSld(QDomDocument &doc, QDomElement &element, Qt::BrushStyle brushStyle, const QColor &color=QColor())", "rotationFromSldElement(QDomElement &element, QString &rotationFunc)", "wellKnownMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &name, const QColor &color, const QColor &strokeColor, Qt::PenStyle strokeStyle, double strokeWidth=-1, double size=-1)", "hasExternalGraphic(QDomElement &element)", "encodeSldFontWeight(int weight)", "encodeColor(const QColor &color)", "needMarkerLine(QDomElement &element)", "decodeSldLineCapStyle(const QString &str)", "createFillLayerFromSld(QDomElement &element)", "decodePenStyle(const QString &str)", "displacementFromSldElement(QDomElement &element, QPointF &offset)", "createFunctionElement(QDomDocument &doc, QDomElement &element, const QString &function)", "createVendorOptionElement(QDomDocument &doc, const QString &name, const QString &value)", "labelTextToSld(QDomDocument &doc, QDomElement &element, const QString &label, const QFont &font, const QColor &color=QColor(), double size=-1)", "decodeBlendMode(const QString &s)", "decodeSldLineJoinStyle(const QString &str)", "encodePenJoinStyle(Qt::PenJoinStyle style)", "hasWellKnownMark(QDomElement &element)", "decodePenCapStyle(const QString &str)", "encodeSldLineJoinStyle(Qt::PenJoinStyle style)", "createMarkerLayerFromSld(QDomElement &element)", "createRotationElement(QDomDocument &doc, QDomElement &element, const QString &rotationFunc)", "encodeSldBrushStyle(Qt::BrushStyle style)", "needFontMarker(QDomElement &element)", "externalGraphicFromSld(QDomElement &element, QString &path, QString &mime, QColor &color, double &size)", "decodeRealVector(const QString &s)", "fillFromSld(QDomElement &element, Qt::BrushStyle &brushStyle, QColor &color)", "encodePenStyle(Qt::PenStyle style)", "needPointPatternFill(QDomElement &element)", "decodeSldFontStyle(const QString &str)", "functionFromSldElement(QDomElement &element, QString &function)", "needSvgMarker(QDomElement &element)", "decodeColor(const QString &str)", "encodeSldLineCapStyle(Qt::PenCapStyle style)", "decodeSldFontWeight(const QString &str)", "createGeometryElement(QDomDocument &doc, QDomElement &element, const QString &geomFunc)", "createSvgParameterElement(QDomDocument &doc, const QString &name, const QString &value)", "getSvgParameterList(QDomElement &element)", "getVendorOptionList(QDomElement &element)", "encodeRealVector(const QVector< qreal > &v)", "externalMarkerFromSld(QDomElement &element, QString &path, QString &format, int &markIndex, QColor &color, double &size)", "decodeSldRealVector(const QString &s)", "encodePenCapStyle(Qt::PenCapStyle style)", "encodeSldAlpha(int alpha)", "decodeSldAlpha(const QString &str)", "onlineResourceFromSldElement(QDomElement &element, QString &path, QString &format)", "decodePenJoinStyle(const QString &str)", "createLineLayerFromSld(QDomElement &element)", "drawStippledBackground(QPainter *painter, QRect rect)", "needEllipseMarker(QDomElement &element)", "encodeSldFontStyle(QFont::Style style)", "createOpacityElement(QDomDocument &doc, QDomElement &element, const QString &alphaFunc)", "clearSymbolMap(QgsSymbolMap &symbols)", "decodeMapUnitScale(const QString &str)", "encodeBrushStyle(Qt::BrushStyle style)", "needSvgFill(QDomElement &element)", "encodeMapUnitScale(const QgsMapUnitScale &mapUnitScale)", "lineFromSld(QDomElement &element, Qt::PenStyle &penStyle, QColor &color, double &width, Qt::PenJoinStyle *penJoinStyle=nullptr, Qt::PenCapStyle *penCapStyle=nullptr, QVector< qreal > *customDashPattern=nullptr, double *dashOffset=nullptr)", "needLinePatternFill(QDomElement &element)", "encodeSldRealVector(const QVector< qreal > &v)", "createDisplacementElement(QDomDocument &doc, QDomElement &element, QPointF offset)"],
    "QgsRelief": ["setZFactor(double factor)", "setReliefColors(const QList< QgsRelief::ReliefColor > &c)", "reliefColors() const", "zFactor() const", "QgsRelief(const QString &inputFile, const QString &outputFile, const QString &outputFormat)", "clearReliefColors()", "addReliefColorClass(const QgsRelief::ReliefColor &color)"],
    "QgsFeatureListModel": ["featureByIndex(const QModelIndex &index, QgsFeature &feat)", "displayExpression() const", "mapToMaster(const QModelIndex &proxyIndex) const", "fidToIndexList(QgsFeatureId fid)", "mapSelectionFromMaster(const QItemSelection &selection) const", "mapFromMaster(const QModelIndex &sourceIndex) const", "setSourceModel(QgsAttributeTableFilterModel *sourceModel)", "mapSelectionToMaster(const QItemSelection &selection) const", "Role", "masterModel()"],
    "QgsCurvePolygon": ["QgsCurvePolygon(const QgsCurvePolygon &p)"],
    "QgsGeometry::Error": ["Error(const QString &m)", "Error(const QString &m, const QgsPointXY &p)"],
    "QgsMeshDatasetGroupTreeItemDelagate": ["QgsMeshDatasetGroupTreeItemDelagate(QObject *parent=nullptr)"],
    "QgsGeometryCollection": ["QgsGeometryCollection(const QgsGeometryCollection &c)"],
    "QgsCptCityBrowserModel": ["refresh(const QModelIndex &index=QModelIndex())", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "QgsCptCityBrowserModel(QObject *parent=nullptr, QgsCptCityArchive *archive=QgsCptCityArchive::defaultArchive(), ViewType Type=Authors)", "refresh(const QString &path)", "endInsertItems()", "addRootItems()", "removeRootItems()", "endRemoveItems()", "connectItem(QgsCptCityDataItem *item)", "reload()", "ViewType", "findItem(QgsCptCityDataItem *item, QgsCptCityDataItem *parent=nullptr) const"],
    "QgsVectorLayerSelectionManager": ["QgsVectorLayerSelectionManager(QgsVectorLayer *layer, QObject *parent=nullptr)"],
    "QgisInterface": ["actionOptions()=0", "actionPluginListSeparator()=0", "pluginManagerInterface()=0", "actionAddWmsLayer()=0", "actionNewVectorLayer()=0", "actionRemoveAllFromOverview()=0", "actionPasteLayerStyle()=0", "actionHelpContents()=0", "actionCustomProjection()=0", "actionShowPythonDialog()=0", "actionCopyLayerStyle()=0", "actionAbout()=0", "actionToggleEditing()=0", "actionCancelEdits()=0", "actionQgisHomePage()=0", "actionAllEdits()=0", "actionOpenTable()=0", "actionCheckQgisVersion()=0", "actionManagePlugins()=0", "actionShowSelectedLayers()=0", "actionAddOgrLayer()=0", "actionRollbackEdits()=0", "actionHideAllLayers()=0", "actionAddToOverview()=0", "actionDuplicateLayer()=0", "actionSaveActiveLayerEdits()=0", "actionRollbackAllEdits()=0", "actionShowAllLayers()=0", "actionSaveAllEdits()=0", "actionAddAllToOverview()=0", "actionAddPgLayer()=0", "actionSaveEdits()=0", "actionAddRasterLayer()=0", "actionToggleFullScreen()=0", "actionLayerProperties()=0", "layerTreeView()=0", "actionHideSelectedLayers()=0", "actionOpenFieldCalculator()=0", "actionLayerSaveAs()=0", "actionCancelAllEdits()=0"],
    "QgsMapRendererCustomPainterJob": ["QgsMapRendererCustomPainterJob(const QgsMapSettings &settings, QPainter *painter)"],
    "QgsValueMapConfigDlg": ["QgsValueMapConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsEncodingFileDialog": ["saveUsedEncoding()", "pbnCancelAll_clicked()"],
    "QgsRendererRangeLabelFormat": ["format() const", "trimTrailingZeroes() const", "setFormat(const QString &format)", "saveToDomElement(QDomElement &element)", "formatNumber(double value) const", "setTrimTrailingZeroes(bool trimTrailingZeroes)", "QgsRendererRangeLabelFormat(const QString &format, int precision=4, bool trimTrailingZeroes=false)", "setFromDomElement(QDomElement &element)", "setPrecision(int precision)", "labelForRange(const QgsRendererRange &range) const", "precision() const"],
    "QgsGeometryChecker": ["QgsGeometryChecker(const QList< QgsGeometryCheck * > &checks, QgsGeometryCheckContext *context, const QMap< QString, QgsFeaturePool * > &featurePools)", "errorAdded(QgsGeometryCheckError *error)", "execute(int *totalSteps=nullptr)", "getContext() const", "featurePools() const", "getChecks() const", "getMessages() const", "progressValue(int value)", "setMergeAttributeIndices(const QMap< QString, int > &mergeAttributeIndices)", "errorUpdated(QgsGeometryCheckError *error, bool statusChanged)", "fixError(QgsGeometryCheckError *error, int method, bool triggerRepaint=false)"],
    "QgsGeometryContainedCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "QgsGeometryContainedCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsDataDefinedSizeDialog": ["QgsDataDefinedSizeDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsGeometryEngine": ["length(QString *errorMsg=nullptr) const =0", "isEmpty(QString *errorMsg) const =0", "buffer(double distance, int segments, QString *errorMsg=nullptr) const =0", "interpolate(double distance, QString *errorMsg=nullptr) const =0", "envelope(QString *errorMsg=nullptr) const =0", "simplify(double tolerance, QString *errorMsg=nullptr) const =0", "QgsGeometryEngine(const QgsAbstractGeometry *geometry)", "area(QString *errorMsg=nullptr) const =0"],
    "QgsPointLocator_VisitorNearestEdge": ["QgsPointLocator_VisitorNearestEdge(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsDiagramRenderer": ["rendererName() const =0", "diagram() const", "setDiagram(QgsDiagram *d)", "QgsDiagramRenderer(const QgsDiagramRenderer &other)"],
    "QgsSingleBandGrayRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &extent)", "QgsSingleBandGrayRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())"],
    "QgsOfflineEditing": ["ProgressMode"],
    "QgsVectorDataProvider": ["convertValue(QVariant::Type type, const QString &value)"],
    "QgsDxfPaintDevice": ["setDrawingSize(QSizeF size)", "setLayer(const QString &layer)", "QgsDxfPaintDevice(QgsDxfExport *dxf)", "setOutputSize(const QRectF &r)", "setShift(QPointF shift)"],
    "QgsSimpleFillSymbolLayer": ["createFromSld(QDomElement &element)", "strokeWidth() const", "setStrokeWidth(double strokeWidth)", "strokeWidthMapUnitScale() const", "QgsSimpleFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, Qt::BrushStyle style=DEFAULT_SIMPLEFILL_STYLE, const QColor &strokeColor=DEFAULT_SIMPLEFILL_BORDERCOLOR, Qt::PenStyle strokeStyle=DEFAULT_SIMPLEFILL_BORDERSTYLE, double strokeWidth=DEFAULT_SIMPLEFILL_BORDERWIDTH, Qt::PenJoinStyle penJoinStyle=DEFAULT_SIMPLEFILL_JOINSTYLE)", "penJoinStyle() const", "strokeStyle() const", "setPenJoinStyle(Qt::PenJoinStyle style)", "setBrushStyle(Qt::BrushStyle style)", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "setStrokeStyle(Qt::PenStyle strokeStyle)", "brushStyle() const"],
    "QgsFeatureIterator": ["close()", "nextFeature(QgsFeature &f)", "rewind()"],
    "QgsAttributesFormProperties::DnDTreeItemData": ["DnDTreeItemData(Type type, const QString &name, const QString &displayName, const QColor &backgroundColor=QColor())", "visibilityExpression() const", "setShowAsGroupBox(bool showAsGroupBox)", "showLabel() const", "setHtmlElementEditorConfiguration(HtmlElementEditorConfiguration htmlElementEditorConfiguration)", "setColumnCount(int count)", "Type", "setVisibilityExpression(const QgsOptionalExpression &visibilityExpression)", "relationEditorConfiguration() const", "DnDTreeItemData()=default", "operator QVariant()", "columnCount() const", "displayName() const", "type() const", "setRelationEditorConfiguration(RelationEditorConfiguration relationEditorConfiguration)", "setBackgroundColor(const QColor &backgroundColor)", "name() const", "setShowLabel(bool showLabel)", "setQmlElementEditorConfiguration(QmlElementEditorConfiguration qmlElementEditorConfiguration)", "htmlElementEditorConfiguration() const", "showAsGroupBox() const", "setDisplayName(const QString &displayName)", "qmlElementEditorConfiguration() const", "backgroundColor() const", "setName(const QString &name)", "setType(Type type)"],
    "QgsGpsdConnection": ["QgsGpsdConnection(const QString &host, qint16 port, const QString &device)"],
    "QgsPalettedRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &extent)", "QgsPalettedRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())"],
    "QgsMultiBandColorRendererWidget": ["QgsMultiBandColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "create(QgsRasterLayer *layer, const QgsRectangle &extent)"],
    "QgsDefaultVectorLayerLegend": ["QgsDefaultVectorLayerLegend(QgsVectorLayer *vl)"],
    "QgsCptCityAllRampsItem": ["QgsCptCityAllRampsItem(QgsCptCityDataItem *parent, const QString &name, const QVector< QgsCptCityDataItem * > &items)"],
    "QgsSimpleFillSymbolLayerWidget": ["setColor(const QColor &color)", "setStrokeColor(const QColor &color)"],
    "QgsLinearMinMaxEnhancementWithClip": ["QgsLinearMinMaxEnhancementWithClip(Qgis::DataType, double, double)"],
    "QgsDrawSourceWidget": ["QgsDrawSourceWidget(QWidget *parent=nullptr)", "create()"],
    "QgsDiagramSettings": ["LabelPlacementMethod"],
    "QgsAbstractGeometry": ["QgsAbstractGeometry(const QgsAbstractGeometry &geom)"],
    "QgsSingleBandColorDataRenderer": ["QgsSingleBandColorDataRenderer(QgsRasterInterface *input, int band)", "create(const QDomElement &elem, QgsRasterInterface *input)"],
    "QgsDataItem": ["populate(const QVector< QgsDataItem * > &children)", "deleteLater(QVector< QgsDataItem * > &items)", "icon()", "setPath(const QString &path)", "hasChildren()", "toolTip() const", "path() const", "setIconName(const QString &iconName)", "type() const", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "endInsertItems()", "populate(bool foreground=false)", "setIcon(const QIcon &icon)", "beginInsertItems(QgsDataItem *parent, int first, int last)", "setToolTip(const QString &msg)", "refresh()", "rowCount()", "childrenCreated()", "children() const", "endRemoveItems()", "findItem(QVector< QgsDataItem * > items, QgsDataItem *item)", "dataChanged(QgsDataItem *item)"],
    "QgsRasterShader": ["rasterShaderFunction() const", "QgsRasterShader(double minimumValue=0.0, double maximumValue=255.0)", "rasterShaderFunction()"],
    "QgsMapLayerAction": ["Target"],
    "QgsMeshVariableStrokeWidthButton": ["widgetChanged()"],
    "QgsMeshDatasetGroupTreeModel": ["Roles", "QgsMeshDatasetGroupTreeModel(QObject *parent=nullptr)"],
    "QgsLabelingEngine": ["processProvider(QgsAbstractLabelProvider *provider, QgsRenderContext &context, pal::Pal &p)"],
    "QgsCodeEditor": ["isFixedPitch(const QFont &font)"],
    "QgsAction": ["ActionType"],
    "QgsMeshActiveDatasetGroupTreeView": ["QgsMeshActiveDatasetGroupTreeView(QWidget *parent=nullptr)"],
    "QgsGmlFeatureClass": ["fieldIndex(const QString &name)", "QgsGmlFeatureClass(const QString &name, const QString &path)", "fields()", "path() const", "geometryAttributes()"],
    "QgsRenderContext": ["QgsRenderContext(const QgsRenderContext &rh)"],
    "QgsAbstractFeatureIteratorFromSource": ["QgsAbstractFeatureIteratorFromSource(T *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsMapToolIdentifyFeature": ["featureIdentified(QgsFeatureId)", "featureIdentified(const QgsFeature &)"],
    "QgsProjectFileTransform": ["convertRasterProperties(QDomDocument &doc, QDomNode &parentNode, QDomElement &rasterPropertiesElem, QgsRasterLayer *rlayer)", "updateRevision(const QgsProjectVersion &version)"],
    "QgsMapCanvas": ["setCurrentLayer(QgsMapLayer *layer)"],
    "QgsMeshDatasetGroupListModel": ["QgsMeshDatasetGroupListModel(QObject *parent)", "setDisplayProviderName(bool displayProviderName)", "variableNames() const"],
    "QgsSlopeFilter": ["QgsSlopeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsUniqueValuesConfigDlg": ["QgsUniqueValuesConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsLabelCandidate": ["QgsLabelCandidate(const QRectF &r, double c)"],
    "QgsSymbolRenderContext": ["setFeature(const QgsFeature *f)"],
    "QgsVectorFileWriter::BoolOption": ["BoolOption(const QString &docString, bool defaultValue)"],
    "QgsDerivativeFilter": ["QgsDerivativeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsGpsConnection": ["nmeaSentenceReceived(const QString &substring)", "Status", "stateChanged(const QgsGpsInformation &info)"],
    "QgsPointLocator_VisitorEdgesInRect": ["QgsPointLocator_VisitorEdgesInRect(QgsPointLocator *pl, QgsPointLocator::MatchList &lst, const QgsRectangle &srcRect, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsAttributeTableDelegate": ["setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)"],
    "QgsSmartGroupCondition": ["QgsSmartGroupCondition(int id, QWidget *parent=nullptr)", "removed(int)", "destruct()"],
    "QgsRelationReferenceFactory": ["QgsRelationReferenceFactory(const QString &name, QgsMapCanvas *canvas, QgsMessageBar *messageBar)"],
    "QgsGraduatedSymbolRenderer": ["addClass(QgsSymbol *symbol)", "ranges() const", "updateRangeUpperValue(int rangeIndex, double value)", "updateRangeLabel(int rangeIndex, const QString &label)", "sortByValue(Qt::SortOrder order=Qt::AscendingOrder)", "GraduatedMethod", "updateRangeSymbol(int rangeIndex, QgsSymbol *symbol)", "QgsGraduatedSymbolRenderer(const QString &attrName=QString(), const QgsRangeList &ranges=QgsRangeList())", "sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)", "deleteAllClasses()", "classAttribute() const", "setClassAttribute(const QString &attr)", "deleteClass(int idx)", "updateRangeLowerValue(int rangeIndex, double value)"],
    "ParametricLine": ["calcPoint(float t, QgsPoint *p)=0", "getControlPoint(int number) const =0", "getControlPoly() const =0", "setParent(ParametricLine *paral)=0", "calcFirstDer(float t, Vector3D *v)=0", "add(ParametricLine *pl)=0", "getDegree() const =0", "remove(int i)=0", "changeDirection()=0", "setControlPoly(QVector< QgsPoint * > *cp)=0", "calcSecDer(float t, Vector3D *v)=0", "getParent() const =0"],
    "QgsLayerTreeModel": ["legendNodeFlags(QgsLayerTreeModelLegendNode *node) const", "nodeVisibilityChanged(QgsLayerTreeNode *node)", "connectToLayer(QgsLayerTreeLayer *nodeLayer)", "nodeWillAddChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "disconnectFromLayers(QgsLayerTreeGroup *parentGroup)", "legendRootIndex(int row, int column, QgsLayerTreeLayer *nL) const", "connectToRootNode()", "legendRootRowCount(QgsLayerTreeLayer *nL) const", "layerLegendChanged()", "connectToLayers(QgsLayerTreeGroup *parentGroup)", "invalidateLegendMapBasedData()", "legendNodeDataChanged()", "legendCleanup()", "legendNodeData(QgsLayerTreeModelLegendNode *node, int role) const", "iconGroup()", "indexOfParentLayerTreeNode(QgsLayerTreeNode *parentNode) const", "legendEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const", "nodeCustomPropertyChanged(QgsLayerTreeNode *node, const QString &key)", "addLegendToLayer(QgsLayerTreeLayer *nodeL)", "Flag", "nodeLayerLoaded()", "disconnectFromLayer(QgsLayerTreeLayer *nodeLayer)", "legendParent(QgsLayerTreeModelLegendNode *legendNode) const", "nodeRemovedChildren()", "legendNodeRowCount(QgsLayerTreeModelLegendNode *node) const", "nodeLayerWillBeUnloaded()", "nodeAddedChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "removeLegendFromLayer(QgsLayerTreeLayer *nodeLayer)", "legendIconEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const", "layerNeedsUpdate()", "disconnectFromRootNode()", "legendNodeIndex(int row, int column, QgsLayerTreeModelLegendNode *node) const", "legendInvalidateMapBasedData()", "nodeWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)"],
    "QgsGeometryAreaCheck": ["factoryId()", "ResolutionMethod", "QgsGeometryAreaCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsLinearlyInterpolatedDiagramRenderer": ["setDiagramSettings(const QgsDiagramSettings &s)", "setUpperSize(QSizeF s)", "upperValue() const", "classificationAttributeIsExpression() const", "classificationAttributeExpression() const", "setClassificationAttributeIsExpression(bool isExpression)", "upperSize() const", "lowerValue() const", "setUpperValue(double val)", "setLowerValue(double val)", "lowerSize() const", "setClassificationAttributeExpression(const QString &expression)", "setLowerSize(QSizeF s)"],
    "QgsRuleBasedLabelProvider": ["QgsRuleBasedLabelProvider(const QgsRuleBasedLabeling &rules, QgsVectorLayer *layer, bool withFeatureLoop=true)"],
    "QgsMeshDatasetGroupSaveMenu": ["datasetGroupSaved(const QString &uri)", "QgsMeshDatasetGroupSaveMenu(QObject *parent=nullptr)", "setMeshLayer(QgsMeshLayer *meshLayer)", "createSaveMenu(int groupIndex, QMenu *parentMenu=nullptr)"],
    "QgsAdvancedDigitizingCanvasItem": ["QgsAdvancedDigitizingCanvasItem(QgsMapCanvas *canvas, QgsAdvancedDigitizingDockWidget *cadDockWidget)"],
    "QgsGpsDetector": ["detectionFailed()", "connDestroyed(QObject *)", "detected(const QgsGpsInformation &)", "advance()", "QgsGpsDetector(const QString &portName)", "availablePorts()"],
    "QgsCptCitySelectionItem": ["selectionsList() const", "parseXml()", "QgsCptCitySelectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)"],
    "QgsBlurWidget": ["QgsBlurWidget(QWidget *parent=nullptr)", "create()"],
    "QgsWkbException": ["QgsWkbException(QString const &what)"],
    "QgsMapToolAdvancedDigitizing": ["cadDockWidget() const"],
    "QgsRasterDataProvider": ["identifyFormatFromName(const QString &formatName)", "identifyFormatLabel(QgsRaster::IdentifyFormat format)", "setUserNoDataValue(int bandNo, const QgsRasterRangeList &noData)", "identifyFormatToCapability(QgsRaster::IdentifyFormat format)", "colorName(int colorInterpretation) const", "colorTable(int bandNo) const", "identifyFormatName(QgsRaster::IdentifyFormat format)"],
    "QgsVectorFileWriter::HiddenOption": ["HiddenOption(const QString &value)"],
    "QgsSimpleLineSymbolLayerWidget": ["updatePatternIcon()"],
    "QgsCptCityDataItem": ["removeChildItem(QgsCptCityDataItem *child)", "icon()", "QgsCptCityDataItem(QgsCptCityDataItem::Type type, QgsCptCityDataItem *parent, const QString &name, const QString &path)", "Type", "icon(QSize size)", "deleteChildItem(QgsCptCityDataItem *child)", "setParent(QgsCptCityDataItem *parent)", "handleDrop(const QMimeData *, Qt::DropAction)", "hasChildren()", "isValid()", "findItem(QVector< QgsCptCityDataItem * > items, QgsCptCityDataItem *item)", "toolTip() const", "shortInfo() const", "path() const", "endInsertItems()", "type() const", "createChildren()", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "addChildItem(QgsCptCityDataItem *child, bool refresh=false)", "name() const", "populate()", "setIcon(const QIcon &icon)", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "setToolTip(const QString &msg)", "acceptDrop()", "equal(const QgsCptCityDataItem *other)", "refresh()", "rowCount()", "isPopulated()", "leafCount() const", "children() const", "info() const", "endRemoveItems()", "parent() const", "paramWidget()"],
    "QgsDirectoryParamWidget": ["QgsDirectoryParamWidget(const QString &path, QWidget *parent=nullptr)", "showHideColumn()"],
    "QgsSlider": ["valueChanged(const QVariant &)", "setSingleStep(const QVariant &step)", "setMinimum(const QVariant &min)", "variantValue() const", "setValue(const QVariant &value)", "setMaximum(const QVariant &max)"],
    "QgsTransformWidget": ["create()", "QgsTransformWidget(QWidget *parent=nullptr)"],
    "QgsGeometryTypeCheck": ["factoryCheckType()", "QgsGeometryTypeCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, int allowedTypes)", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryCompatibleGeometryTypes()"],
    "QgsGpsConnectionRegistry": ["connectionList() const"],
    "QgsScopeLogger": ["QgsScopeLogger(const char *file, const char *func, int line)"],
    "QgsRasterLayerRenderer": ["QgsRasterLayerRenderer(QgsRasterLayer *layer, QgsRenderContext &rendererContext)"],
    "QgsRelationReferenceWidget": ["init()", "setReadOnlySelector(bool readOnly)", "CanvasExtent", "setAllowMapIdentification(bool allowMapIdentification)", "setOpenFormButtonVisible(bool openFormButtonVisible)", "setRelationEditable(bool editable)", "QgsRelationReferenceWidget(QWidget *parent)", "setRelation(const QgsRelation &relation, bool allowNullValue)", "setEmbedForm(bool display)"],
    "QgsNetworkAccessManager": ["requestTimedOut(QNetworkReply *)", "QgsNetworkAccessManager(QObject *parent=nullptr)"],
    "QgsActionMenu": ["reinit()", "ActionType"],
    "QgsAttributeTableView": ["selectRow(int row)", "_q_selectRow(int row)", "finished()", "repaintRequested()", "repaintRequested(const QModelIndexList &indexes)", "setModel(QgsAttributeTableFilterModel *filterModel)"],
    "QgsFeatureListViewDelegate": ["QgsFeatureListViewDelegate(QgsFeatureListModel *listModel, QObject *parent=nullptr)", "setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)", "positionToElement(QPoint pos)", "setCurrentFeatureEdited(bool state)", "Element", "setEditSelectionModel(QItemSelectionModel *editSelectionModel)", "editButtonClicked(QModelIndex &index)"],
    "QgsGenericFeatureSelectionManager": ["QgsGenericFeatureSelectionManager(QObject *parent=nullptr)", "QgsGenericFeatureSelectionManager(const QgsFeatureIds &initialSelection, QObject *parent=nullptr)"],
    "QgsUnitSelectionWidget": ["changed()"],
    "QgsPixmapLabel": ["setPixmap(const QPixmap &)"],
    "QgsMeshDatasetGroupProxyModel": ["QgsMeshDatasetGroupProxyModel(QAbstractItemModel *sourceModel)"],
    "QgsSvgSelectorGroupsModel": ["QgsSvgSelectorGroupsModel(QObject *parent)"],
    "QgsEditorWidgetRegistry": ["createSearchWidget(const QString &widgetId, QgsVectorLayer *vl, int fieldIdx, const QVariantMap &config, QWidget *parent, const QgsAttributeEditorContext &context=QgsAttributeEditorContext())"],
    "QgsCharacterSelectorDialog": ["QgsCharacterSelectorDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)"],
    "QgsPointLocator": ["destroyIndex()", "rebuildIndex(int maxFeaturesToIndex=-1)"],
    "QgsSimpleMarkerSymbolLayerWidget": ["setColorStroke(const QColor &color)", "setColorFill(const QColor &color)"],
    "QgsPointPatternFillSymbolLayer": ["createFromSld(QDomElement &element)", "setDisplacementX(double d)", "distanceX() const", "distanceXMapUnitScale() const", "displacementX() const", "setDisplacementXMapUnitScale(const QgsMapUnitScale &scale)", "distanceYMapUnitScale() const", "setDistanceY(double d)", "setDistanceYMapUnitScale(const QgsMapUnitScale &scale)", "displacementXMapUnitScale() const", "displacementYMapUnitScale() const", "distanceY() const", "setDistanceX(double d)", "setDisplacementYMapUnitScale(const QgsMapUnitScale &scale)", "setDisplacementY(double d)", "setDistanceXMapUnitScale(const QgsMapUnitScale &scale)", "displacementY() const"],
    "QgsRasterLayer": ["showStatusMessage(const QString &message)", "isValidRasterFileName(const QString &fileNameQString)"],
    "QgsVectorLayer": ["diagramRenderer() const", "setDiagramLayerSettings(const QgsDiagramLayerSettings &s)", "diagramLayerSettings() const", "vectorJoins() const"],
    "QgsVectorLayerEditBuffer": ["committedAttributeValuesChanges(const QString &layerId, const QgsChangedAttributesMap &changedAttributesValues)", "committedGeometriesChanges(const QString &layerId, const QgsGeometryMap &changedGeometries)", "committedFeaturesRemoved(const QString &layerId, const QgsFeatureIds &deletedFeatureIds)", "attributeAdded(int idx)", "featureDeleted(QgsFeatureId fid)", "committedFeaturesAdded(const QString &layerId, const QgsFeatureList &addedFeatures)", "updateLayerFields()", "attributeDeleted(int idx)", "featureAdded(QgsFeatureId fid)", "undoIndexChanged(int index)", "committedAttributesAdded(const QString &layerId, const QList< QgsField > &addedAttributes)", "QgsVectorLayerEditBuffer(QgsVectorLayer *layer)", "attributeValueChanged(QgsFeatureId fid, int idx, const QVariant &)"],
    "QgsMapToolIdentify": ["changedRasterResults(QList< QgsMapToolIdentify::IdentifyResult > &)", "IdentifyMode", "identifyProgress(int, int)", "identifyMessage(const QString &)", "Type", "formatChanged(QgsRasterLayer *layer)"],
    "QgsPaintEffectWidget": ["QgsPaintEffectWidget(QWidget *parent=nullptr)"],
    "QgsGeometryValidator": ["addError(const QgsGeometry::Error &)", "stop()"],
    "QgsGeometrySelfIntersectionCheckError": ["intersection() const", "QgsGeometrySelfIntersectionCheckError(const QgsSingleGeometryCheck *check, const QgsGeometry &geometry, const QgsGeometry &errorLocation, QgsVertexId vertexId, const QgsGeometryUtils::SelfIntersection &intersection)"],
    "QgsInterpolator": ["QgsInterpolator(const QList< QgsInterpolator::LayerData > &layerData)"],
    "QgsRasterShaderFunction": ["QgsRasterShaderFunction(double minimumValue=0.0, double maximumValue=255.0)", "minimumMaximumRange() const"],
    "QgsCentroidFillSymbolLayer": ["createFromSld(QDomElement &element)", "pointOnSurface() const", "setPointOnSurface(bool pointOnSurface)"],
    "QgsHillshadeFilter": ["lightAngle() const", "lightAzimuth() const", "setLightAzimuth(float azimuth)", "QgsHillshadeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat, double lightAzimuth=300, double lightAngle=40)", "setLightAngle(float angle)"],
    "QgsRendererRulePropsDialog": ["buildExpression()", "rule()", "testFilter()"],
    "QgsAttributeActionPropertiesDialog": ["actionScopes() const", "actionText() const", "capture() const", "description() const", "shortTitle() const", "QgsAttributeActionPropertiesDialog(QgsVectorLayer *layer, QWidget *parent=nullptr)", "type() const", "QgsAttributeActionPropertiesDialog(QgsAction::ActionType type, const QString &description, const QString &shortTitle, const QString &iconPath, const QString &actionText, bool capture, const QSet< QString > &actionScopes, const QString &notificationMessage, bool isEnabledOnlyWhenEditable, QgsVectorLayer *layer, QWidget *parent=nullptr)", "iconPath() const", "isEnabledOnlyWhenEditable() const", "notificationMessage() const"],
    "pal::Layer": ["UpsideDownLabels", "displayAll() const"],
    "QgsExpressionBuilderDialog": ["QgsExpressionBuilderDialog(QgsVectorLayer *layer, const QString &startText=QString(), QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &key=\"generic\", const QgsExpressionContext &context=QgsExpressionContext())", "expressionText()", "setExpressionText(const QString &text)"],
    "QgsSvgMarkerSymbolLayer": ["createFromSld(QDomElement &element)", "strokeWidth() const", "strokeWidthMapUnitScale() const", "setStrokeWidth(double w)", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)"],
    "QgsCptCityDirectoryItem": ["dirEntries() const", "dataItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "QgsCptCityDirectoryItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "rampsMap()"],
    "QgsMapRendererQImageJob": ["QgsMapRendererQImageJob(const QgsMapSettings &settings)"],
    "QgsTransaction": ["QgsTransaction(const QString &connString)"],
    "QgsHeatmapRenderer": ["convertFromRenderer(const QgsFeatureRenderer *renderer)"],
    "QgsAbstractFeatureSource": ["iteratorOpened(QgsAbstractFeatureIterator *it)", "iteratorClosed(QgsAbstractFeatureIterator *it)"],
    "QgsDummyConfigDlg": ["QgsDummyConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent, const QString &description)"],
    "QgsValueRelationConfigDlg": ["QgsValueRelationConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)", "editExpression()"],
    "QgsAttributesFormProperties": ["initInitPython()", "initLayoutConfig()", "initFormLayoutTree()", "initAvailableWidgetsTree()", "initSuppressCombo()", "updateButtons()", "loadRelations()", "createAttributeEditorWidget(QTreeWidgetItem *item, QgsAttributeEditorElement *parent, bool forceGroup=true)", "apply()", "QgsAttributesFormProperties(QgsVectorLayer *layer, QWidget *parent=nullptr)", "FieldPropertiesRoles", "init()"],
    "pal::Pal": ["FnIsCanceled)(void *ctx)"],
    "QgsMarkerLineSymbolLayerWidget": ["setOffsetAlongLine(double val)", "setInterval(double val)"],
    "QgsMeshAvailableDatasetGroupTreeModel": ["QgsMeshAvailableDatasetGroupTreeModel(QObject *parent=nullptr)"],
    "QgsMessageViewer": ["QgsMessageViewer(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags, bool deleteOnClose=true)", "setCheckBoxVisible(bool visible)", "setCheckBoxQgsSettingsLabel(const QString &label)", "setCheckBoxState(Qt::CheckState state)", "setMessageAsPlainText(const QString &msg)", "checkBoxState()", "setCheckBoxText(const QString &text)", "setMessageAsHtml(const QString &msg)"],
    "QgsVectorLayerSaveStyleDialog": ["outputFilePath() const", "saveOnlyCurrentStyle() const", "QgsVectorLayerSaveStyleDialog(QgsVectorLayer *layer, QWidget *parent=nullptr)", "stylesWidget()", "currentStyleType() const", "saveToDbSettings() const", "setSaveOnlyCurrentStyle(bool saveCurrentStyle)", "styleCategories() const"],
    "QgsFillSymbolLayer": ["setAngle(double angle)", "QgsFillSymbolLayer(bool locked=false)", "angle() const"],
    "QgsConnectionPoolGroup": ["release(T conn)", "invalidateConnections()", "QgsConnectionPoolGroup(const QString &ci)", "initTimer(QObject *parent)", "onConnectionExpired()"],
    "QgsVectorLayerFeatureIterator": ["QgsVectorLayerFeatureIterator(QgsVectorLayerFeatureSource *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsSymbolLayerAbstractMetadata": ["visibleName() const", "type() const", "name() const"],
    "QgsGeometryTypeCheckError": ["QgsGeometryTypeCheckError(const QgsSingleGeometryCheck *check, const QgsGeometry &geometry, const QgsGeometry &errorLocation, QgsWkbTypes::Type flatType)"],
    "QgsVectorLayerProperties": ["exportAuxiliaryLayer(QgsAuxiliaryLayer *layer)", "StyleType", "toggleEditing(QgsMapLayer *)", "QgsVectorLayerProperties(QgsMapCanvas *canvas, QgsMessageBar *messageBar, QgsVectorLayer *lyr=nullptr, QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)"],
    "QgsCptCityArchive": ["defaultArchive()", "copyingFileName(const QString &dirName) const", "findFileName(const QString &target, const QString &startDir, const QString &baseDir)", "baseDir() const", "initDefaultArchive()", "clearArchives()", "selectionItems() const", "baseDir(QString archiveName)", "description(const QString &fileName)", "copyingInfo(const QString &fileName)", "archiveName() const", "isEmpty()", "defaultBaseDir()", "archiveRegistry()", "initArchive(const QString &archiveName, const QString &archiveBaseDir)", "rootItems() const", "setBaseDir(const QString &dirName)", "initArchives(bool loadAll=false)", "QgsCptCityArchive(const QString &archiveName=DEFAULT_CPTCITY_ARCHIVE, const QString &baseDir=QString())", "descFileName(const QString &dirName) const"],
    "QgsVectorLayerCache": ["QgsVectorLayerCache(QgsVectorLayer *layer, int cacheSize, QObject *parent=nullptr)"],
    "QgsMeshRendererMeshSettingsWidget": ["MeshType"],
    "QgsLayerTreeNode": ["QgsLayerTreeNode(const QgsLayerTreeNode &other)"],
    "QgsRasterResampleFilter": ["maxOversampling() const", "QgsRasterResampleFilter(QgsRasterInterface *input=nullptr)", "zoomedInResampler() const", "setMaxOversampling(double os)", "zoomedOutResampler() const"],
    "QgsRuleBasedRenderer": ["createFromSld(QDomElement &element, QgsWkbTypes::GeometryType geomType)", "FeatureFlags", "rootRule()"],
    "QgsRangeConfigDlg": ["QgsRangeConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)", "rangeWidgetChanged(int index)"],
    "QgsManageConnectionsDialog": ["clearSelection()", "selectionChanged()", "selectAll()", "doExportImport()", "Mode", "Type"],
    "QgsRelationReferenceConfigDlg": ["QgsRelationReferenceConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsColorBrewerPalette": ["listSchemes()", "listSchemeVariants(const QString &schemeName)", "listSchemeColors(const QString &schemeName, int colors)"],
    "QgsGeometryHoleCheck": ["factoryId()", "QgsGeometryHoleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsGradientFillSymbolLayer": ["QgsGradientFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, GradientColorType gradientColorType=SimpleTwoColor, GradientType gradientType=Linear, GradientCoordinateMode coordinateMode=Feature, GradientSpread gradientSpread=Pad)", "GradientType", "GradientCoordinateMode", "setCoordinateMode(GradientCoordinateMode coordinateMode)", "setColor2(const QColor &color2)", "setGradientSpread(GradientSpread gradientSpread)", "GradientSpread", "GradientColorType", "referencePoint1() const", "referencePoint2() const", "setGradientColorType(GradientColorType gradientColorType)", "setGradientType(GradientType gradientType)", "referencePoint1IsCentroid() const", "referencePoint2IsCentroid() const"],
    "QgsGeometrySliverPolygonCheck": ["factoryId()", "factoryDescription()", "QgsGeometrySliverPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)"],
    "QgsWmsDimensionDialog": ["setInfo(const QgsMapLayerServerProperties::WmsDimensionInfo &info)", "QgsWmsDimensionDialog(QgsVectorLayer *layer, QStringList alreadyDefinedDimensions, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags())", "info() const"],
    "QgsHueSaturationFilter": ["setColorizeColor(const QColor &colorizeColor)", "colorizeStrength() const", "QgsHueSaturationFilter(QgsRasterInterface *input=nullptr)", "colorizeColor() const", "colorizeOn() const", "setColorizeOn(bool colorizeOn)", "grayscaleMode() const", "setColorizeStrength(int colorizeStrength)", "GrayscaleMode", "setGrayscaleMode(QgsHueSaturationFilter::GrayscaleMode grayscaleMode)", "setSaturation(int saturation)", "saturation() const"],
    "QgsMultiBandColorRenderer": ["setRedBand(int band)", "QgsMultiBandColorRenderer(QgsRasterInterface *input, int redBand, int greenBand, int blueBand, QgsContrastEnhancement *redEnhancement=nullptr, QgsContrastEnhancement *greenEnhancement=nullptr, QgsContrastEnhancement *blueEnhancement=nullptr)", "greenBand() const", "redBand() const", "create(const QDomElement &elem, QgsRasterInterface *input)", "setBlueBand(int band)", "setGreenBand(int band)", "blueBand() const"],
    "QgsSymbolLayer": ["ogrFeatureStyle(double mmScaleFactor, double mapUnitScaleFactor) const", "type() const", "setMapUnitScale(const QgsMapUnitScale &scale)", "mapUnitScale() const", "drawPreviewIcon(QgsSymbolRenderContext &context, QSize size)=0"],
    "QgsFeatureListView": ["repaintRequested()", "repaintRequested(const QModelIndexList &indexes)"],
    "QgsLayerTreeViewDefaultActions": ["actionShowFeatureCount(QObject *parent=nullptr)", "removeGroupOrLayer()", "QgsLayerTreeViewDefaultActions(QgsLayerTreeView *view)", "showFeatureCount()", "zoomToLayers(QgsMapCanvas *canvas, const QList< QgsMapLayer * > &layers)", "actionGroupSelected(QObject *parent=nullptr)", "actionRemoveGroupOrLayer(QObject *parent=nullptr)", "zoomToGroup(QgsMapCanvas *canvas)", "showInOverview()", "groupSelected()", "actionZoomToGroup(QgsMapCanvas *canvas, QObject *parent=nullptr)", "addGroup()", "uniqueGroupName(QgsLayerTreeGroup *parentGroup)", "actionAddGroup(QObject *parent=nullptr)", "renameGroupOrLayer()", "zoomToGroup()", "actionRenameGroupOrLayer(QObject *parent=nullptr)", "actionShowInOverview(QObject *parent=nullptr)"],
    "QgsZipItem": ["getZipFileList()", "vsiPrefix(const QString &uri)", "iconZip()"],
    "QgsSublayersDialog": ["ProviderType"],
    "QgsBusyIndicatorDialog": ["message() const", "setMessage(const QString &message)"],
    "QgsRasterRenderer": ["alphaBand() const", "rasterTransparency() const", "setRasterTransparency(QgsRasterTransparency *t)", "usesTransparency() const", "type() const", "setAlphaBand(int band)"],
    "QgsDxfExport": ["SymbologyExport"],
    "QgsRendererRange": ["renderState() const", "setLabel(const QString &label)", "QgsRendererRange(const QgsRendererRange &range)", "setRenderState(bool render)", "upperValue() const", "operator<(const QgsRendererRange &other) const", "label() const", "setUpperValue(double upperValue)", "setSymbol(QgsSymbol *s)", "lowerValue() const", "QgsRendererRange(double lowerValue, double upperValue, QgsSymbol *symbol, const QString &label, bool render=true)", "dump() const", "symbol() const", "setLowerValue(double lowerValue)", "swap(QgsRendererRange &other)"],
    "QgsExpressionFieldBuffer": ["expressions() const"],
    "QgsLabelSorter": ["operator()(pal::LabelPosition *lp1, pal::LabelPosition *lp2) const", "QgsLabelSorter(const QgsMapSettings &mapSettings)"],
    "QgsNineCellFilter": ["cellSizeY() const", "cellSizeX() const", "setCellSizeY(double size)", "outputNodataValue() const", "setZFactor(double factor)", "inputNodataValue() const", "setInputNodataValue(double value)", "setCellSizeX(double size)", "setOutputNodataValue(double value)", "zFactor() const"],
    "HalfEdge": ["HalfEdge(int dual, int next, int point, bool mbreak, bool forced)"],
    "QgsEffectDrawModeComboBox": ["QgsEffectDrawModeComboBox(QWidget *parent SIP_TRANSFERTHIS=nullptr)"],
    "QgsRasterRendererRegistry": ["renderersList() const", "entries() const", "insert(const QgsRasterRendererRegistryEntry &entry)", "rendererData(const QString &rendererName, QgsRasterRendererRegistryEntry &data) const", "insertWidgetFunction(const QString &rendererName, QgsRasterRendererWidgetCreateFunc func)"],
    "QgsMeshDatasetGroupTreeView": ["syncToLayer(QgsMeshLayer *layer)", "deselectAllGroups()", "selectAllGroups()", "apply()", "resetDefault(QgsMeshLayer *meshLayer)", "datasetGroupTreeRootItem()", "QgsMeshDatasetGroupTreeView(QWidget *parent=nullptr)"],
    "QgsVectorLayerLegendWidget": ["QgsVectorLayerLegendWidget(QWidget *parent=nullptr)"],
    "QgsVectorLayerRenderer": ["QgsVectorLayerRenderer(QgsVectorLayer *layer, QgsRenderContext &context)"],
    "QgsMapLayer": ["readSld(const QDomNode &node, QString &errorMessage)"],
    "QgsOptionsDialogBase": ["setSettings(QgsSettings *settings)", "warnAboutMissingObjects()", "updateWindowTitle()"],
    "QgsSymbolLayerWidget": ["updateDataDefinedProperty()", "symbolLayer()=0", "setSymbolLayer(QgsSymbolLayer *layer)=0"],
    "QgsVectorLayerJoinBuffer": ["vectorJoins() const", "QgsVectorLayerJoinBuffer(QgsVectorLayer *layer=nullptr)"],
    "QgsCredentials": ["getMasterPassword(QString &password, bool stored=false)"],
    "QgsAttributeForm": ["QgsAttributeForm(QgsVectorLayer *vl, const QgsFeature &feature=QgsFeature(), const QgsAttributeEditorContext &context=QgsAttributeEditorContext(), QWidget *parent=nullptr)", "feature()"],
    "QgsGraduatedSymbolRendererWidget": ["changeSelectedSymbols()", "showSymbolLevels()", "connectUpdateHandlers()", "reapplyColorRamp()", "updateUiFromRenderer(bool updateCount=true)", "rowsOrdered()", "changeCurrentValue(QStandardItem *item)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "findSymbolForRange(double lowerBound, double upperBound, const QgsRangeList &ranges) const", "selectedRanges()", "rangesDoubleClicked(const QModelIndex &idx)", "QgsGraduatedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "changeRangeSymbol(int rangeIdx)", "disconnectUpdateHandlers()", "labelFormatChanged()", "graduatedColumnChanged(const QString &field)", "classifyGraduated()", "rowsMoved()", "reapplySizes()", "modelDataChanged()", "changeRange(int rangeIdx)", "rangesClicked(const QModelIndex &idx)"],
    "QgsRasterCalcNode": ["setRight(QgsRasterCalcNode *right)", "QgsRasterCalcNode(QgsRasterMatrix *matrix)", "QgsRasterCalcNode(const QString &rasterName)", "QgsRasterCalcNode(Operator op, QgsRasterCalcNode *left, QgsRasterCalcNode *right)", "parseRasterCalcString(const QString &str, QString &parserErrorMsg)", "QgsRasterCalcNode(double number)", "type() const", "setLeft(QgsRasterCalcNode *left)"],
    "QgsPluginLayer": ["QgsPluginLayer(const QString &layerType, const QString &layerName=QString())"],
    "QgsGlowEffect": ["QgsGlowEffect(const QgsGlowEffect &other)"],
    "QgsMapToolEdit": ["QgsMapToolEdit(QgsMapCanvas *canvas)", "createGeometryRubberBand(QgsWkbTypes::GeometryType geometryType=QgsWkbTypes::LineGeometry, bool alternativeBand=false) const"],
    "QgsMeshDatasetGroupTreeWidget": ["datasetGroupAdded()"],
    "QgsMimeDataUtils": ["isUriList(const QMimeData *data)", "decodeUriList(const QMimeData *data)"],
    "QgsTextDiagram": ["Orientation", "Shape"],
    "QgsGeometryAngleCheck": ["factoryId()", "ResolutionMethod", "QgsGeometryAngleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "CharacterWidget": ["updateFontMerging(bool enable)"],
    "QgsAuthMethodConfig": ["setUri(const QString &uri)", "setMethod(const QString &method)"],
    "QgsAbstractLabelProvider": ["Flag"],
    "QgsCheckBoxConfigDlg": ["QgsCheckBoxConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsAttributeTableModel": ["finished()", "Role", "idToIndexList(QgsFeatureId id) const", "idToIndex(QgsFeatureId id) const"],
    "QgsConditionalStyle": ["QgsConditionalStyle(const QgsConditionalStyle &other)", "QgsConditionalStyle(const QString &rule)"],
    "CloughTocherInterpolator": ["setTriangulation(NormVecDecorator *tin)"],
    "QgsGeometryDuplicateCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "QgsGeometryDuplicateCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsMasterPasswordResetDialog": ["requestMasterPasswordReset(QString *newpass, QString *oldpass, bool *keepbackup)", "QgsMasterPasswordResetDialog(QWidget *parent=nullptr)"],
    "QgsSnappingUtils": ["mapSettings() const", "IndexingStrategy"],
    "QgsGeometryLineLayerIntersectionCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "QgsGeometryLineLayerIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsLinearMinMaxEnhancement": ["QgsLinearMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsGeometryMultipartCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "QgsGeometryMultipartCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsCategorizedSymbolRendererWidget": ["create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "deleteAllCategories()", "populateCategories()", "updateUiFromRenderer()", "addCategories()", "changeCategorizedSymbol()", "rowsMoved()", "showSymbolLevels()", "QgsCategorizedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "addCategory()", "changeCategorySymbol()", "deleteCategories()", "categoriesDoubleClicked(const QModelIndex &idx)", "selectedCategoryList()", "categoryColumnChanged(const QString &field)"],
    "QgsColorSwatchDelegate": ["QgsColorSwatchDelegate(QWidget *parent=nullptr)"],
    "QgsAlignRaster": ["setGridOffset(QPointF offset)", "gridOffset() const"],
    "QgsDxfPaintEngine": ["setLayer(const QString &layer)", "setShift(QPointF shift)", "QgsDxfPaintEngine(const QgsDxfPaintDevice *dxfDevice, QgsDxfExport *dxf)", "layer() const"],
    "QgsMapLayerComboBox": ["indexChanged(int i)", "rowsChanged()"],
    "QgsFieldComboBox": ["indexChanged(int i)"],
    "QgsCategorizedSymbolRenderer": ["rebuildHash()"],
    "QgsRasterMatrix": ["changeSign()", "acosinus()", "log10()", "lesserThan(const QgsRasterMatrix &other)", "TwoArgOperator", "setData(int cols, int rows, double *data, double nodataValue)", "power(const QgsRasterMatrix &other)", "setNodataValue(double d)", "log()", "QgsRasterMatrix(const QgsRasterMatrix &m)", "number() const", "atangens()", "OneArgOperator", "tangens()", "nodataValue() const", "cosinus()", "greaterEqual(const QgsRasterMatrix &other)", "divide(const QgsRasterMatrix &other)", "nRows() const", "multiply(const QgsRasterMatrix &other)", "logicalAnd(const QgsRasterMatrix &other)", "greaterThan(const QgsRasterMatrix &other)", "equal(const QgsRasterMatrix &other)", "asinus()", "squareRoot()", "sinus()", "nColumns() const", "lesserEqual(const QgsRasterMatrix &other)", "logicalOr(const QgsRasterMatrix &other)", "notEqual(const QgsRasterMatrix &other)"],
    "QgsShapeburstFillSymbolLayer": ["setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "distanceMapUnitScale() const", "offsetMapUnitScale() const", "QgsShapeburstFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, ShapeburstColorType colorType=SimpleTwoColor, int blurRadius=0, bool useWholeShape=true, double maxDistance=5)", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "ShapeburstColorType"],
    "QgsPenStyleComboBox": ["penStyle() const", "setPenStyle(Qt::PenStyle style)", "QgsPenStyleComboBox(QWidget *parent=nullptr)", "iconForPen(Qt::PenStyle style)"],
    "QgsGeometryCheckerUtils": ["filter1DTypes(QgsAbstractGeometry *geom)", "canDeleteVertex(const QgsAbstractGeometry *geom, int iPart, int iRing)", "sharedEdgeLength(const QgsAbstractGeometry *geom1, const QgsAbstractGeometry *geom2, double tol)", "pointOnLine(const QgsPoint &p, const QgsLineString *line, double tol, bool excludeExtremities=false)", "createGeomEngine(const QgsAbstractGeometry *geometry, double tolerance)", "lineIntersections(const QgsLineString *line1, const QgsLineString *line2, double tol)", "getGeomPart(QgsAbstractGeometry *geom, int partIdx)", "getGeomPart(const QgsAbstractGeometry *geom, int partIdx)", "polygonRings(const QgsPolygon *polygon)"],
    "QgsBrowserTreeView": ["hasExpandedDescendant(const QModelIndex &index) const", "setSettingsSection(const QString &section)"],
    "QgsAttributesFormInitCode": ["initCode() const", "setCodeSource(QgsEditFormConfig::PythonInitCodeSource initCodeSourceComboBoxIndex)", "initFilePath() const", "setInitFilePath(const QString &initFilePath)", "codeSource() const", "initFunction() const", "setInitCode(const QString &initCode)", "setInitFunction(const QString &initFunction)"],
    "QgsLinePatternFillSymbolLayer": ["ogrFeatureStyleWidth(double widthScaleFactor) const"],
    "QgsStyleManagerDialog": ["editColorRamp()", "currentItemName()", "editSymbol()", "currentItemType()"],
    "QgsSearchQueryBuilder": ["loadQuery()", "saveQuery()"],
    "QgsLegendSymbolItem": ["QgsLegendSymbolItem(const QgsLegendSymbolItem &other)"],
    "QgsLayerTreeRegistryBridge": ["groupRemovedChildren()", "isEnabled() const", "setNewLayersVisible(bool enabled)", "newLayersVisible() const", "removeLayersFromRegistry(const QStringList &layerIds)", "layersAdded(const QList< QgsMapLayer * > &layers)", "layersWillBeRemoved(const QStringList &layerIds)", "groupWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "setEnabled(bool enabled)"],
    "QgsRuleBasedRendererModel": ["ruleForIndex(const QModelIndex &index) const", "removeRule(const QModelIndex &index)", "insertRule(const QModelIndex &parent, int before, QgsRuleBasedRenderer::Rule *newrule)", "finishedAddingRules()", "updateRule(const QModelIndex &parent, int row)", "updateRule(const QModelIndex &index)", "clearFeatureCounts()", "willAddRules(const QModelIndex &parent, int count)"],
    "QgsFields": ["FieldOrigin"],
    "QgsFeatureModel": ["fidToIndex(QgsFeatureId fid)=0"],
    "QgsTextEditConfigDlg": ["QgsTextEditConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsSymbolsListWidget": ["setMarkerSize(double size)", "setLineWidth(double width)", "updateDataDefinedMarkerSize()", "changed()", "setSymbolColor(const QColor &color)", "updateDataDefinedLineWidth()", "setMarkerAngle(double angle)", "updateDataDefinedMarkerAngle()", "clipFeaturesToggled(bool checked)"],
    "QgsAttributeTableAction": ["featureForm()", "execute()"],
    "QgsAttributeTypeLoadDialog": ["QgsAttributeTypeLoadDialog(QgsVectorLayer *vl)"],
    "QgsAuthCertInfo": ["trustCacheRebuilt()"],
    "QgsRendererCategory": ["swap(QgsRendererCategory &other)"],
    "QgsMapRendererJob": ["QgsMapRendererJob(const QgsMapSettings &settings)"],
    "QgsFieldCalculator": ["mOutputFieldTypeComboBox_activated(int index)", "mOutputFieldNameLineEdit_textChanged(const QString &text)", "QgsFieldCalculator(QgsVectorLayer *vl, QWidget *parent=nullptr)", "mNewFieldGroupBox_toggled(bool on)", "changedAttributeId() const", "mUpdateExistingGroupBox_toggled(bool on)", "mCreateVirtualFieldCheckbox_stateChanged(int state)"],
    "QgsWkbPtr": ["operator unsigned char *() const", "operator>>(int &v) const", "operator>>(QgsWkbTypes::Type &v) const", "QgsWkbPtr(unsigned char *p, int size)", "operator>>(double &v) const", "operator>>(float &r) const", "operator+=(int n)", "operator>>(unsigned int &v) const", "operator>>(char &v) const"],
    "QgsLayerTreeMapCanvasBridge": ["rootGroup() const", "autoSetupOnFirstLayer() const", "mapCanvas() const"],
    "QgsGeometrySegmentLengthCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "QgsGeometrySegmentLengthCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsGeometryDuplicateNodesCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "QgsGeometryDuplicateNodesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsLUDialog": ["upperValue() const", "lowerValue() const", "setUpperValue(const QString &val)", "QgsLUDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)", "setLowerValue(const QString &val)"],
    "QgsIFeatureSelectionManager": ["QgsIFeatureSelectionManager(QObject *parent)"],
    "QgsAttributeEditorContext": ["FormMode", "parentContext() const", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, FormMode formMode)", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, const QgsRelation &relation, RelationMode relationMode, FormMode widgetMode)"],
    "QgsGeometryRubberBand": ["IconType", "QgsGeometryRubberBand(QgsMapCanvas *mapCanvas, QgsWkbTypes::GeometryType geomType=QgsWkbTypes::LineGeometry)"],
    "QgsExpressionHighlighter": ["QgsExpressionHighlighter(QTextDocument *parent=nullptr)", "addFields(const QStringList &fieldList)"],
    "QgsErrorMessage": ["message() const", "file() const", "line() const", "tag() const", "function() const"],
    "QgsSingleSymbolRendererWidget": ["create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "QgsSingleSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsPaintEngineHack": ["fixEngineFlags(QPaintEngine *engine)", "fixFlags()"],
    "QgsCompoundCurve": ["QgsCompoundCurve(const QgsCompoundCurve &curve)"],
    "QgsDateTimeEditConfig": ["QgsDateTimeEditConfig(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsShapeburstFillSymbolLayerWidget": ["setColor(const QColor &color)", "setColor2(const QColor &color)"],
    "QgsGroupBoxCollapseButton": ["QgsGroupBoxCollapseButton(QWidget *parent=nullptr)", "shiftDown() const", "setAltDown(bool updown)", "setShiftDown(bool shiftdown)", "altDown() const"],
    "QgsSimplifyMethod": ["MethodType"],
    "pal::Problem": ["init_sol_falp()", "reduce()"],
    "QgsLayerTreeView": ["onModelReset()", "onExpandedChanged(QgsLayerTreeNode *node, bool expanded)", "onCurrentChanged()", "modelRowsInserted(const QModelIndex &index, int start, int end)", "layerForIndex(const QModelIndex &index) const", "updateExpandedStateToNode(const QModelIndex &index)", "updateExpandedStateFromNode(QgsLayerTreeNode *node)", "modelRowsRemoved()"],
    "QgsErrorItem": ["QgsErrorItem(QgsDataItem *parent, const QString &error, const QString &path)"],
    "QgsRasterBlock": ["applyNoDataValues(const QgsRasterRangeList &rangeList)", "toString() const"],
    "QgsMapRendererSequentialJob": ["internalFinished()", "QgsMapRendererSequentialJob(const QgsMapSettings &settings)"],
    "QgsGeometryDegeneratePolygonCheck": ["factoryId()", "ResolutionMethod", "QgsGeometryDegeneratePolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "EditBlockerDelegate": ["EditBlockerDelegate(QObject *parent=nullptr)"],
    "QgsRaster": ["ColorInterpretation", "RasterBuildPyramids", "RasterProgressType", "RasterPyramidsFormat", "IdentifyFormat"],
    "QgsSingleBandGrayRenderer": ["QgsSingleBandGrayRenderer(QgsRasterInterface *input, int grayBand)", "setGrayBand(int band)", "create(const QDomElement &elem, QgsRasterInterface *input)", "grayBand() const", "setGradient(Gradient gradient)", "Gradient", "contrastEnhancement() const", "gradient() const"],
    "QgsFontMarkerSymbolLayerWidget": ["setColor(const QColor &color)", "setAngle(double angle)", "setSize(double size)", "setFontFamily(const QFont &font)"],
    "QgsFieldValidator": ["QgsFieldValidator(QObject *parent, const QgsField &field, const QString &defaultValue, const QString &dateFormat=\"yyyy-MM-dd\")", "dateFormat() const"],
    "QgsRenderChecker": ["setElapsedTimeTarget(int target)", "setControlPathSuffix(const QString &name)"],
    "QgsDataCollectionItem": ["addChild(QgsDataItem *item)"],
    "QgsExpressionItem": ["QgsExpressionItem(const QString &label, const QString &expressionText, QgsExpressionItem::ItemType itemType=ExpressionNode)", "getExpressionText() const", "ItemType", "QgsExpressionItem(const QString &label, const QString &expressionText, const QString &helpText, QgsExpressionItem::ItemType itemType=ExpressionNode)"],
    "QgsAttributesDnDTree": ["setType(QgsAttributesDnDTree::Type value)", "QgsAttributesDnDTree(QgsVectorLayer *layer, QWidget *parent=nullptr)", "addContainer(QTreeWidgetItem *parent, const QString &title, int columnCount)", "type() const", "selectFirstMatchingItem(const QgsAttributesFormProperties::DnDTreeItemData &data)", "Type"],
    "QgsVectorFileWriter": ["WriterError", "setSymbologyExport(QgsVectorFileWriter::SymbologyExport symExport)", "symbologyExport() const", "SymbologyExport", "driverMetadata(const QString &driverName, MetaData &driverMetadata)", "OptionType"],
    "QgsMapLayerLegendUtils": ["legendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "setLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex, const QString &newLabel)", "hasLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "hasLegendNodeOrder(QgsLayerTreeLayer *nodeLayer)", "setLegendNodeOrder(QgsLayerTreeLayer *nodeLayer, const QList< int > &order)", "legendNodeOrder(QgsLayerTreeLayer *nodeLayer)"],
    "QgsDataDefinedRotationDialog": ["QgsDataDefinedRotationDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsDetailedItemDelegate": ["verticalSpacing() const", "setHorizontalSpacing(int value)", "horizontalSpacing() const", "setVerticalSpacing(int value)"],
    "QgsMapOverviewCanvas": ["updateFullExtent()", "mapRenderingFinished()", "QgsMapOverviewCanvas(QWidget *parent=nullptr, QgsMapCanvas *mapCanvas=nullptr)", "enableAntiAliasing(bool flag)"],
    "QgsDiagram": ["QgsDiagram(const QgsDiagram &other)", "clearCache()"],
    "QgsGeometryDangleCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "QgsGeometryDangleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsRasterMinMaxWidget": ["setBands(const QList< int > &bands)"],
    "QgsGml": ["QgsGml(const QString &typeName, const QString &geometryAttribute, const QgsFields &fields)", "totalStepsUpdate(int totalSteps)", "dataReadProgress(int progress)"],
    "QgsRendererWidget": ["QgsRendererWidget(QgsVectorLayer *layer, QgsStyle *style)", "contextMenuViewCategories(QPoint p)", "paste()", "copy()", "refreshSymbolView()"],
    "QgsVectorFieldSymbolLayer": ["createFromSld(QDomElement &element)", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "VectorFieldType", "setAngleOrientation(AngleOrientation orientation)", "distanceMapUnitScale() const", "vectorFieldType() const", "angleOrientation() const", "AngleUnits", "setVectorFieldType(VectorFieldType type)", "xAttribute() const", "setScale(double s)", "scale() const", "setYAttribute(const QString &attribute)", "angleUnits() const", "setAngleUnits(AngleUnits units)", "setXAttribute(const QString &attribute)", "AngleOrientation", "yAttribute() const"],
    "QgsCptCityCollectionItem": ["addChild(QgsCptCityDataItem *item)", "QgsCptCityCollectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "childrenRamps(bool recursive)", "setPopulated()"],
    "QgsRuggednessFilter": ["QgsRuggednessFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsGeometryDuplicateCheckError": ["duplicates() const", "QgsGeometryDuplicateCheckError(const QgsGeometryCheck *check, const QgsGeometryCheckerUtils::LayerFeature &layerFeature, const QgsPointXY &errorLocation, const QMap< QString, QgsFeaturePool * > &featurePools, const QMap< QString, QList< QgsFeatureId >> &duplicates)"],
    "QgsStyleExportImportDialog": ["doExportImport()", "importTypeChanged(int)"],
    "pal::PriorityQueue": ["insert(int key, double p)", "remove(int key)", "print()", "getSizeByPos()", "sort()", "upheap(int key)", "getBest()", "getSize()", "decreaseKey(int key)", "setPriority(int key, double new_p)", "isIn(int key)", "downheap(int id)", "getId(int key)"],
    "QgsAspectFilter": ["QgsAspectFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsTotalCurvatureFilter": ["QgsTotalCurvatureFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsDualView": ["openConditionalStyles()"],
    "QgsDial": ["valueChanged(const QVariant &)", "setSingleStep(const QVariant &step)", "setMinimum(const QVariant &min)", "variantValue() const", "setValue(const QVariant &value)", "setMaximum(const QVariant &max)"],
    "QgsCptCityColorRampItem": ["QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QStringList &variantList, bool initialize=false)", "ramp() const", "init()", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QString &variantName=QString(), bool initialize=false)"],
    "QgsClipper": ["trimPolygon(QPolygonF &pts, const QgsRectangle &clipRect)"],
    "QgsVectorFileWriter::IntOption": ["IntOption(const QString &docString, int defaultValue)"],
    "QgsPointDisplacementRendererWidget": ["create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "QgsPointDisplacementRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsLayerTreeModelLegendNode": ["setUserLabel(const QString &userLabel)", "userLabel() const", "isScaleOK(double scale) const", "isEmbeddedInParent() const", "setEmbeddedInParent(bool embedded)"],
    "QgsCacheIndexFeatureId": ["QgsCacheIndexFeatureId(QgsVectorLayerCache *)"],
    "QgsXmlUtils": ["readRectangle(const QDomElement &element)"],
    "QgsGeometryPointCoveredByLineCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "QgsGeometryPointCoveredByLineCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsShadowEffectWidget": ["create()", "QgsShadowEffectWidget(QWidget *parent=nullptr)"],
    "QgsPalLayerSettings": ["QuadrantPosition", "QgsPalLayerSettings(const QgsPalLayerSettings &s)", "UpsideDownLabels", "MultiLineAlign"],
    "QgsContrastEnhancementFunction": ["QgsContrastEnhancementFunction(Qgis::DataType, double, double)", "QgsContrastEnhancementFunction(const QgsContrastEnhancementFunction &f)"],
    "QgsGeometryFollowBoundariesCheck": ["factoryCheckType()", "factoryDescription()", "factoryId()", "QgsGeometryFollowBoundariesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, QgsVectorLayer *checkLayer)", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryCompatibleGeometryTypes()"],
    "QgsMapLayerModel": ["addLayers(const QList< QgsMapLayer * > &layers)", "removeLayers(const QStringList &layerIds)"],
    "QgsEllipseSymbolLayer": ["createFromSld(QDomElement &element)", "setSymbolHeightMapUnitScale(const QgsMapUnitScale &scale)", "setSymbolWidth(double w)", "strokeWidth() const", "strokeWidthMapUnitScale() const", "symbolWidth() const", "setSymbolHeight(double h)", "symbolHeightMapUnitScale() const", "setStrokeWidth(double w)", "strokeStyle() const", "symbolHeight() const", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "symbolWidthMapUnitScale() const", "setSymbolWidthMapUnitScale(const QgsMapUnitScale &scale)", "setStrokeStyle(Qt::PenStyle strokeStyle)"],
    "QgsQueryBuilder": ["clear()", "setDatasourceDescription(const QString &uri)"],
    "QgsSmartGroupEditorDialog": ["QgsSmartGroupEditorDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsVectorLayerEditUtils": ["QgsVectorLayerEditUtils(QgsVectorLayer *layer)"],
    "QgsExpression": ["Functions()", "BuiltinFunctions()", "SpatialOperator"],
    "QgsPythonRunner": ["evalCommand(QString command, QString &result)=0", "runCommand(QString command, QString messageOnError=QString())=0"],
    "QgsSvgSelectorWidget": ["currentSvgPath() const", "populateList()", "svgSelected(const QString &path)"],
    "QgsAttributeFormLegacyInterface": ["QgsAttributeFormLegacyInterface(const QString &function, const QString &pyFormName, QgsAttributeForm *form)"],
    "pal::Util": ["unmulti(const GEOSGeometry *the_geom)"],
    "QgsContrastEnhancement": ["QgsContrastEnhancement(const QgsContrastEnhancement &ce)", "contrastEnhancementAlgorithm() const", "writeXml(QDomDocument &doc, QDomElement &parentElem) const", "readXml(const QDomElement &elem)"],
    "QgsRasterRendererWidget": ["max(int index=0)", "setMin(const QString &value, int index=0)", "selectedBand(int index=0)", "QgsRasterRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent)", "setStdDev(const QString &value)", "min(int index=0)", "stdDev()", "setMax(const QString &value, int index=0)"],
    "QgsSymbolLevelItem": ["QgsSymbolLevelItem(QgsSymbol *symbol, int layer)"],
    "QgsPaintEffect": ["QgsPaintEffect(const QgsPaintEffect &other)"],
    "QgsRendererAbstractMetadata": ["createRendererFromSld(QDomElement &elem, QgsWkbTypes::GeometryType geomType)"],
    "QgsPenJoinStyleComboBox": ["QgsPenJoinStyleComboBox(QWidget *parent=nullptr)", "penJoinStyle() const", "setPenJoinStyle(Qt::PenJoinStyle style)"],
    "QgsRasterBandStats": ["Stats"],
    "QgsPalettedRasterRenderer": ["create(const QDomElement &elem, QgsRasterInterface *input)"],
    "QgsFieldExpressionWidget": ["isExpressionValid(const QString &expressionStr)", "setLeftHandButtonStyle(bool isLeft)", "currentFieldChanged()"],
    "QgsDirectoryItem": ["directoryChanged()", "init()"],
    "QgsSymbolLevelsDialog": ["setForceOrderingEnabled(bool enabled)"],
    "QgsEffectStack": ["QgsEffectStack(const QgsEffectStack &other)"],
    "pal::FeaturePart": ["FeaturePart(const FeaturePart &other)"],
    "QgsGeometryLineIntersectionCheck": ["factoryId()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryIsCompatible(QgsVectorLayer *layer)", "QgsGeometryLineIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)"],
    "QgsAttributeTableMapLayerAction": ["QgsAttributeTableMapLayerAction(const QString &name, QgsDualView *dualView, QgsMapLayerAction *action, const QModelIndex &fieldIdx)", "execute()"],
    "QgisVisitor": ["QgisVisitor(QList< QgsFeatureId > &list)"]
}

ACCEPTABLE_MISSING_ADDED_NOTE = [
    'QgsAuthConfigIdEdit',
    'QgsDial',
    'QgsMapLayerAction',
    'QgsSvgSelectorGroupsModel',
    'QgsLinePatternFillSymbolLayer',
    'QgsImageFillSymbolLayer',
    'QgsAuthMethodRegistry',
    'QgsExpressionNodeFunction',
    'QgsSQLStatement::Visitor',
    'QgsDiagramLayerSettings',
    'QgsRenderChecker',
    'QgsSQLStatement::NodeColumnSorted',
    'pal::FeaturePart',
    'QgsRasterResampleFilter',
    'QgsPluginManagerInterface',
    'QgsAttributes',
    'QgsRangeWidgetFactory',
    'QgsMarkerSymbol',
    'QgsLinearlyInterpolatedDiagramRenderer',
    'QgsTextDiagram',
    'QgsShapeburstFillSymbolLayer',
    'QgsCptCityArchive',
    'QgsAspectFilter',
    'QgsValueRelationConfigDlg',
    'QgsOgcUtils',
    'QgsGeometryMultipartCheck',
    'QgsFillSymbol',
    'QgsArrowSymbolLayerWidget',
    'QgsDataDefinedValueDialog',
    'QgsCheckboxWidgetFactory',
    'QgisVisitor',
    'QgsVectorLayerFeatureSource',
    'QgsLabelCandidate',
    'QgsGeometrySliverPolygonCheck',
    'QgsMarkerLineSymbolLayerWidget',
    'QgsRelationReferenceFactory',
    'QgsPaintEngineHack',
    'QgsFieldExpressionWidget',
    'QgsGradientFillSymbolLayer',
    'QgsValueRelationSearchWidgetWrapper',
    'QgsMasterPasswordResetDialog',
    'QgsPointPatternFillSymbolLayer',
    'QgsDerivativeFilter',
    'QgsSymbolLayerMetadata',
    'QgsGpsConnection',
    'QgsAbstractFeatureIteratorFromSource',
    'QgsDiagramLabelFeature',
    'QgsRasterDataProvider',
    'QgsSymbolLayer',
    'QgsGpsInformation',
    'QgsActionManager',
    'QgsLUDialog',
    'QgsPointLocator_DumpTree',
    'QgsExpressionNodeBinaryOperator',
    'QgsErrorMessage',
    'QgsFeatureModel',
    'QgsSimpleMarkerSymbolLayerWidget',
    'QgsAuthMethodEdit',
    'QgsGenericFeatureSelectionManager',
    'QgsSQLComposerDialog::TableSelectedCallback',
    'QgsAbstractCacheIndex',
    'QgsMimeDataUtils',
    'QgsRuleBasedLabelProvider',
    'QgsExternalResourceWidgetWrapper',
    'QgsRuntimeProfiler',
    'QgsRasterLayer',
    'QgsMarkerSymbolLayer',
    'QgsAdvancedDigitizingDockWidget::CadConstraint',
    'QgsScaleCalculator',
    'QgsRelation',
    'QgsDiagramRenderer',
    'QgsAttributeEditorRelation',
    'QgsSymbolLevelsDialog',
    'QgsRasterRenderer',
    'QgsGeometryPointCoveredByLineCheck',
    'QgsRenderContext',
    'QgsFontMarkerSymbolLayerWidget',
    'QgsConnectionPool',
    'QgsProjectBadLayerHandler',
    'QgsMarkerLineSymbolLayer',
    'QgsTextLabelFeature',
    'QgsLineSymbol',
    'QgsDataDefinedWidthDialog',
    'pal::InternalException',
    'QgsCredentials',
    'QgsHistogramDiagram',
    'QgsDiagramSettings',
    'QgsSQLStatement::NodeCast',
    'QgsVectorLayerUndoCommandChangeGeometry',
    'QgsRelief',
    'QgsCsException',
    'QgsMessageLogViewer',
    'QgsDateTimeEdit',
    'QgsBilinearRasterResampler',
    'QgsSymbolLayerWidget',
    'QgsSpatialIndexCopyVisitor',
    'QgsExpressionNode::NodeList',
    'QgsVirtualLayerDefinitionUtils',
    'QgisInterface',
    'QgsAuthIdentitiesEditor',
    'QgsLinearMinMaxEnhancement',
    'QgsActionMenu',
    'QgsMessageBar',
    'QgsMapToolAdvancedDigitizing',
    'QgsWidgetWrapper',
    'pal::CostCalculator',
    'QgsGeometrySelfContactCheck',
    'QgsSQLStatement::RecursiveVisitor',
    'QgsVectorLayerJoinBuffer',
    'QgsRequestHandler',
    'QgsExpressionHighlighter',
    'QgisPlugin',
    'QgsExpressionNodeLiteral',
    'QgsAuthConfigEdit',
    'QgsAdvancedDigitizingCanvasItem',
    'QgsFillSymbolLayer',
    'QgsVectorLayerTools',
    'QgsRendererRange',
    'QgsPointLocator_Stream',
    'QgsSQLStatement::NodeLiteral',
    'QgsRunProcess',
    'QgsDataProvider',
    'QgsVectorFileWriter::HiddenOption',
    'QgsRasterHistogram',
    'QgsDashSpaceDialog',
    'QgsCubicRasterResampler',
    'QgsDrawSourceWidget',
    'QgsSvgSelectorDialog',
    'QgsFontMarkerSymbolLayer',
    'QgsAttributeFormLegacyInterface',
    'QgsStyleGroupSelectionDialog',
    'QgsGeometryLineLayerIntersectionCheck',
    'QgsAuthEditorWidgets',
    'QgsFeatureRenderer',
    'pal::PalException::UnknownFeature',
    'QgsConnectionPoolGroup',
    'QgsGeometryDangleCheck',
    'QgsRelationEditorWidget',
    'QgsContrastEnhancementFunction',
    'QgsGeometryPointInPolygonCheck',
    'QgsPluginLayer',
    'QgsDiagramInterpolationSettings',
    'QgsSymbolLayerUtils',
    'QgsCategorizedSymbolRenderer',
    'QgsRasterRendererWidget',
    'QgsAuthConfigSslServer',
    'QgsVirtualLayerDefinition::SourceLayer',
    'QgsLabelSorter',
    'QgsSQLStatement::NodeBinaryOperator',
    'QgsLayerDefinition',
    'QgsMapUnitScaleDialog',
    'QgsSpinBox',
    'QgsExpressionNode',
    'QgsValueMapConfigDlg',
    'QgsSublayersDialog',
    'QgsEditorWidgetFactory',
    'QgsMessageOutput',
    'QgsProviderRegistry',
    'QgsEditorConfigWidget',
    'QgsRasterFormatSaveOptionsWidget',
    'TriDecorator',
    'QgsHiddenWidgetWrapper',
    'QgsAuthAuthoritiesEditor',
    'QgsSingleBandColorDataRenderer',
    'QgsLabelPosition',
    'QgsSQLStatement::NodeList',
    'QgsUnitSelectionWidget',
    'QgsMapToolIdentifyFeature',
    'QgsGraphAnalyzer',
    'QgsUniqueValuesWidgetWrapper',
    'QgsSQLStatement::NodeUnaryOperator',
    'QgsPixmapLabel',
    'QgsDxfRuleBasedLabelProvider',
    'QgsSimpleLineSymbolLayerWidget',
    'QgsGeometrySelfIntersectionCheckError',
    'QgsStaticExpressionFunction',
    'QgsDetailedItemData',
    'QgsGpsdConnection',
    'QgsRelationReferenceConfigDlg',
    'QgsFeatureListModel',
    'QgsRasterPipe',
    'QgsScaleVisibilityDialog',
    'QgsMessageBarItem',
    'pal::Feats',
    'QgsCptCityBrowserModel',
    'QgsQtLocationConnection',
    'QgsTransaction',
    'QgsSQLStatement::NodeInOperator',
    'QgsFileWidget',
    'HalfEdge',
    'QgsBrushStyleComboBox',
    'QgsAccessControlFilter',
    'QgsSQLComposerDialog::SQLValidatorCallback',
    'QgsRasterHistogramWidget',
    'QgsEditorWidgetWrapper',
    'QgsExpressionItemSearchProxy',
    'QgsDartMeasurement',
    'QgsCptCityDirectoryItem',
    'QgsMapToPixel',
    'QgsDateTimeEditFactory',
    'NormVecDecorator',
    'QgsMapCanvas::CanvasProperties',
    'LinTriangleInterpolator',
    'QWebFrame',
    'QgsDirectoryItem',
    'QgsRasterInterface',
    'QgsSymbol',
    'QgsExpressionFunction',
    'QgsRelationManager',
    'QgsRasterTransparencyWidget',
    'QgsPieDiagram',
    'QgsAuthConfigSelect',
    'QgsInternalGeometryEngine',
    'QgsVectorLayerFeatureIterator',
    'QgsOptionsDialogBase',
    'QgsPythonRunner',
    'QgsGeometryValidator',
    'QgsRasterRange',
    'QgsExternalResourceWidget',
    'QgsGeometrySelfIntersectionCheck',
    'QgsAttributeTableModel',
    'QgsMapToolIdentify',
    'QgsSQLStatement::NodeTableDef',
    'QgsStyleManagerDialog',
    'QgsRangeConfigDlg',
    'QgsFilterLineEdit',
    'QgsGeos',
    'QgsException',
    'QgsSymbolsListWidget',
    'QgsRuleBasedRenderer',
    'Qgis',
    'QgsCoordinateReferenceSystem',
    'QgsAuthMethodPlugins',
    'QgsSQLStatement::NodeSelectedColumn',
    'QgsGml',
    'QgsDummyConfigDlg',
    'QgsRendererCategory',
    'QgsRasterResampler',
    'QgsEnumerationWidgetFactory',
    'QgsSvgCache',
    'QgsAttributeTableDelegate',
    'QgsFeature',
    'QgsSatelliteInfo',
    'QgsAuthGuiUtils',
    'QgsAttributeEditorContext',
    'QgsGeometryDuplicateNodesCheck',
    'QgsRasterDrawer',
    'QgsBlendModeComboBox',
    'QgsExpressionNodeCondition::WhenThen',
    'pal::InternalException::WrongGeometry',
    'QgsAbstractGeometrySimplifier',
    'pal::LabelPosition',
    'QgsPointLocator_VisitorEdgesInRect',
    'QgsAuthConfigUriEdit',
    'QgsGpsConnectionRegistry',
    'QgsAuthCertInfo',
    'QgsPanelWidgetStack',
    'QgsGmlStreamingParser::LayerProperties',
    'QgsIFeatureSelectionManager',
    'QgsRaster',
    'QgsVectorLayerEditPassthrough',
    'QgsFeatureListView',
    'QgsGeometryTypeCheck',
    'QgsAuthSslErrorsDialog',
    'pal::Layer',
    'QgsSQLStatement::NodeSelect',
    'QgsSVGFillSymbolLayerWidget',
    'QgsSingleSymbolRenderer',
    'QgsAdvancedDigitizingDockWidget',
    'QgsPointLocator_VisitorNearestEdge',
    'QgsAuthCertTrustPolicyComboBox',
    'QgsPreviewEffect',
    'QgsGeometryAreaCheck',
    'QgsVectorLayerUndoCommand',
    'QgsHillshadeFilter',
    'QgsColorWidgetFactory',
    'QgsRendererPropertiesDialog',
    'QgsAttributeEditorField',
    'QgsBrowserWatcher',
    'QgsDxfExport',
    'QgsProjectVersion',
    'QgsSingleBandPseudoColorRenderer',
    'QgsAuthSslConfigDialog',
    'QgsOgcUtilsExprToFilter',
    'QgsOgcUtilsSQLStatementToFilter',
    'QgsPointLocator_VisitorNearestVertex',
    'QgsTransactionGroup',
    'QgsTolerance',
    'pal::Problem',
    'QgsAuthMethod',
    'QgsStyle',
    'QgsTextEditWrapper',
    'QgsAuthMethodConfig',
    'QgsSingleSymbolRendererWidget',
    'QgsGeometryDuplicateCheckError',
    'QgsRasterShader',
    'QgsAuthSslConfigWidget',
    'pal::PalException::NotImplemented',
    'QgsZipItem',
    'QgsSvgMarkerSymbolLayer',
    'QgsPalettedRasterRenderer',
    'QgsGraphDirector',
    'QgsRectangle',
    'QgsGeometry::Error',
    'QgsServerInterface',
    'QgsInterpolator',
    'QgsLayerPropertiesWidget',
    'QgsSymbolSelectorDialog',
    'QgsExpressionSelectionDialog',
    'QgsRasterBlock',
    'QgsSingleBandPseudoColorRendererWidget',
    'QgsRubberBand',
    'QgsAttributeEditorElement',
    'QgsHighlight',
    'QgsConstWkbPtr',
    'QgsCharacterSelectorDialog',
    'QgsMapTip',
    'QgsErrorDialog',
    'QgsPalLayerSettings',
    'QgsGeometry',
    'QgsValueMapSearchWidgetWrapper',
    'QgsMapCanvasItem',
    'QgsEncodingFileDialog',
    'QgsRendererRulePropsWidget',
    'QgsFeatureStore',
    'QgsIDWInterpolator',
    'pal::InternalException::Empty',
    'QgsTextEditConfigDlg',
    'QgsConditionalLayerStyles',
    'QgsExpressionNodeUnaryOperator',
    'QgsMessageOutputConsole',
    'QgsRelationReferenceWidgetWrapper',
    'QgsRasterCalculator',
    'QgsNineCellFilter',
    'Triangulation',
    'QgsDualView',
    'QgsAuthCrypto',
    'QgsDetailedItemWidget',
    'QgsDateTimeEditConfig',
    'QgsGroupBoxCollapseButton',
    'QgsConditionalStyle',
    'QgsGeometryFollowBoundariesCheck',
    'QgsBrightnessContrastFilter',
    'QgsDxfPaintDevice',
    'QgsLongLongValidator',
    'QgsMapLayerActionRegistry',
    'QgsHueSaturationFilter',
    'QgsPanelWidget',
    'QgsTextEditWidgetFactory',
    'QgsCachedFeatureWriterIterator',
    'QgsVectorLayerRendererInterruptionChecker',
    'QgsCredentialsNone',
    'QgsCentroidFillSymbolLayerWidget',
    'QgsGmlSchema',
    'QgsFeatureRequest',
    'QgsVectorLayer',
    'QgsSingleBandGrayRendererWidget',
    'QgsXmlUtils',
    'Vector3D',
    'QgsMapToolZoom',
    'QgsMapToolPan',
    'QgsRangeWidgetWrapper',
    'QgsPluginLayerRegistry',
    'QgsAction',
    'Qgs25DRenderer',
    'QgsVectorFileWriter::BoolOption',
    'QgsSimpleFillSymbolLayer',
    'QgsDetailedItemDelegate',
    'QgsDxfPaintEngine',
    'QgsExpressionItem',
    'QgsDateTimeEditWrapper',
    'QgsGlowWidget',
    'QgsGroupWmsDataDialog',
    'QgsVectorFileWriter',
    'QgsSQLComposerDialog',
    'QgsMapToolCapture',
    'pal::InternalException::UnknownGeometry',
    'QgsDiagram',
    'QgsExpressionBuilderWidget',
    'QgsRendererRasterPropertiesWidget',
    'QgsRasterRendererRegistry',
    'TriangleInterpolator',
    'QgsDxfLabelProvider',
    'QgsCptCityColorRamp',
    'QgsVectorLayerEditUtils',
    'CharacterWidget',
    'QgsSearchQueryBuilder',
    'QgsMessageLogConsole',
    'QgsVectorLayerSelectionManager',
    'QgsVector',
    'QgsTrackedVectorLayerTools',
    'QgsSmartGroupCondition',
    'pal::Sol',
    'QgsAttributeTypeLoadDialog',
    'QgsCentroidFillSymbolLayer',
    'QgsWkbPtr',
    'QgsMapUnitScale',
    'QgsFeatureSelectionModel',
    'QgsVectorLayerUndoCommandDeleteAttribute',
    'QgsRasterChecker',
    'QgsPkiBundle',
    'QgsAbstractFeatureIterator',
    'QgsScaleWidget',
    'QgsDataDefinedRotationDialog',
    'QgsAuthTrustedCAsDialog',
    'QgsAuthCertUtils',
    'QgsGraduatedSymbolRendererWidget',
    'QgsTransformWidget',
    'QgsCredentialDialog',
    'QgsShapeburstFillSymbolLayerWidget',
    'QgsSpatialIndex',
    'QgsAnimatedIcon',
    'QgsRasterIterator',
    'QgsMapLayer',
    'QgsVectorLayerUndoCommandChangeAttribute',
    'QgsUniqueValuesConfigDlg',
    'QgsRuleBasedRendererModel',
    'QgsHeatmapRendererWidget',
    'QgsCapabilitiesCache',
    'QgsScaleUtils',
    'QgsError',
    'pal::PointSet',
    'QgsExpressionBuilderDialog',
    'QgsExpressionNodeColumnRef',
    'QgsBusyIndicatorDialog',
    'QgsEllipseSymbolLayerWidget',
    'QgsFontUtils',
    'pal::InternalException::Full',
    'QgsRendererMetadata',
    'QgsNetworkReplyParser',
    'QgsDefaultSearchWidgetWrapper',
    'QgsRasterCalcNode',
    'QgsPointPatternFillSymbolLayerWidget',
    'QgsVectorFileWriter::StringOption',
    'QgsOWSSourceSelect',
    'QgsUuidWidgetFactory',
    'QgsHiddenWidgetFactory',
    'DualEdgeTriangulation',
    'CloughTocherInterpolator',
    'QgsTableWidgetItem',
    'QgsGeometryGeneratorSymbolLayer',
    'QgsGeometryAngleCheck',
    'QgsAttributeTableAction',
    'QgsZonalStatistics',
    'QgsLinearMinMaxEnhancementWithClip',
    'QgsSlopeFilter',
    'QgsValueRelationWidgetWrapper',
    'QgsSymbolLayerRegistry',
    'QgsAttributeForm',
    'QgsDatumTransformDialog',
    'pal::PriorityQueue',
    'Qgs25DRendererWidget',
    'QgsShadowEffectWidget',
    'QgsSymbolLayerAbstractMetadata',
    'QgsQueryBuilder',
    'QgsSQLStatement::NodeColumnRef',
    'QgsVirtualLayerDefinition',
    'QgsGeometryHoleCheck',
    'QgsVectorFileWriter::Option',
    'QgsProviderMetadata',
    'QgsRuleBasedRendererWidget',
    'QgsPenCapStyleComboBox',
    'QgsValueMapWidgetWrapper',
    'QgsScopeLogger',
    'QgsGeometrySegmentLengthCheck',
    'QgsGeometryContainedCheckError',
    'QgsClassificationWidgetWrapper',
    'QgsAuthMethodMetadata',
    'QgsMapServiceException',
    'QgsEllipseSymbolLayer',
    'QgsMultiBandColorRendererWidget',
    'QgsContrastEnhancement',
    'QgsCollapsibleGroupBoxBasic',
    'pal::PalException::LayerExists',
    'QgsFeatureListViewDelegate',
    'QgsManageConnectionsDialog',
    'QgsFieldValidator',
    'QgsDataCollectionItem',
    'QgsPalLabeling',
    'pal::Pal',
    'QgsAuthCertManager',
    'QgsSymbolSelectorWidget',
    'QgsLabelSearchTree',
    'QgsLocaleNumC',
    'QgsColorBrewerPalette',
    'pal::Util',
    'QgsProjectItem',
    'QgsVectorFileWriter::IntOption',
    'QgsWkbException',
    'QgsGeometryRubberBand',
    'QgsGeometryLineIntersectionCheck',
    'QgsAuthCertEditors',
    'QgsSymbolRenderContext',
    'QgsVertexMarker',
    'QgsRasterFileWriter',
    'QgsCategorizedSymbolRendererWidget',
    'QgsMapOverviewCanvas',
    'pal::GeomFunction',
    'QgsRuleBasedRenderer::Rule',
    'QgsErrorItem',
    'QgsRendererRulePropsDialog',
    'QgsGraphBuilderInterface',
    'QgsSvgMarkerSymbolLayerWidget',
    'QgsExternalResourceConfigDlg',
    'QgsClassificationWidgetWrapperFactory',
    'QgsServerFilter',
    'QgsDataSourceUri',
    'QgsGeometryTypeCheckError',
    'QgsGmlFeatureClass',
    'QgsRasterProjector',
    'QgsTopologyPreservingSimplifier',
    'QgsMapToPixelSimplifier',
    'QgsNewVectorLayerDialog',
    'QgsRendererRegistry',
    'QgsVectorDataProvider',
    'QgsRasterNuller',
    'QgsMapMouseEvent',
    'QgsRasterBandStats',
    'QgsAuthManager',
    'QgsPointDisplacementRenderer',
    'QgsVectorFieldSymbolLayerWidget',
    'QgsPanelWidgetWrapper',
    'QgsCredentialsConsole',
    'QgsDoubleSpinBox',
    'QgsVectorLayerUndoCommandAddAttribute',
    'pal::LabelInfo',
    'pal::PalException::UnknownLayer',
    'QgsSmartGroupEditorDialog',
    'QgsMultiBandColorRenderer',
    'QgsAuthConfigEditor',
    'QgsSimpleLineSymbolLayer',
    'QgsMapTool',
    'QgsSlider',
    'QgsVectorLayerCache',
    'QgsDirectoryParamWidget',
    'QgsAttributeDialog',
    'QgsRasterPyramidsOptionsWidget',
    'QgsVectorFileWriter::SetOption',
    'QgsPkiConfigBundle',
    'QgsApplication',
    'pal::PalStat',
    'QgsLayerDefinition::DependencySorter',
    'QgsNewMemoryLayerDialog',
    'QgsLayerItem',
    'QgsNetworkDiskCache',
    'QgsVectorLayerUndoCommandDeleteFeature',
    'QWebPage',
    'pal::PalException',
    'QgsCheckBoxConfigDlg',
    'QgsCptCityColorRampItem',
    'QgsEnumerationWidgetWrapper',
    'QgsSingleCategoryDiagramRenderer',
    'QgsRelationReferenceWidget',
    'QgsRasterLayerSaveAsDialog',
    'QgsValueRelationWidgetFactory',
    'QgsCptCityCollectionItem',
    'QgsCheckboxWidgetWrapper',
    'QgsFields',
    'QgsVectorLayerUndoCommandAddFeature',
    'QgsGraphBuilder',
    'QgsRuggednessFilter',
    'QgsDialog',
    'QgsExpression',
    'QgsApplyDialog',
    'QgsGraduatedSymbolRenderer',
    'QgsColorWidgetWrapper',
    'QgsExpressionNodeCondition',
    'QgsGeometryGeneratorSymbolLayerWidget',
    'QgsSingleBandGrayRenderer',
    'QgsRasterTransparency',
    'QgsWebView',
    'QgsGeometryCheckFactoryT',
    'QgsMapToolEmitPoint',
    'QgsBlurWidget',
    'QgsLogger',
    'QgsPointLocator_VisitorArea',
    'QgsScaleComboBox',
    'QgsVectorFieldSymbolLayer',
    'QgsLineSymbolLayer',
    'QgsRelationWidgetWrapper',
    'QgsBrowserModel',
    'QgsSQLStatementCollectTableNames',
    'QgsOfflineEditing',
    'QgsMessageLog',
    'QgsDistanceArea',
    'QgsAttributeTableView',
    'QgsField',
    'pal::PalException::ValueNotInRange',
    'QgsExpressionNodeInOperator',
    'QgsColorRampShader',
    'QgsDataItem',
    'QgsGridFileWriter',
    'QgsCollapsibleGroupBox',
    'QgsValueMapWidgetFactory',
    'QgsEditorWidgetRegistry',
    'QgsSQLStatement::Node',
    'QgsRasterPyramid',
    'QgsGeometryDegeneratePolygonCheck',
    'QgsRendererAbstractMetadata',
    'QgsNewHttpConnection',
    'QWebSettings',
    'QgsExternalResourceWidgetFactory',
    'QgsMapLayerStyleManagerWidget',
    'QgsCptCitySelectionItem',
    'QgsEditFormConfig',
    'QgsAuthServersEditor',
    'QgsAttributeFormInterface',
    'QgsProjectFileTransform',
    'QgsColorEffectWidget',
    'QgsAttributeTableMapLayerAction',
    'pal::PalException::FeatureExists',
    'QgsAuthSslImportDialog',
    'QgsLegendStyle',
    'QgsRelation::FieldPair',
    'QgsServer',
    'Bezier3D',
    'QgsAuthImportCertDialog',
    'QgsIndexedFeature',
    'QgsGeometryDuplicateCheck',
    'QgsCptCityAllRampsItem',
    'QgsScaleRangeWidget',
    'QgsCoordinateTransform',
    'QgsMapCanvas',
    'QgsRendererWidget',
    'QgsPalettedRendererWidget',
    'QgsMapToolEdit',
    'QgsRasterShaderFunction',
    'QgsSimpleFillSymbolLayerWidget',
    'QgsSurface',
    'QgsAttributeTableFilterModel',
    'QgsMessageViewer',
    'QgsLinePatternFillSymbolLayerWidget',
    'QgsCacheIndexFeatureId',
    'QgsGeometryContainedCheck',
    'QgsPenJoinStyleComboBox',
    'QgsClipToMinMaxEnhancement',
    'QgsDataDefinedSizeDialog',
    'QgsSVGFillSymbolLayer',
    'QgsAuthImportIdentityDialog',
    'QgsUniqueValueWidgetFactory',
    'QgsNewGeoPackageLayerDialog',
    'QgsStyleExportImportDialog',
    'QgsRasterMatrix',
    'QgsGpsDetector',
    'QgsSQLStatement::NodeFunction',
    'QgsClipper',
    'QgsPointDisplacementRendererWidget',
    'QgsVectorLayerEditBuffer',
    'QgsUuidWidgetWrapper',
    'ParametricLine',
    'QgsSQLStatement::NodeBetweenOperator',
    'QgsSvgSelectorListModel',
    'QgsGradientFillSymbolLayerWidget',
    'pal::InternalException::NoLabelPosition',
    'QgsIdentifyMenu',
    'QgsRasterFillSymbolLayerWidget',
    'QgsOwsConnection',
    'QgsAttributeEditorContainer',
    'QgsProject',
    'QgsTotalCurvatureFilter',
    'QgsSimpleMarkerSymbolLayer',
    'QgsNetworkAccessManager',
    'QgsSQLStatement::NodeJoin',
    'QgsRasterMinMaxWidget',
    'QgsSymbolLevelItem',
    'QgsPluginLayerType',
    'QgsSearchWidgetWrapper',
    'QgsCachedFeatureIterator',
    'QgsFeatureIterator',
    'QgsSvgSelectorWidget',
    'QgsPenStyleComboBox',
    'QgsFeatureSelectionDlg',
    'QgsCptCityDataItem',
    'QgsAuthCertInfoDialog',
    'QgsRasterIdentifyResult',
    'QgsAttributeActionDialog',
    'QgsDiagramProperties',
    'QgsSourceFieldsProperties',
    'QgsJoinDialog',
    'QgsApplyDialog',
    'QgsMeshDatasetGroupTreeItemDelagate',
    'QgsAttributesFormProperties::DnDTreeItemData',
    'QgsMeshVariableStrokeWidthButton',
    'QgsMeshDatasetGroupTreeModel',
    'QgsMeshActiveDatasetGroupTreeView',
    'QgsMeshDatasetGroupListModel',
    'QgsMeshDatasetGroupSaveMenu',
    'QgsMeshDatasetGroupProxyModel',
    'QgsRendererMeshPropertiesWidget',
    'QgsMeshRendererVectorSettingsWidget',
    'QgsAttributeActionPropertiesDialog',
    'QgsAttributesFormProperties',
    'QgsMeshAvailableDatasetGroupTreeModel',
    'QgsVectorLayerSaveStyleDialog',
    'QgsVectorLayerProperties',
    'QgsMeshRendererMeshSettingsWidget',
    'QgsWmsDimensionDialog',
    'QgsSettingsEntryBase',
    'QgsMeshDatasetGroupTreeView',
    'QgsVectorLayerLegendWidget',
    'QgsMeshDatasetGroupTreeWidget',
    'QgsMeshRendererActiveDatasetWidget',
    'QgsAttributesFormInitCode',
    'QgsMeshRendererScalarSettingsWidget',
    'QgsMeshDatasetListModel',
    'QgsFieldCalculator',
    'QgsCPLErrorHandler',
    'EditBlockerDelegate',
    'QgsMeshRenderer3dAveragingWidget',
    'QgsAttributesDnDTree',
    'QgsMeshLayerProperties',
    'QgsMeshVariableStrokeWidthWidget',
    'QgsMeshStaticDatasetWidget'
]

ACCEPTABLE_MISSING_BRIEF = [
    'QgsDial',
    'QgsPluginManagerInterface',
    'QgsRangeWidgetFactory',
    'QgsLinearlyInterpolatedDiagramRenderer',
    'QgsTextDiagram',
    'QgsShapeburstFillSymbolLayer',
    'QgsCptCityArchive',
    'QgsValueRelationConfigDlg',
    'QgsGeometryMultipartCheck',
    'QgsArrowSymbolLayerWidget',
    'QgsCheckboxWidgetFactory',
    'QgsLabelCandidate',
    'QgsGeometrySliverPolygonCheck',
    'QgsMarkerLineSymbolLayerWidget',
    'QgsRelationReferenceFactory',
    'QgsGradientFillSymbolLayer',
    'QgsPointPatternFillSymbolLayer',
    'QgsSymbolLayer',
    'QgsLUDialog',
    'QgsFeatureModel',
    'QgsSimpleMarkerSymbolLayerWidget',
    'QgsMimeDataUtils',
    'QgsRuleBasedLabelProvider',
    'QgsRuntimeProfiler',
    'QgsRelation',
    'QgsGeometryPointCoveredByLineCheck',
    'QgsFontMarkerSymbolLayerWidget',
    'QgsDataDefinedWidthDialog',
    'QgsHistogramDiagram',
    'QgsSymbolLayerWidget',
    'QgsSpatialIndexCopyVisitor',
    'pal::CostCalculator',
    'QgsRendererRangeLabelFormat',
    'QgsGeometrySelfContactCheck',
    'QgsExpressionHighlighter',
    'QgsFillSymbolLayer',
    'QgsRendererRange',
    'QgsVectorFileWriter::HiddenOption',
    'QgsDrawSourceWidget',
    'QgsSvgSelectorDialog',
    'QgsFontMarkerSymbolLayer',
    'QgsStyleGroupSelectionDialog',
    'QgsGeometryLineLayerIntersectionCheck',
    'QgsFeatureRenderer',
    'QgsGeometryDangleCheck',
    'QgsRelationEditorWidget',
    'QgsGeometryPointInPolygonCheck',
    'QgsSymbolLayerUtils',
    'QgsCategorizedSymbolRenderer',
    'QgsRasterRendererWidget',
    'QgsValueMapConfigDlg',
    'QgsSublayersDialog',
    'QgsLabelPosition',
    'QgsSimpleLineSymbolLayerWidget',
    'QgsGeometrySelfIntersectionCheckError',
    'QgsRelationReferenceConfigDlg',
    'QgsFeatureListModel',
    'QgsMessageBarItem',
    'QgsCptCityBrowserModel',
    'QgsQtLocationConnection',
    'HalfEdge',
    'QgsBrushStyleComboBox',
    'QgsDartMeasurement',
    'QgsDateTimeEditFactory',
    'QgsPieDiagram',
    'QgsVectorLayerFeatureIterator',
    'QgsGeometryValidator',
    'QgsGeometrySelfIntersectionCheck',
    'QgsRangeConfigDlg',
    'QgsSymbolsListWidget',
    'QgsDummyConfigDlg',
    'QgsEnumerationWidgetFactory',
    'QgsGeometryDuplicateNodesCheck',
    'QgsVectorLayerEditPassthrough',
    'QgsGeometryTypeCheck',
    'QgsSVGFillSymbolLayerWidget',
    'QgsSingleSymbolRenderer',
    'QgsGeometryAreaCheck',
    'QgsHillshadeFilter',
    'QgsColorWidgetFactory',
    'QgsRendererPropertiesDialog',
    'QgsBrowserWatcher',
    'QgsDxfExport',
    'QgsTransactionGroup',
    'QgsStyle',
    'QgsSingleSymbolRendererWidget',
    'QgsGeometryDuplicateCheckError',
    'QgsSvgMarkerSymbolLayer',
    'QgsGeometry::Error',
    'QgsLayerPropertiesWidget',
    'QgsSymbolSelectorDialog',
    'QgsConstWkbPtr',
    'QgsErrorDialog',
    'QgsPalLayerSettings',
    'QgsRendererRulePropsWidget',
    'QgsTextEditConfigDlg',
    'QgsDateTimeEditConfig',
    'QgsGroupBoxCollapseButton',
    'QgsGeometryFollowBoundariesCheck',
    'QgsLongLongValidator',
    'QgsTextEditWidgetFactory',
    'QgsCentroidFillSymbolLayerWidget',
    'QgsGmlSchema',
    'QgsSingleBandGrayRendererWidget',
    'Qgs25DRenderer',
    'QgsVectorFileWriter::BoolOption',
    'QgsSimpleFillSymbolLayer',
    'QgsDxfPaintEngine',
    'QgsGlowWidget',
    'QgsGroupWmsDataDialog',
    'QgsMapToolCapture',
    'QgsRendererRasterPropertiesWidget',
    'QgsCptCityColorRamp',
    'QgsVectorLayerEditUtils',
    'QgsVectorLayerSelectionManager',
    'QgsTrackedVectorLayerTools',
    'QgsSmartGroupCondition',
    'pal::Sol',
    'QgsAttributeTypeLoadDialog',
    'QgsCentroidFillSymbolLayer',
    'QgsWkbPtr',
    'QgsFeatureSelectionModel',
    'QgsDataDefinedRotationDialog',
    'QgsGraduatedSymbolRendererWidget',
    'QgsTransformWidget',
    'QgsShapeburstFillSymbolLayerWidget',
    'QgsUniqueValuesConfigDlg',
    'QgsHeatmapRendererWidget',
    'QgsScaleUtils',
    'pal::PointSet',
    'QgsEllipseSymbolLayerWidget',
    'QgsFontUtils',
    'QgsRuleBasedLabeling',
    'QgsRasterCalcNode',
    'QgsPointPatternFillSymbolLayerWidget',
    'QgsVectorFileWriter::StringOption',
    'QgsUuidWidgetFactory',
    'QgsHiddenWidgetFactory',
    'QgsGeometryGeneratorSymbolLayer',
    'QgsGeometryAngleCheck',
    'QgsAttributeTableAction',
    'QgsAttributeForm',
    'QgsDatumTransformDialog',
    'pal::PriorityQueue',
    'Qgs25DRendererWidget',
    'QgsShadowEffectWidget',
    'QgsGeometryHoleCheck',
    'QgsVectorFileWriter::Option',
    'QgsRuleBasedRendererWidget',
    'QgsPenCapStyleComboBox',
    'QgsScopeLogger',
    'QgsGeometrySegmentLengthCheck',
    'QgsGeometryContainedCheckError',
    'QgsClassificationWidgetWrapper',
    'QgsMultiBandColorRendererWidget',
    'QgsFeatureListViewDelegate',
    'QgsManageConnectionsDialog',
    'QgsFieldValidator',
    'QgsPalLabeling',
    'QgsLocaleNumC',
    'QgsColorBrewerPalette',
    'pal::Util',
    'QgsVectorFileWriter::IntOption',
    'QgsGeometryLineIntersectionCheck',
    'QgsSymbolRenderContext',
    'QgsCategorizedSymbolRendererWidget',
    'pal::GeomFunction',
    'QgsRendererRulePropsDialog',
    'QgsSvgMarkerSymbolLayerWidget',
    'QgsExternalResourceConfigDlg',
    'QgsClassificationWidgetWrapperFactory',
    'QgsGeometryTypeCheckError',
    'QgsNewVectorLayerDialog',
    'QgsRuleBasedLabeling::Rule',
    'QgsVectorFieldSymbolLayerWidget',
    'QgsSmartGroupEditorDialog',
    'QgsSlider',
    'QgsAttributeDialog',
    'QgsVectorFileWriter::SetOption',
    'QgsNewMemoryLayerDialog',
    'QgsCheckBoxConfigDlg',
    'QgsEnumerationWidgetWrapper',
    'QgsRelationReferenceWidget',
    'QgsRasterLayerSaveAsDialog',
    'QgsValueRelationWidgetFactory',
    'QgsGraduatedSymbolRenderer',
    'QgsGeometryGeneratorSymbolLayerWidget',
    'QgsBlurWidget',
    'QgsLineSymbolLayer',
    'QgsRelationWidgetWrapper',
    'QgsOfflineEditing',
    'QgsValueMapWidgetFactory',
    'QgsGeometryDegeneratePolygonCheck',
    'QgsExternalResourceWidgetFactory',
    'QgsEditFormConfig',
    'QgsAttributeFormInterface',
    'QgsProjectFileTransform',
    'QgsColorEffectWidget',
    'QgsAttributeTableMapLayerAction',
    'QgsGeometryDuplicateCheck',
    'QgsPalettedRendererWidget',
    'QgsSimpleFillSymbolLayerWidget',
    'QgsSurface',
    'QgsAttributeTableFilterModel',
    'QgsLinePatternFillSymbolLayerWidget',
    'QgsCacheIndexFeatureId',
    'QgsGeometryContainedCheck',
    'QgsPenJoinStyleComboBox',
    'QgsDataDefinedSizeDialog',
    'QgsUniqueValueWidgetFactory',
    'QgsStyleExportImportDialog',
    'QgsRasterMatrix',
    'QgsPointDisplacementRendererWidget',
    'QgsVectorLayerEditBuffer',
    'QgsGradientFillSymbolLayerWidget',
    'QgsRasterFillSymbolLayerWidget',
    'QgsRasterMinMaxWidget',
    'QgsSymbolLevelItem',
    'QgsSvgSelectorWidget',
    'QgsPenStyleComboBox',
    'QgsFeatureSelectionDlg',
    'QgsAttributeActionDialog',
    'QgsDiagramProperties',
    'QgsSourceFieldsProperties',
    'QgsJoinDialog',
    'QgsAttributesFormProperties::DnDTreeItemData',
    'QgsMeshDatasetGroupListModel',
    'QgsMeshDatasetGroupSaveMenu',
    'QgsMeshDatasetGroupProxyModel',
    'QgsAttributeActionPropertiesDialog',
    'QgsAttributesFormProperties',
    'QgsMeshAvailableDatasetGroupTreeModel',
    'QgsVectorLayerProperties',
    'QgsSettingsEntryBase',
    'QgsMeshDatasetGroupTreeWidget',
    'QgsAttributesFormInitCode',
    'QgsMeshRendererScalarSettingsWidget',
    'QgsCPLErrorHandler',
    'EditBlockerDelegate'
]

if __name__ == '__main__':
    for k in sorted(list(ACCEPTABLE_MISSING_DOCS.keys())):
        print('    "{}": {},'.format(k, sorted(ACCEPTABLE_MISSING_DOCS[k])))
