/*
 * QSimpleViewer.h
 * $Id: QSimpleViewer.h,v 1.3 2001/11/15 16:54:51 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class inherits from QGLExaminerViewer 
//  Purpose     : Overloads the catch key method and emits an own key signal

    

#ifndef QMYVIEWER__H
#define QMYVIEWER__H


// Qt
///////
#include <qlabel.h>
#include <qslider.h>
#include <qpushbutton.h>
#include <qlayout.h>


// Own
////////
#include "QGLExaminerViewer.h"


// Defines
////////////
#define ZOOMSCALING  100.0    // used for translating slidervalue to real (double) value.



/** This is a simple example of using the QGLViewer by
  * extendending the class QGLExaminerViewer with new features.
  * It overloads the catch key method and emits an own key signal.
  * \par NOTE: You need not inherit from the class QGLExaminerViewer
  *            if it already fits your demands.
  *
  *  @author Michael Meissner
  */

class QSimpleViewer : public QGLExaminerViewer {
  Q_OBJECT

public:

  /** Constructor including a camera for the home position of the scene.
    * NOTE: The current camera will also be set to the given homecam. */
  QSimpleViewer(const CCamera &homecam, QWidget *parent=0, 
		    const char *name=0, const QGLWidget *shareWidget=0, 
		    WFlags f=0, bool viewertype=true,
		    const QGLFormat &format=QGLFormat::defaultFormat())
    : QGLExaminerViewer(homecam, parent, name, shareWidget, f, viewertype, format) {};

  /** Default Destructor. */
  virtual ~QSimpleViewer() {};

signals:

  /** This signal is emitted for key V. */
  void sigMyKey(int);


protected:

  /** Catches key "events" and emits a signal. */
  virtual void keyPressEvent(QKeyEvent *event);

private:
};

#endif // QMYVIEWER__H
