/*
 * CCameraKeyPathAttributes.cpp
 * $Id: CCameraKeyPathAttributes.cpp,v 1.2 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Alexander Buck, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

/** documentation stuff

  @author Alexander Buck, Michael Meissner
  
  @version 0.0 //see cvs docu
    
*/
    

// Own
///////////
#include "CCameraKeyPathAttributes.h"


// Function  : CCameraKeyPathAttributes
// Parameters: int nFrames, float rfTension, float rfCon, float rfBias
// Purpose   : default constructor.
// Comments  : See docu for details.
CCameraKeyPathAttributes::CCameraKeyPathAttributes(int nFrames, float rfTension, float rfCon, float rfBias)
/*************************************************************/
{
  m_nFrames = nFrames;
  m_rfTension = rfTension;
  m_rfContinuity = rfCon;
  m_rfBias = rfBias;
}


// Function  : ~CCameraKeyPathAttributes
// Parameters: 
// Purpose   : default destructor.
// Comments  : See docu for details.
CCameraKeyPathAttributes::~CCameraKeyPathAttributes() 
/*************************************************************/
{}


// Function  : setAttributes
// Parameters: int nFrames,float rfTension, float rfContinuity, float rf Bias
// Purpose   : Sets attributes to given attributes.
// Comments  : See docu for details.
void CCameraKeyPathAttributes::setAttributes(int nFrames,float rfTension, float rfContinuity, float rfBias)
/*************************************************************/
{
  m_nFrames = nFrames;
  m_rfTension = rfTension;
  m_rfContinuity = rfContinuity;
  m_rfBias = rfBias;
}


// Function  : setFrames
// Parameters: int nFrames
// Purpose   : Sets framerate to given framerate.
// Comments  : See docu for details.
void CCameraKeyPathAttributes::setFrames(int nFrames)
/*************************************************************/
{
  m_nFrames = nFrames;
}


// Function  : setTension
// Parameters: int rfTension
// Purpose   : Sets tension to given tension.
// Comments  : See docu for details.
void CCameraKeyPathAttributes::setTension(float rfTension)
/*************************************************************/
{
  m_rfTension = rfTension;
}


// Function  : setContinuity
// Parameters: int rfCon
// Purpose   : Sets continuity to given continuity.
// Comments  : See docu for details.
void CCameraKeyPathAttributes::setContinuity(float rfCon)
/*************************************************************/
{
  m_rfContinuity = rfCon;
}


// Function  : setBias
// Parameters: int rfBias
// Purpose   : Sets bias to given bias.
// Comments  : See docu for details.
void CCameraKeyPathAttributes::setBias(float rfBias)
/*************************************************************/
{
  m_rfBias = rfBias;
}
