/*
 * CV2D.cpp
 * $Id: CV2D.cpp,v 1.4 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich, Michael Meissner, Rainer Jaeger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

/** documentation stuff

  @author Markus Janich, Michael Meissner, Rainer Jaeger
    
  @version 0.0 //see cvs docu
          
*/



// Qt
///////

// System
///////////

// Own
///////////
#include "GeoGeneric.h"
#include "CV2D.h"
#include "CV3D.h"



double CV2D::epsilon = DOUBLE_EPSILON;	//EPS_CV2D;



// Function  : operator CV3D()
// Parameters: 
// Purpose   : Cast operator to convert CV2D vectors to CV3D vectors.
// Comments  :
CV2D::operator CV3D() const
/*********************************************************************/
{
   return CV3D(m_ard[0], m_ard[1], 0.0);
}



// Function  : operator==
// Parameters: const CV2D& v
// Purpose   :
// Comments  :
bool CV2D::operator == (const CV2D & v)
const
/*********************************************************************/
{
   return (fabs(m_ard[0] - v.m_ard[0]) <= epsilon &&
	   fabs(m_ard[1] - v.m_ard[1]) <= epsilon);
}
// Function  : operator!=// Parameters: const CV2D& v// Purpose   :// Comments  :
    bool CV2D::operator != (const CV2D & v) const
/*********************************************************************/
{
   return !(*this == v);
}



// Function  : operator+=
// Parameters: const CV2D& v
// Purpose   :
// Comments  :
CV2D & CV2D::operator += (const CV2D & v)
/*********************************************************************/
{
   m_ard[0] += v.m_ard[0];
   m_ard[1] += v.m_ard[1];

   return *this;
}



// Function  : operator-=
// Parameters: const CV2D& v
// Purpose   :
// Comments  :
CV2D & CV2D::operator -= (const CV2D & v)
/*********************************************************************/
{
   m_ard[0] -= v.m_ard[0];
   m_ard[1] -= v.m_ard[1];

   return *this;
}



// Function  : operator*=
// Parameters: double rdFactor
// Purpose   :
// Comments  :
CV2D & CV2D::operator *= (double rdFactor)
/*********************************************************************/
{
   m_ard[0] *= rdFactor;
   m_ard[1] *= rdFactor;

   return *this;
}



// Function  : operator/=
// Parameters: double rdFactor
// Purpose   :
// Comments  :
CV2D & CV2D::operator /= (double rdFactor)
/*********************************************************************/
{
   m_ard[0] /= rdFactor;
   m_ard[1] /= rdFactor;

   return *this;
}



// Function  : operator+
// Parameters: const CV2D& v
// Purpose   :
// Comments  :
CV2D CV2D::operator + (const CV2D & v)
const
/*********************************************************************/
{
   return CV2D(m_ard[0] + v.m_ard[0], m_ard[1] + v.m_ard[1]);
}
// Function  : operator-// Parameters: const CV2D& v// Purpose   :// Comments  :
    CV2D CV2D::operator - (const CV2D & v) const
/*********************************************************************/
{
   return CV2D(m_ard[0] - v.m_ard[0], m_ard[1] - v.m_ard[1]);
}



// Function  : operator-
// Parameters: void
// Purpose   :
// Comments  :
CV2D CV2D::operator - (void)
const
/*********************************************************************/
{
   return CV2D(-m_ard[0], -m_ard[1]);
}
// Function  : operator*// Parameters: const CV2D& v// Purpose   :// Comments  :
    double CV2D::operator * (const CV2D & v) const
/*********************************************************************/
{
   return m_ard[0] * v.m_ard[0] + m_ard[1] * v.m_ard[1];
}



// Function  : operator*
// Parameters: double rdFactor
// Purpose   :
// Comments  :
CV2D CV2D::operator * (double rdFactor)
const
/*********************************************************************/
{
   return CV2D(rdFactor * m_ard[0], rdFactor * m_ard[1]);
}
// Function  : operator*// Parameters: double rdFactor, const CV2D& v// Purpose   :// Comments  :
    CV2D operator *(double rdFactor, const CV2D & v)
/*********************************************************************/
{
   return CV2D(rdFactor * v.m_ard[0], rdFactor * v.m_ard[1]);
}



// Function  : operator/
// Parameters: double rdFactor
// Purpose   :
// Comments  :
CV2D CV2D::operator / (double rdFactor)
const
/*********************************************************************/
{
   return CV2D(m_ard[0] / rdFactor, m_ard[1] / rdFactor);
}
// Function  : print// Parameters: void// Purpose   :// Comments  :
    void CV2D::print(void) const
/*********************************************************************/
{
   cout << *this << endl;

   return;
}



// Function  : operator<<
// Parameters: ostream& s, const CV2D& v
// Purpose   :
// Comments  :
ostream & operator << (ostream & s, const CV2D & v)
/*********************************************************************/
{
   return s << "(" << v.m_ard[0] << "," << v.m_ard[1] << ")";
}



// Function  : operator>>
// Parameters: istream& s, CV2D& v
// Purpose   :
// Comments  :
istream & operator >> (istream & s, CV2D & v)
/*********************************************************************/
{
   char c;
   return s >> c >> v.m_ard[0] >> c >> v.m_ard[1] >> c;
}



// Function  : getAbsMinComponentCoord
// Parameters: void 
// Purpose   :
// Comments  :
int CV2D::getAbsMinComponentCoord() const
/*********************************************************************/
{
   double vx = fabs(m_ard[0]), vy = fabs(m_ard[1]);

   return (vx < vy) ? 0 : 1;
}



// Function  : getAbsMaxComponentCoord
// Parameters: void 
// Purpose   :
// Comments  :
int CV2D::getAbsMaxComponentCoord() const
/*********************************************************************/
{
   double vx = fabs(m_ard[0]), vy = fabs(m_ard[1]);

   return (vx > vy) ? 0 : 1;
}



// Function  : getMinComponentCoord
// Parameters: void 
// Purpose   :
// Comments  :
int CV2D::getMinComponentCoord() const
/*********************************************************************/
{
   double vx = m_ard[0], vy = m_ard[1];

   return (vx < vy) ? 0 : 1;
}



// Function  : getMaxComponentCoord
// Parameters: void 
// Purpose   :
// Comments  :
int CV2D::getMaxComponentCoord() const
/*********************************************************************/
{
   double vx = m_ard[0], vy = m_ard[1];

   return (vx > vy) ? 0 : 1;
}


#if 0
// Function  : getNorm
// Parameters: void 
// Purpose   :
// Comments  :
double CV2D::getNorm(void) const
/*********************************************************************/
{
   return sqrt(m_ard[0] * m_ard[0] + m_ard[1] * m_ard[1]);
}
#endif


// Function  : getNormalized
// Parameters: void
// Purpose   :
// Comments  :
CV2D CV2D::getNormalized(void) const
/*********************************************************************/
{
   double norm = getNorm();

   return CV2D(m_ard[0] / norm, m_ard[1] / norm);
}



// Function  : normalize
// Parameters: void
// Purpose   :
// Comments  :
void CV2D::normalize(void)
/*********************************************************************/
{
   double norm = getNorm();
   m_ard[0] /= norm;
   m_ard[1] /= norm;
}
