/*
 * QSceneTreeNode.cpp
 * $Id: QSceneTreeNode.cpp,v 1.5 2001/11/15 16:54:53 guenth Exp $
 *
 * Copyright (C) 2001 Richard Guenther
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

// Own
////////
#include "QSceneTreeNode.h"




QSceneTreeNode::~QSceneTreeNode()
/**********************************************************/
{
   if (m_pTransformation)
      delete m_pTransformation;
}



void QSceneTreeNode::resetTransformation()
/**********************************************************/
{
   if (m_pTransformation)
      delete m_pTransformation;
   m_pTransformation = NULL;
}



void QSceneTreeNode::applyTransformation(const CMat4D & mat)
/**********************************************************/
{
   if (!m_pTransformation)
      m_pTransformation = new CMat4D(mat);
   else
      (*m_pTransformation) *= mat;
}



CBoundingBox3D QSceneTreeNode::getBoundingBox() const
/**********************************************************/
{
   CBoundingBox3D bb;

   const CList < CTreeNode > &children = getChildrenList();
   CListContainer < QSceneTreeNode > *pContainer;
   pContainer = (CListContainer < QSceneTreeNode > *)children.getLast();
   while (pContainer) {
      QSceneTreeNode *pNode = pContainer->getObject();

      CBoundingBox3D NodeBB = pNode->getBoundingBox();
      const CMat4D *pTransformation = pNode->getTransformation();
      if (pTransformation) {
	 bb +=
	     CBoundingBox3D((*pTransformation) *
			    (CP4D) NodeBB.getLowerLeft(),
			    (*pTransformation) *
			    (CP4D) NodeBB.getUpperRight());
      } else {
	 bb += NodeBB;
      }
      pContainer = pContainer->getNext();
   }

   return bb;
}
