/*
 * CSceneTreeRenderer.h
 * $Id: CSceneTreeRenderer.h,v 1.3 2001/11/15 16:54:51 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description :  Definition of an example renderer drawing a cube
//                 in wire frame and some spheres using a scene tree.
//                 It also catches a key signal as shown in the simple
//                 example.


#ifndef CRENDERER__H
#define CRENDERER__H
    
    
// Own
////////
#include "QSceneTreeViewer.h"
#include "QSceneTreeNode.h"
#include "QSceneTreeRenderer.h"
#include "STQGLExampleObjects.h"


// Qt
///////
#include <qevent.h>
#include <qmainwindow.h>
#include <qslider.h>
#include <qgl.h>


// System
///////////
#include <math.h>



/** Definition of an example renderer drawing a cube
  * in wire frame and some spheres using a scene tree.
  * The objects it uses are defined in the file
  * 'STQGLExampleObjects.h'.
  * It also catches a key signal as shown in the simple
  * example.
  *
  * @author Michael Meissner
  */
    
class CSceneTreeRenderer : public QSceneTreeRenderer {
  Q_OBJECT

  //****** All methods ******

public:
  /** Default constructor. */
  CSceneTreeRenderer(QGLViewer*);
  /** Destructor. */
  ~CSceneTreeRenderer();

  /** Returns a pointer to the used viewer. */
  QGLViewer* getViewer(void) { return m_pViewer; };


  // **** All the slots *****
private slots:

  /** Overloads the slot for GL resize. */
  virtual void sltResizeGL(int w, int h);

  /** Manages the press events in selection mode. */
  virtual void sltManageSelection(QMouseEvent *pqEvent);

  /** Manages the move events in selection mode. */
  virtual void sltManageMove(QMouseEvent *pqEvent);

  /** New slot which catches any key signal emitted by the viewer. */
  void sltCatchKey(int);

  /** Slot to reset selection for example after
      the render mode has changed. */
  void sltResetSelection();

private:
  //****** All data ******

  QGLViewer *m_pViewer;

  CP3D m_cSphereCenter[12];            // saves centers of the spheres
  STQGLExampleSphere *m_apSphere[12];
};

#endif // CRENDERER__H 
