/*
 * QCameraKeyPathDropSite.h
 * $Id: 
 *
 * Copyright (C) 2001 Alexander Buck,Thomas Woerner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

#ifndef _QCAMERAKEYPATHDROPSITE_H
#define _QCAMERAKEYPATHDROPSITE_H


// Qt
///////
#include <qlabel.h>


// System
///////////


// Own
///////////
#include <CList.h>
#include "CCameraKeyPathPoint.h"



/** Dropsite for camerapaths.
  * @author Alexander Buck, Thomas Woerner, Markus Janich
  */
class QCameraKeyPathDropSite: public QLabel {

   Q_OBJECT

   public:

      //////////////////
      // CONSTRUCTORS //
      //////////////////

      /** default constructor. */
      QCameraKeyPathDropSite(QWidget *parent=0, const char * name = 0);

      /** default destructor. */
      ~QCameraKeyPathDropSite() { }

      /** Set member CCameraKeyPath to given CCameraKeyPath. */
      void setCameraPath(CList<CCameraKeyPathPoint> *pCamerapath) { m_pCList = pCamerapath; };

   signals:

      /////////////
      // SIGNALS //
      /////////////

      /** Is emitted when a CCameraKeyPath is dropped. */
      void sigCameraKeyPathDropped(const CList<CCameraKeyPathPoint> &list);

   protected:
      ///////////////////////
      // PROTECTED METHODS //
      ///////////////////////

      /** To handle Drag 'n Drop. */
      void dragEnterEvent(QDragEnterEvent *pqEvent);

      /** To handle Drag 'n Drop. */
      void dragLeaveEvent(QDragLeaveEvent *pqEvent);

      /** To handle Drag 'n Drop. */
      void dropEvent(QDropEvent *pqEvent);
    
      /** To handle Drag 'n Drop. */
      void mousePressEvent(QMouseEvent *pqEvent);

      /** To handle Drag 'n Drop. */
      void mouseReleaseEvent(QMouseEvent *pqEvent);

   private:
      /////////////////////
      // PRIVATE MEMBERS //
      /////////////////////

      /** Current camerapath. */
      CList<CCameraKeyPathPoint> *m_pCList;
};


#endif // _QCAMERAKEYPATHDROPSITE_H
