/*
 * QCameraPathPlayer.h
 * $Id: 
 *
 * Copyright (C) 2001 Thomas Woerner, Michael Meissner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */



#ifndef __QCAMERAPATHPLAYER_H
#define __QCAMERAPATHPLAYER_H


// Qt
///////
#include <qdialog.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qslider.h>
#include <qtimer.h>

// QGLViewer
//////////////
#include <QGLViewer.h>

// Own
////////
#include "QCameraPathDrag.h"
#include "QCameraPathDropSite.h"



/** This class provides a GUI tool for playing
  * camera paths just like using your DVD player.
  *
  * @author Thomas Woerner, Michael Meissner, Markus Janich
  *
  * [tw] 2001/04/29 initial version
  */
class QCameraPathPlayer : public QDialog
{
   Q_OBJECT
    
   public:
      ////////////////////
      // PUBLIC METHODS //
      ////////////////////
    
      QCameraPathPlayer(QGLViewer *pViewer,
			QWidget* parent=NULL, const char* name=NULL, 
                        bool modal=FALSE, WFlags fl=0);
      ~QCameraPathPlayer() { }

      /** Set the slider value. */
      void setSlider(int i)
           { m_pFrameSlider->setValue(i); }; 

      /** Returns the interpolated camera path.
	* \par NOTE: The list returned is a full duplicate.
	*            So if you free the list make a *clear(1)-call first ! */ 
      CList<CCamera> &getCameraPath() {
	return *m_CameraList.getFullDuplicate();
      };
      
   signals:
      /////////////
      // SIGNALS //
      /////////////

      /* Handles redraw of the scene. */
      void sigRedraw();

      /** This signal is emitted whenever the current
        * position has changed. The string with the
	* current position and the number of all frames
        * is passed with the parameter. */
      void sigPositionChanged(const QString &qNewPosition);

      /** This signal is emitted if the animation has been stopped. */
      void sigAnimationStopped();

      /** This signal is emitted if the animation has been started. */
      void sigAnimationStarted();


   public slots:
      //////////////////
      // PUBLIC SLOTS //
      //////////////////

      void sltLoad();
      void sltStop();
      void sltPlayPause();
      void sltBegin();
      void sltBwd();
      void sltFwd();
      void sltEnd();
      void sltSliderChanged(int);
      void sltFpsChanged(int);
      void sltTimer();

      /** Enables looping if 'fFlag' is true and disables
        * it if 'fFlag' is false. */
      void sltEnableLooping(bool fFlag) {
         m_pLoopButton->setOn(fFlag);
      };

      /** Sets the Camerapath to play. */
      void sltSetCameraPath(const CList<CCamera> &cCameraPath);


   protected:
      ///////////////////////
      // PROTECTED METHODS //
      ///////////////////////

      /** Method to handle drag 'n drop. */
      void dragEnterEvent(QDragEnterEvent*); 
 
      /** Method to handle drag 'n drop. */
      void dragLeaveEvent(QDragLeaveEvent*) { return; }

      /** Method to handle drag 'n drop. */
      void dropEvent(QDropEvent*);  
          
   private:
      /////////////////////
      // PRIVATE METHODS //
      /////////////////////
    
      QPushButton *m_pLoopButton;
      QPushButton *m_pPlayPauseButton;
      QLabel      *m_pStatusLabel;
      QComboBox   *m_pFpsCombo;
      QSlider     *m_pFrameSlider;
      QCameraPathDropSite *m_pDropSite;

      QTimer *m_pTimer;

      int m_nStatus;
      int m_nFps;

      QGLViewer *m_pViewer;

      CList<CCamera> m_CameraList;
};

#endif /* __QCAMERAPATHPLAYER_H */
