/*
 *   playertable.cpp
 */

#include "playertable.h"
#include "misc.h"

#include <qheader.h>
#include <qvariant.h>
#include <qwhatsthis.h>
#include <qevent.h>
#include <qlistview.h>


PlayerTable::PlayerTable(QWidget *parent, const char *name, bool /*modal*/, WFlags fl)
	: QListView(parent, name, fl)
{
	addColumn(QObject::tr("Stat", "PlayerTable: status [X!SQ]"));
	addColumn(QObject::tr("Name", "PlayerTable: player's name"));
	addColumn(QObject::tr("Rk", "PlayerTable: rank"));
	addColumn(QObject::tr("pl", "PlayerTable: playing in game"));
	addColumn(QObject::tr("ob", "PlayerTable: observing game"));
	addColumn(QObject::tr("Idle", "PlayerTable: idle time"));
	addColumn("X");
	setColumnAlignment(3, AlignRight);
	setColumnAlignment(4, AlignRight);
	setColumnAlignment(5, AlignRight);
	setColumnAlignment(6, AlignRight);
	setProperty( "focusPolicy", (int)QListView::NoFocus );
	setProperty( "resizePolicy", (int)QListView::AutoOneFit );

	// set sorting order for players by rank
	setSorting(2);
	setAllColumnsShowFocus(true);
}

/*
 *   PlayerTableItem
 */

PlayerTableItem::PlayerTableItem(PlayerTable *parent, const char* name)
	: QListViewItem(parent, name)  
{
;
}

PlayerTableItem::PlayerTableItem(PlayerTableItem *parent, const char* name)
	: QListViewItem(parent, name)  
{
;
}

PlayerTableItem::PlayerTableItem(PlayerTable *parent, QString label1, QString label2,
                QString label3, QString label4, QString label5,
                QString label6, QString label7, QString label8,
				QString label9, QString label10, QString label11, QString label12, QString label13)
	: QListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8)
{
	open = label1.contains('X') == 0;
	if (label7)
	{
		watched = label7[0] == 'W';
		its_me = label7[0] == 'M';
		exclude = label7[0] == 'X';
	}
	else
	{
		watched = false;
		its_me = false;
		exclude = false;
	}
	seeking = false;
	
	// QListViewItem only supports up to 8 labels, check for the rest
	if (label9)
	{
		setText(8, label9);
		if (label10)
		{
			setText(9, label10);
			if (label11)
			{
				setText(10, label11);
				if (label12)
				{
					setText(11, label12);
					if (label13)
					{
						setText(12, label13);
					}
				}
			}
		}
	}
}

PlayerTableItem::~PlayerTableItem()
{
}

void PlayerTableItem::paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment )
{
	QColorGroup _cg( cg );
//	QColor c = _cg.text();

  //double i= itemPos()/height() ;

  if (itemPos() % (2*height()))                 
    _cg.setColor(QColorGroup::Base, cg.color(QColorGroup::Midlight));//QColor::QColor("AliceBlue")); 
  
	if (its_me)
		_cg.setColor(QColorGroup::Text, Qt::blue);
	else if (watched)
		_cg.setColor(QColorGroup::Text, Qt::darkGreen);
	else if (!open)
		_cg.setColor(QColorGroup::Text, Qt::gray);
	else if (exclude)
		_cg.setColor(QColorGroup::Text, Qt::red);
	else if (seeking)
		_cg.setColor(QColorGroup::Text, Qt::magenta);

	QListViewItem::paintCell(p, _cg, column, width, alignment);

//	_cg.setColor(QColorGroup::Text, c);
}

void PlayerTableItem::ownRepaint()
{
	open = text(0).contains('X') == 0;
	if (text(6))
	{
		watched = text(6).at(0) == 'W';
		its_me = text(6).at(0) == 'M';
		exclude = text(6).at(0) == 'X';
	}
	else
	{
		watched = false;
		its_me = false;
		exclude = false;
	}
}

int PlayerTableItem::compare(  QListViewItem *p, int col, bool ascending ) const
{
	if (col == 2)
		return  text(12).compare( p->text(12) );

	return  QListViewItem::compare( p, col , ascending );
}


/* for correct sorting by rk and optionally txt
QString PlayerTableItem::key(int column, bool ascending) const
{
	switch (column)
	{
		// rank, however, considered to be most used...
		case 2:
			// return invisible column's text
			return text(12);

			// correct message - but too slow
			//return rkToKey(text(2)) + text(1).lower();
			break;

		// status: sort by "!" and -> rank!
		case 0:
		{
			QString statStr;

			if (text(0).contains("!"))
				statStr = "0" + text(0);
			else
				statStr = "1" + text(0);

			return statStr + text(6);
			// correct message - but too slow
			// statStr + return rkToKey(text(2)) + text(1).lower();
		}
			break;

		// name; second name: for correct sorting when two names are identical but uses lower & upper letters
		case 1:
			return text(column).lower() + text(column);
			break;

		// play, observe, won, lost
		case 3:
		case 4:
		case 8:
		case 9:
			return text(column).stripWhiteSpace().rightJustify(3, '0');
			break;

		// idle
		case 5:
			return (text(5).contains("s") ? "A" : "B") + text(5).rightJustify(4, '0');

		// watch entry
		case 6:
			if (text(6).length() == 0)
				return ("Y" + text(12));
			else if (text(6) == "X")
				// excluded players at trailing
				return ("Z" + text(12));
			else
				return (text(6) + text(12));

		// ext. info, country, language
		case 7:
		case 10:
		case 11:
			// '{' == 'z' + 1, '@' = 'A' - 1
			// if no text -> ensures that text(12) is at top/bottom
			if (ascending)
				return text(column).simplifyWhiteSpace() + '{' + text(12);
			else
				return text(column).simplifyWhiteSpace() + '@' + text(12);

			break;

		default:
			return text(column);
			break;
	}
}


void PlayerTableItem::replace( )
{	
	bool ascending;
	int sortColumn = listView()->sortColumn();

	//don't sort if no sort column
	if (sortColumn== -1)
		return;
		
	QListViewItemIterator lv(this);
	
	// the current item has just been inserted. It should be at top of list
	// the list as it was before starts with the second item
	QListViewItem *lv_start = listView()->firstChild()->itemBelow();
	
	//if there was only 1 items in the list, there is no way to get the sorting order
	if (lv_start && lv_start->itemBelow())
		ascending=  (lv_start->itemBelow()->compare(lv_start->itemBelow()->itemBelow(), sortColumn, true) > 0);
	else 
		ascending = true;
		
	bool found = false;	
	for (QListViewItem *lvi; lvi = lv++.current(); (lvi ==0) || found )
	{
		
		if ((compare(lvi,sortColumn,ascending)*(ascending ? 1 : -1)) < 0) 
			found=true;
	}
	
	if (found) 
		if (lv--.current())
			moveItem(lv.current()); 
	
	if (!found)
		moveItem(listView()->lastItem());
		
}
*/
