/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#include "settings.h"

Settings::Settings( QWidget *parent ) : QDialog( parent )
{
//0.	INITIALISE POINTERS
	config  =  new Config();
//1.	SETUP THE GUI
	setupUi( this );
//2.	CONNECTIONS
	makeConnections();
//3.	SHOW SETTINGS
	showSettings();
}
Settings::~Settings()
{
	delete config;
}
//FUNCTIONS
//no-gui
void Settings::makeConnections()
{
	connect( listWidget, SIGNAL( currentRowChanged( int ) ), stackedWidget, SLOT( setCurrentIndex( int ) ) );

	connect( pushButton_pickColor, SIGNAL( pressed() ), this, SLOT( pushButton_color() ) );

	connect( pushButton_restoredefault_1, SIGNAL( pressed() ), this, SLOT( menulst_restoredefault() ) );
	connect( pushButton_restoredefault_2, SIGNAL( pressed() ), this, SLOT( devicemap_restoredefault() ) );
	connect( pushButton_restoredefault_3, SIGNAL( pressed() ), this, SLOT( mtab_restoredefault() ) );

	connect( pushButton_browse_menulst, SIGNAL( pressed() ), this, SLOT( browse_menulst() ) );
	connect( pushButton_browse_devicemap, SIGNAL( pressed() ), this, SLOT( browse_devicemap() ) );
	connect( pushButton_browse_mtab, SIGNAL( pressed() ), this, SLOT( browse_mtab() ) );

	connect( pushButton_browse_language, SIGNAL( pressed() ), this, SLOT( browse_language() ) );

	connect( pushButton_contexthelp, SIGNAL( pressed() ), this, SLOT( contextHelp() ) );
	connect( pushButton_OK, SIGNAL( pressed() ), this, SLOT( OK() ) );
	connect( pushButton_cancel, SIGNAL( pressed() ), this, SLOT( close() ) );
}
//gui
void Settings::showSettings()
{
//GENERAL
	//general
	checkBox_menu->setChecked( config->settings.menu );
	comboBox_completion->setCurrentIndex( config->settings.completion );
	checkBox_autobackup->setChecked( config->settings.autobackup );
	//color
	QColor color( config->settings.default_color );
	QPixmap pixmap( 20, 20 );
	pixmap.fill( color );

	pushButton_pickColor->setIcon( QIcon( pixmap ) );
	pushButton_pickColor->setText( color.name() );
//PATHS
	//menulst
	lineEdit_menulst->setText( config->settings.menulst );
	//devicemap
	lineEdit_devicemap->setText( config->settings.devicemap );
	//mtab
	lineEdit_mtab->setText( config->settings.mtab );
//LANGUAGE
	lineEdit_language->setText( config->settings.language );

	listWidget->setCurrentRow( 0 );
}
//SLOTS
void Settings::pushButton_color()
{
	QColor color = QColorDialog::getColor( config->settings.default_color, this );
	if ( color.isValid() )
	{
		QPixmap pixmap( 20, 20 );
		pixmap.fill( color );
	
		pushButton_pickColor->setIcon( QIcon( pixmap ) );
		pushButton_pickColor->setText( color.name() );
		config->settings.default_color = color;
	}
}

void Settings::menulst_restoredefault()
{
	lineEdit_menulst->setText( MENU_LST_PATH );
}
void Settings::devicemap_restoredefault()
{
	lineEdit_devicemap->setText( DEVICE_MAP_PATH );
}
void Settings::mtab_restoredefault()
{
	lineEdit_mtab->setText( MTAB_PATH );
}

void Settings::browse_menulst()
{
	QString file = QFileDialog::getOpenFileName( this, tr( "Select a GRUB menu.lst file" ), lineEdit_menulst->text(), tr( "GRUB menu.lst file (*.*)" ) );
	if ( !file.isEmpty() )
		lineEdit_menulst->setText( file );
}
void Settings::browse_devicemap()
{
	QString file = QFileDialog::getOpenFileName( this, tr( "Select a GRUB device.map file" ), lineEdit_devicemap->text(), tr( "GRUB device.map file (*.*)" ) );
	if ( !file.isEmpty() )
		lineEdit_devicemap->setText( file );
}
void Settings::browse_mtab()
{
	QString file = QFileDialog::getOpenFileName( this, tr( "Select an mtab file" ), lineEdit_mtab->text(), tr( "mtab file (*.*)" ) );
	if ( !file.isEmpty() )
		lineEdit_mtab->setText( file );
}

void Settings::browse_language()
{
	if ( lineEdit_language->text().isEmpty() )
	{
		QString file = QFileDialog::getOpenFileName( this, tr( "Select a translation file" ), "/usr/share/apps/qgrubeditor/translations/", tr( "Translation file (*.qm)" ) );
		if ( !file.isEmpty() )
			lineEdit_language->setText( file );
	}
	else
	{
		QString file = QFileDialog::getOpenFileName( this, tr( "Select a translation file" ), lineEdit_language->text(), tr( "Translation file (*.qm)" ) );
		if ( !file.isEmpty() )
			lineEdit_language->setText( file );
	}
}

void Settings::contextHelp()
{
	QWhatsThis::enterWhatsThisMode();
}
void Settings::OK()
{
//GENERAL
	//general
	config->settings.menu = checkBox_menu->isChecked();
	config->settings.completion = comboBox_completion->currentIndex();
	config->settings.autobackup = checkBox_autobackup->isChecked();
//PATHS
	//menulst
	QFileInfo menulst( lineEdit_menulst->text() );
	( menulst.isFile() ? config->settings.menulst = lineEdit_menulst->text() : config->settings.menulst = MENU_LST_PATH );
	//devicemap
	QFileInfo devicemap( lineEdit_devicemap->text() );
	( devicemap.isFile() ? config->settings.devicemap = lineEdit_devicemap->text() : config->settings.devicemap = DEVICE_MAP_PATH );
	//mtab
	QFileInfo mtab( lineEdit_mtab->text() );
	( mtab.isFile() ? config->settings.mtab = lineEdit_mtab->text() : config->settings.mtab = MTAB_PATH );
//LANGUAGE
	QFileInfo language( lineEdit_language->text());
	( language.isFile() ? config->settings.language = lineEdit_language->text() : config->settings.language = QString() );

	config->write();
	close();
}
