/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#include "splashcreator.h"

SplashCreator::SplashCreator( QWidget* parent ) : QDialog( parent )
{
	setupUi( this );

	connect( pushButton_browse_image, SIGNAL( pressed() ), this, SLOT( browse_image() ) );
	connect( pushButton_browse_splash, SIGNAL( pressed() ), this, SLOT( browse_splash() ) );

	connect( pushButton_OK, SIGNAL( pressed() ), this, SLOT( accept() ) );
	connect( pushButton_cancel, SIGNAL( pressed() ), this, SLOT( reject() ) );
	connect( this, SIGNAL( accepted() ), this, SLOT( OK() ) );
	connect( this, SIGNAL( rejected() ), this, SLOT( cancel() ) );
}

void SplashCreator::browse_image()
{
	QString imageFile = QFileDialog::getOpenFileName( this, tr( "Select the image file" ), "", tr( "Images (*.jpeg *.jpg *.png *.xpm *.tif *.tiff *.gif)" ) );
	if ( !imageFile.isEmpty() )
	{
		lineEdit_image->setText( imageFile );
	}
}
void SplashCreator::browse_splash()
{
	QString splashFile = QFileDialog::getSaveFileName( this, tr( "Save GRUB splash image" ), "", tr( "GRUB splash images (*.xpm.gz)" ) );
	if ( !splashFile.isEmpty() )
	{
		lineEdit_splash->setText( splashFile );
	}
}

void SplashCreator::accept()
{
	if ( lineEdit_image->text().isEmpty() && lineEdit_splash->text().isEmpty() )
		QMessageBox::warning( this, tr( "Warning!" ), tr( "You have to fill in all fields!" ), QMessageBox::Ok );
	else
		done( 1 );
}
void SplashCreator::OK()
{
	QProcess convert;
	convert.start( "convert", QStringList() << lineEdit_image->text() << "-resize" << "640x480" << "-colors" << "14" << lineEdit_splash->text().remove( ".gz" ) );
	convert.waitForFinished();

	QProcess gzip;
	gzip.start( "gzip", QStringList() << "-f" << lineEdit_splash->text().remove( ".gz" ) );
	gzip.waitForFinished();

	QClipboard *clipboard = QApplication::clipboard();
	clipboard->setText( lineEdit_splash->text(), QClipboard::Selection );

	QMessageBox::information( this, "Success!", "Operation was successful. The GRUB splash image created is: " + lineEdit_splash->text(), QMessageBox::Ok );
}
void SplashCreator::cancel()
{
	QClipboard *clipboard = QApplication::clipboard();
	clipboard->setText( QString(), QClipboard::Selection );
}
