/*
 * Decompiled with CFR 0.152.
 */
package driftwood.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReclickListSelectionModel
implements ListSelectionModel {
    JList ourList;
    int selection = -1;
    boolean isAdjusting = false;
    List listeners = new ArrayList();

    public ReclickListSelectionModel(JList jList) {
        this.ourList = jList;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listeners.add(listSelectionListener);
    }

    public void addSelectionInterval(int n, int n2) {
        this.selection = n2;
        this.fireValueChanged();
    }

    public void clearSelection() {
        this.selection = -1;
        this.fireValueChanged();
    }

    public int getAnchorSelectionIndex() {
        return this.selection;
    }

    public int getLeadSelectionIndex() {
        return this.selection;
    }

    public int getMaxSelectionIndex() {
        return this.selection;
    }

    public int getMinSelectionIndex() {
        return this.selection;
    }

    public int getSelectionMode() {
        return 0;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void insertIndexInterval(int n, int n2, boolean bl) {
        System.err.println("index=" + n + "; length=" + n2 + "; before=" + bl);
    }

    public boolean isSelectedIndex(int n) {
        return n == this.selection;
    }

    public boolean isSelectionEmpty() {
        return -1 == this.selection;
    }

    public void removeIndexInterval(int n, int n2) {
        if (n <= this.selection && this.selection <= n2) {
            this.selection = -1;
            this.fireValueChanged();
        }
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listeners.remove(listSelectionListener);
    }

    public void removeSelectionInterval(int n, int n2) {
        if (n <= this.selection && this.selection <= n2) {
            this.selection = -1;
            this.fireValueChanged();
        }
    }

    public void setAnchorSelectionIndex(int n) {
        this.selection = n;
        this.fireValueChanged();
    }

    public void setLeadSelectionIndex(int n) {
        this.selection = n;
        this.fireValueChanged();
    }

    public void setSelectionInterval(int n, int n2) {
        this.selection = n2;
        this.fireValueChanged();
    }

    public void setSelectionMode(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Only SINGLE_SELECTION is allowed");
        }
    }

    public void setValueIsAdjusting(boolean bl) {
        this.isAdjusting = bl;
        this.fireValueChanged();
    }

    protected void fireValueChanged() {
        if (this.getValueIsAdjusting()) {
            return;
        }
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this.ourList, 0, this.ourList.getModel().getSize() - 1, this.isAdjusting);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListSelectionListener listSelectionListener = (ListSelectionListener)iterator.next();
            listSelectionListener.valueChanged(listSelectionEvent);
        }
    }
}

