/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.util.SoftLog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import king.KingMain;
import king.ToolServices;
import king.core.KIterator;
import king.core.KPoint;
import king.core.Kinemage;

public class PointFinder
implements WindowListener {
    static final String WHOLE_WORDS = "Whole words";
    static final String SUBSTRINGS = "Substrings";
    static final String SIMPLE_REGEX = "Globs: ?=1, *=any";
    static final String PERL_REGEX = "Perl5 regex";
    static final String[] SEARCH_TYPES = new String[]{"Whole words", "Substrings", "Globs: ?=1, *=any", "Perl5 regex"};
    KingMain kMain;
    JDialog dialog;
    JTextField searchField;
    JComboBox searchType;
    JCheckBox caseSensitive;
    JCheckBox centerOnFound;
    KIterator<KPoint> ptIter;
    Collection<Matcher> query;

    public PointFinder(KingMain kingMain) {
        this.kMain = kingMain;
        this.dialog = new JDialog(this.kMain.getTopWindow(), "Find point", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.addWindowListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        Container container = this.dialog.getContentPane();
        container.setLayout(gridBagLayout);
        ReflectiveAction reflectiveAction = new ReflectiveAction("Search", null, this, "onSearch");
        ReflectiveAction reflectiveAction2 = new ReflectiveAction("Close", null, this, "onClose");
        JButton jButton = new JButton(reflectiveAction2);
        reflectiveAction2.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        reflectiveAction2.bindWindow(jButton);
        this.searchField = new JTextField(20);
        this.searchField.addActionListener(reflectiveAction);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.searchField, gridBagConstraints);
        container.add(this.searchField);
        this.searchType = new JComboBox<String>(SEARCH_TYPES);
        this.searchType.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.searchType, gridBagConstraints);
        container.add(this.searchType);
        this.caseSensitive = new JCheckBox("Case sensitive", false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.caseSensitive, gridBagConstraints);
        container.add(this.caseSensitive);
        this.centerOnFound = new JCheckBox("Go to found point (re-center)", true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.centerOnFound, gridBagConstraints);
        container.add(this.centerOnFound);
        gridBagConstraints.anchor = 10;
        Box box = Box.createHorizontalBox();
        box.add(new JButton(reflectiveAction));
        box.add(Box.createRigidArea(new Dimension(16, 0)));
        box.add(jButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(box, gridBagConstraints);
        container.add(box);
        this.clearSearch();
    }

    public void show() {
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.kMain.getTopWindow());
        this.searchField.selectAll();
        this.searchField.requestFocus();
        this.dialog.setVisible(true);
    }

    public void onSearch(ActionEvent actionEvent) {
        int n;
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        Object object = this.searchType.getSelectedItem();
        ArrayList<Matcher> arrayList = new ArrayList<Matcher>();
        Matcher matcher = Pattern.compile("([\\\\\\^\\$\\.\\[\\]\\(\\)\\|\\*\\+\\?\\{\\}])").matcher("");
        Matcher matcher2 = Pattern.compile("([\\\\\\^\\$\\.\\[\\]\\(\\)\\|\\+\\{\\}])").matcher("");
        Matcher matcher3 = Pattern.compile("([\\*])").matcher("");
        int n2 = n = this.caseSensitive.isSelected() ? 0 : 2;
        if (object == WHOLE_WORDS) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.searchField.getText());
                while (stringTokenizer.hasMoreTokens()) {
                    matcher.reset(stringTokenizer.nextToken());
                    String string = matcher.replaceAll("\\$1");
                    Matcher matcher4 = Pattern.compile("(?:.*[ ,;:])?" + string + "(?:[ ,;:].*)?", n).matcher("");
                    arrayList.add(matcher4);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "The string you entered was not a valid regular expression.\n" + patternSyntaxException.getMessage(), "Regex error", 0);
            }
        } else if (object == SUBSTRINGS) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.searchField.getText());
                while (stringTokenizer.hasMoreTokens()) {
                    matcher.reset(stringTokenizer.nextToken());
                    String string = matcher.replaceAll("\\$1");
                    Matcher matcher5 = Pattern.compile(".*" + string + ".*", n).matcher("");
                    arrayList.add(matcher5);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "The string you entered was not a valid regular expression.\n" + patternSyntaxException.getMessage(), "Regex error", 0);
            }
        } else if (object == SIMPLE_REGEX) {
            try {
                String string = this.searchField.getText();
                matcher2.reset(string);
                string = matcher2.replaceAll("\\$1");
                matcher2.reset(string);
                string = matcher3.replaceAll(".$1");
                string = string.replace('?', '.');
                Matcher matcher6 = Pattern.compile(".*" + string + ".*", n).matcher("");
                arrayList.add(matcher6);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "The string you entered was not a valid regular expression.\n" + patternSyntaxException.getMessage(), "Regex error", 0);
            }
        } else if (object == PERL_REGEX) {
            try {
                Matcher matcher7 = Pattern.compile(".*" + this.searchField.getText() + ".*", n).matcher("");
                arrayList.add(matcher7);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "The string you entered was not a valid regular expression.\n" + patternSyntaxException.getMessage(), "Regex error", 0);
            }
        } else {
            return;
        }
        this.dialog.dispose();
        this.query = arrayList;
        this.ptIter = KIterator.visiblePoints(kinemage);
        this.findNext();
    }

    public void onClose(ActionEvent actionEvent) {
        this.dialog.dispose();
    }

    public void clearSearch() {
        this.ptIter = null;
        this.query = null;
    }

    public boolean findNext() {
        if (this.ptIter == null || this.query == null) {
            return false;
        }
        Matcher[] matcherArray = this.query.toArray(new Matcher[this.query.size()]);
        try {
            while (this.ptIter.hasNext()) {
                KPoint kPoint = (KPoint)this.ptIter.next();
                boolean bl = kPoint.isVisible() && !kPoint.isUnpickable();
                for (int i = 0; bl && i < matcherArray.length; ++i) {
                    Matcher matcher = matcherArray[i];
                    matcher.reset(kPoint.getName());
                    if (matcher.matches()) continue;
                    bl = false;
                }
                if (!bl) continue;
                if (this.kMain.getView() != null) {
                    ToolServices toolServices = this.kMain.getCanvas().getToolBox().services;
                    toolServices.pick(kPoint);
                    if (this.centerOnFound.isSelected()) {
                        toolServices.centerOnPoint(kPoint);
                    }
                }
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            SoftLog.err.println("Find Next failed due to concurrent modification of the kinemage.");
        }
        return false;
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.searchField.requestFocus();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

