/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.MenuList;
import driftwood.gui.ReflectiveAction;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import king.KMessage;
import king.KinCanvas;
import king.KingMain;
import king.core.Aspect;
import king.core.Engine2D;
import king.core.KPalette;
import king.core.KView;
import king.core.Kinemage;

public class UIDisplayMenu
implements KMessage.Subscriber {
    KingMain kMain;
    JMenu menu = null;
    JMenu aspectMenu = null;
    JCheckBoxMenuItem cbPersp = null;
    JCheckBoxMenuItem cbBigMarkers = null;
    JCheckBoxMenuItem cbBigLabels = null;
    JCheckBoxMenuItem cbThickness = null;
    JCheckBoxMenuItem cbThin = null;
    JCheckBoxMenuItem cbIntensity = null;
    JCheckBoxMenuItem cbBackground = null;
    JCheckBoxMenuItem cbMonochrome = null;
    JCheckBoxMenuItem cbColorByList = null;
    JCheckBoxMenuItem cbStereo = null;
    JCheckBoxMenuItem cbCrosseye = null;
    JCheckBoxMenuItem autoRockMenuItem = null;
    JCheckBoxMenuItem autoAnimMenuItem = null;
    Timer autoRockTimer = null;
    float rockStepSize = 0.0f;
    int rockStepCount = 0;
    int rockMaxSteps = 0;
    boolean rockRight = true;
    Timer autoAnimTimer = null;
    static final long SYNC_CHECKBOXES = 516L;

    public UIDisplayMenu(KingMain kingMain) {
        this.kMain = kingMain;
        int n = this.kMain.prefs.getInt("autoRockCycleTime") / this.kMain.prefs.getInt("autoRockCycleSteps");
        this.autoRockTimer = new Timer(n, new ReflectiveAction(null, null, this, "onDispAutoRockStep"));
        this.rockMaxSteps = this.kMain.prefs.getInt("autoRockCycleSteps") / 2;
        this.rockStepCount = this.rockMaxSteps / 2;
        this.rockStepSize = (float)Math.toRadians(2.0 * this.kMain.prefs.getDouble("autoRockDegrees") / (double)this.rockMaxSteps);
        this.autoAnimTimer = new Timer(this.kMain.prefs.getInt("autoAnimateDelay"), new ReflectiveAction(null, null, this, "onDispAutoAnimStep"));
        this.kMain.subscribe(this);
    }

    public void deliverMessage(KMessage kMessage) {
        if (kMessage.getSource() != this && kMessage.testProg(516L)) {
            this.syncCheckboxes();
        }
    }

    public JMenu getMenu() {
        if (this.menu != null) {
            return this.menu;
        }
        this.menu = new JMenu("Display");
        this.menu.setMnemonic(68);
        this.aspectMenu = new JMenu("Aspects");
        this.aspectMenu.setMnemonic(65);
        this.menu.add(this.aspectMenu);
        this.rebuildAspectsMenu();
        this.menu.addSeparator();
        this.cbPersp = new JCheckBoxMenuItem(new ReflectiveAction("Use perspective", null, this, "onDispPersp"));
        this.cbPersp.setMnemonic(85);
        this.cbPersp.setAccelerator(KeyStroke.getKeyStroke(80, 0));
        this.menu.add(this.cbPersp);
        this.cbStereo = new JCheckBoxMenuItem(new ReflectiveAction("Use stereo", null, this, "onDispStereo"));
        this.cbStereo.setMnemonic(83);
        this.cbStereo.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        this.menu.add(this.cbStereo);
        this.cbCrosseye = new JCheckBoxMenuItem(new ReflectiveAction("Crosseye stereo", null, this, "onDispCrosseye"));
        this.cbCrosseye.setMnemonic(67);
        this.cbCrosseye.setAccelerator(KeyStroke.getKeyStroke(67, 0));
        this.menu.add(this.cbCrosseye);
        this.menu.addSeparator();
        this.cbBigMarkers = new JCheckBoxMenuItem(new ReflectiveAction("Big markers", null, this, "onDispBigMarkers"));
        this.cbBigMarkers.setMnemonic(66);
        this.cbBigMarkers.setAccelerator(KeyStroke.getKeyStroke(81, 0));
        this.menu.add(this.cbBigMarkers);
        this.cbBigLabels = new JCheckBoxMenuItem(new ReflectiveAction("Big labels", null, this, "onDispBigLabels"));
        this.cbBigLabels.setMnemonic(71);
        this.cbBigLabels.setAccelerator(KeyStroke.getKeyStroke(87, 0));
        this.menu.add(this.cbBigLabels);
        this.cbThickness = new JCheckBoxMenuItem(new ReflectiveAction("Cue by thickness", null, this, "onDispThickness"));
        this.cbThickness.setMnemonic(84);
        this.cbThickness.setAccelerator(KeyStroke.getKeyStroke(84, 1));
        this.menu.add(this.cbThickness);
        this.cbThin = new JCheckBoxMenuItem(new ReflectiveAction("Thin lines", null, this, "onDispThin"));
        this.cbThin.setMnemonic(78);
        this.cbThin.setAccelerator(KeyStroke.getKeyStroke(84, 0));
        this.menu.add(this.cbThin);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Standard", new Integer(0));
        hashMap.put("Better", new Integer(1));
        hashMap.put("Best", new Integer(2));
        hashMap.put("OpenGL", new Integer(10));
        List<String> list = Arrays.asList("Standard", "Better", "Best", "OpenGL");
        String string = "Standard";
        if (this.kMain.getCanvas().renderQuality == 1) {
            string = "Better";
        } else if (this.kMain.getCanvas().renderQuality == 10) {
            string = "OpenGL";
        }
        JMenu jMenu = new DispQualityList(hashMap, list, string).getMenu();
        jMenu.setText("Rendering quality");
        this.menu.add(jMenu);
        this.menu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("Set contrast...", null, this, "onDispContrast"));
        jMenuItem.setMnemonic(79);
        this.menu.add(jMenuItem);
        this.cbIntensity = new JCheckBoxMenuItem(new ReflectiveAction("Cue by intensity", null, this, "onDispIntensity"));
        this.cbIntensity.setMnemonic(73);
        this.cbIntensity.setAccelerator(KeyStroke.getKeyStroke(89, 0));
        this.menu.add(this.cbIntensity);
        this.cbBackground = new JCheckBoxMenuItem(new ReflectiveAction("White background", null, this, "onDispBackground"));
        this.cbBackground.setMnemonic(87);
        this.cbBackground.setAccelerator(KeyStroke.getKeyStroke(71, 0));
        this.menu.add(this.cbBackground);
        this.cbMonochrome = new JCheckBoxMenuItem(new ReflectiveAction("Monochrome", null, this, "onDispMonochrome"));
        this.cbMonochrome.setMnemonic(77);
        this.menu.add(this.cbMonochrome);
        this.cbColorByList = new JCheckBoxMenuItem(new ReflectiveAction("Color by list", null, this, "onDispColorByList"));
        this.cbColorByList.setMnemonic(76);
        this.cbColorByList.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        this.menu.add(this.cbColorByList);
        this.menu.addSeparator();
        this.autoRockMenuItem = new JCheckBoxMenuItem(new ReflectiveAction("Auto-rock", null, this, "onDispAutoRockStartStop"));
        this.autoRockMenuItem.setMnemonic(82);
        this.autoRockMenuItem.setSelected(this.autoRockTimer.isRunning());
        this.autoRockMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        this.menu.add(this.autoRockMenuItem);
        this.autoAnimMenuItem = new JCheckBoxMenuItem(new ReflectiveAction("Auto-animate", null, this, "onDispAutoAnimStartStop"));
        this.autoAnimMenuItem.setSelected(this.autoAnimTimer.isRunning());
        this.menu.add(this.autoAnimMenuItem);
        this.syncCheckboxes();
        return this.menu;
    }

    void syncCheckboxes() {
        Object object;
        if (this.menu == null) {
            return;
        }
        KinCanvas kinCanvas = this.kMain.getCanvas();
        Engine2D engine2D = kinCanvas.getEngine();
        this.cbPersp.setSelected(engine2D.usePerspective);
        if (engine2D instanceof Engine2D) {
            object = engine2D;
            this.cbStereo.setSelected(((Engine2D)object).useStereo);
            this.cbCrosseye.setSelected(((Engine2D)object).stereoRotation < 0.0f);
        }
        this.cbBigMarkers.setSelected(engine2D.bigMarkers);
        this.cbBigLabels.setSelected(engine2D.bigLabels);
        this.cbThickness.setSelected(engine2D.cueThickness);
        this.cbThin.setSelected(engine2D.thinLines);
        this.cbIntensity.setSelected(engine2D.cueIntensity);
        this.cbBackground.setSelected(engine2D.whiteBackground);
        this.cbMonochrome.setSelected(engine2D.monochrome);
        this.cbColorByList.setSelected(engine2D.colorByList);
        object = this.kMain.getKinemage();
        if (object == null) {
            return;
        }
        this.cbPersp.setSelected(((Kinemage)object).atPerspective);
        this.cbThickness.setSelected(!((Kinemage)object).atOnewidth);
        this.cbThin.setSelected(((Kinemage)object).atThinline);
        this.cbBackground.setSelected(((Kinemage)object).atWhitebackground);
        this.cbColorByList.setSelected(((Kinemage)object).atListcolordominant);
    }

    public void rebuildAspectsMenu() {
        if (this.aspectMenu == null) {
            return;
        }
        this.aspectMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ReflectiveAction("Aspects off", null, this, "onDisplayAspectsOff"));
            jRadioButtonMenuItem.setMnemonic(79);
            jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(92, 0));
            buttonGroup.add(jRadioButtonMenuItem);
            this.aspectMenu.add(jRadioButtonMenuItem);
            this.aspectMenu.addSeparator();
            int n = 1;
            for (Aspect aspect : kinemage.getAspects()) {
                jRadioButtonMenuItem = new JRadioButtonMenuItem(new AspectAction(n++, aspect));
                buttonGroup.add(jRadioButtonMenuItem);
                this.aspectMenu.add(jRadioButtonMenuItem);
            }
            if (n > 1) {
                this.aspectMenu.addSeparator();
            }
            JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("Next aspect", null, this, "onDisplayAspectsNext"));
            jMenuItem.setMnemonic(78);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(93, 0));
            this.aspectMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(new ReflectiveAction("Previous aspect", null, this, "onDisplayAspectsPrevious"));
            jMenuItem.setMnemonic(80);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(91, 0));
            this.aspectMenu.add(jMenuItem);
        } else {
            JMenuItem jMenuItem = new JMenuItem("No aspects available");
            jMenuItem.setEnabled(false);
            this.aspectMenu.add(jMenuItem);
        }
    }

    public void onDisplayAspectsOff(ActionEvent actionEvent) {
        this.kMain.getCanvas().setCurrentAspect(null);
    }

    public void onDisplayAspectsNext(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        Aspect aspect = this.kMain.getCanvas().getCurrentAspect();
        List<Aspect> list = kinemage.getAspects();
        if (list.size() == 0) {
            this.kMain.getCanvas().setCurrentAspect(null);
        } else if (aspect == null) {
            this.kMain.getCanvas().setCurrentAspect(list.get(0));
        } else {
            int n = list.indexOf(aspect);
            n = n == list.size() - 1 ? 0 : ++n;
            this.kMain.getCanvas().setCurrentAspect(list.get(n));
        }
    }

    public void onDisplayAspectsPrevious(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        Aspect aspect = this.kMain.getCanvas().getCurrentAspect();
        List<Aspect> list = kinemage.getAspects();
        if (list.size() == 0) {
            this.kMain.getCanvas().setCurrentAspect(null);
        } else if (aspect == null) {
            this.kMain.getCanvas().setCurrentAspect(list.get(list.size() - 1));
        } else {
            int n = list.indexOf(aspect);
            n = n == 0 ? list.size() - 1 : --n;
            this.kMain.getCanvas().setCurrentAspect(list.get(n));
        }
    }

    public void onDispPersp(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.atPerspective = this.cbPersp.isSelected();
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispStereo(ActionEvent actionEvent) {
        if (this.kMain.getCanvas() != null) {
            Engine2D engine2D = this.kMain.getCanvas().getEngine();
            if (engine2D != null && engine2D instanceof Engine2D) {
                engine2D.useStereo = this.cbStereo.isSelected();
            }
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispCrosseye(ActionEvent actionEvent) {
        if (this.kMain.getCanvas() != null) {
            Engine2D engine2D = this.kMain.getCanvas().getEngine();
            if (engine2D != null && engine2D instanceof Engine2D) {
                Engine2D engine2D2 = engine2D;
                engine2D2.stereoRotation = this.cbCrosseye.isSelected() ^ engine2D2.stereoRotation < 0.0f ? -engine2D2.stereoRotation : engine2D2.stereoRotation;
            }
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispBigMarkers(ActionEvent actionEvent) {
        if (this.kMain.getCanvas() != null) {
            Engine2D engine2D = this.kMain.getCanvas().getEngine();
            if (engine2D != null) {
                engine2D.bigMarkers = this.cbBigMarkers.isSelected();
            }
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispBigLabels(ActionEvent actionEvent) {
        if (this.kMain.getCanvas() != null) {
            Engine2D engine2D = this.kMain.getCanvas().getEngine();
            if (engine2D != null) {
                engine2D.bigLabels = this.cbBigLabels.isSelected();
            }
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispThickness(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.atOnewidth = !this.cbThickness.isSelected();
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispThin(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.atThinline = this.cbThin.isSelected();
            if (this.cbThin.isSelected()) {
                kinemage.atOnewidth = true;
                this.cbThickness.setSelected(false);
            }
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispIntensity(ActionEvent actionEvent) {
        if (this.kMain.getCanvas() != null) {
            Engine2D engine2D = this.kMain.getCanvas().getEngine();
            if (engine2D != null) {
                engine2D.cueIntensity = this.cbIntensity.isSelected();
            }
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispBackground(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.atWhitebackground = this.cbBackground.isSelected();
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispMonochrome(ActionEvent actionEvent) {
        if (this.kMain.getCanvas() != null) {
            Engine2D engine2D = this.kMain.getCanvas().getEngine();
            if (engine2D != null) {
                boolean bl;
                engine2D.monochrome = bl = this.cbMonochrome.isSelected();
                if (bl) {
                    engine2D.whiteBackground = true;
                    this.cbBackground.setSelected(true);
                }
            }
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispColorByList(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.atListcolordominant = this.cbColorByList.isSelected();
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    public void onDispAutoRockStartStop(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        if (this.autoRockMenuItem.isSelected()) {
            this.rockStepCount = this.rockMaxSteps / 2;
            this.rockRight = true;
            this.autoRockTimer.start();
        } else {
            this.autoRockTimer.stop();
        }
    }

    public void onDispAutoRockStep(ActionEvent actionEvent) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        if (this.rockStepCount >= this.rockMaxSteps) {
            this.rockStepCount = 0;
            boolean bl = this.rockRight = !this.rockRight;
        }
        if (this.rockRight) {
            kView.rotateY((float)((double)(2.0f * this.rockStepSize) * Math.sin(Math.PI * (double)this.rockStepCount / (double)this.rockMaxSteps)));
        } else {
            kView.rotateY((float)((double)(2.0f * -this.rockStepSize) * Math.sin(Math.PI * (double)this.rockStepCount / (double)this.rockMaxSteps)));
        }
        ++this.rockStepCount;
    }

    public void onDispAutoAnimStartStop(ActionEvent actionEvent) {
        if (this.autoAnimMenuItem.isSelected()) {
            String string = JOptionPane.showInputDialog(this.kMain.getTopWindow(), "Rate of animation? (milliseconds)", Integer.toString(this.autoAnimTimer.getDelay()));
            try {
                this.autoAnimTimer.setDelay(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.autoAnimTimer.start();
        } else {
            this.autoAnimTimer.stop();
        }
    }

    public void onDispAutoAnimStep(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        kinemage.animate(1);
    }

    public void onDispContrast(ActionEvent actionEvent) {
        JSlider jSlider = new JSlider(0, 100, 50);
        int n = JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), jSlider, "Set display contrast", 2, -1);
        if (n == 0) {
            int n2 = jSlider.getValue() - 50;
            KPalette.setContrast(1.0 + (double)n2 / 50.0);
            this.kMain.publish(new KMessage(this, 512L));
        }
    }

    class AspectAction
    extends AbstractAction {
        Aspect aspect;

        public AspectAction(int n, Aspect aspect) {
            super(n + " " + aspect.getName());
            this.aspect = aspect;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UIDisplayMenu.this.kMain.getCanvas().setCurrentAspect(this.aspect);
        }
    }

    class DispQualityList
    extends MenuList {
        Map map;

        public DispQualityList(Map map, Collection collection, String string) {
            super(collection, string);
            this.map = map;
        }

        protected void itemSelected(Object object) {
            if (object == null) {
                return;
            }
            KinCanvas kinCanvas = UIDisplayMenu.this.kMain.getCanvas();
            kinCanvas.setQuality((Integer)this.map.get(object));
            kinCanvas.repaint();
        }
    }
}

