/*
 * Decompiled with CFR 0.152.
 */
package king.io;

import driftwood.util.SoftLog;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import king.core.AGE;
import king.core.BondRot;
import king.core.KGroup;
import king.core.KIterator;
import king.core.KList;
import king.core.KPaint;
import king.core.KPoint;
import king.core.KView;
import king.core.Kinemage;
import king.core.MasterGroup;
import king.io.KinfileTokenizer;
import king.points.AbstractPoint;
import king.points.ArrowPoint;
import king.points.BallPoint;
import king.points.DotPoint;
import king.points.LabelPoint;
import king.points.MarkerPoint;
import king.points.RingPoint;
import king.points.SpherePoint;
import king.points.TrianglePoint;
import king.points.VectorPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinfileParser {
    public static final String DEFAULT_KINEMAGE_NAME = "Kinemage #";
    static final String DEFAULT_GROUP_NAME = "";
    static final String IMPLIED_GROUP_NAME = "(implied)";
    static final int MAX_ERRORS_REPORTED = 30;
    LineNumberReader input = null;
    KinfileTokenizer token = null;
    Kinemage kinemage = null;
    KGroup group = null;
    KGroup subgroup = null;
    KList list = null;
    Collection<Kinemage> kinemages = new ArrayList<Kinemage>();
    StringBuffer atText = new StringBuffer();
    Map<String, KView> viewMap = null;
    Map<String, KGroup> groupsByName = null;
    Map<String, KGroup> subgroupsByName = null;
    Map<String, KList> listsByName = null;
    TreeMap<Integer, BondRot> bondRots = null;
    ArrayList<BondRot> closedBondRots = null;
    int nonIntCount = 1;
    int groupDimension = 3;
    int subgroupDimension = 3;

    public void parse(LineNumberReader lineNumberReader) throws IOException {
        this.input = lineNumberReader;
        this.token = new KinfileTokenizer(this.input);
        this.keywordLoop();
        for (Kinemage kinemage : this.kinemages) {
            kinemage.initAll();
        }
    }

    public Collection<Kinemage> getKinemages() {
        return Collections.unmodifiableCollection(this.kinemages);
    }

    public String getText() {
        return this.atText.toString();
    }

    void error(String string) {
        SoftLog.err.println("[line " + (this.input.getLineNumber() + 1) + "] " + string);
    }

    public long getCharsRead() {
        if (this.token != null) {
            return this.token.getCharsRead();
        }
        return 0L;
    }

    void keywordLoop() throws IOException {
        while (!this.token.isEOF()) {
            String string = this.token.getString().toLowerCase();
            if (!this.token.isKeyword()) {
                this.error("Dangling token '" + string + "' outside any keywords");
                this.token.advanceToKeyword();
                continue;
            }
            if (string.equals("@text")) {
                this.doText();
                continue;
            }
            if (string.equals("@title")) {
                this.doTitle();
                continue;
            }
            if (string.equals("@copyright")) {
                this.doCopyright();
                continue;
            }
            if (string.equals("@caption")) {
                this.doCaption();
                continue;
            }
            if (string.equals("@mage")) {
                this.token.advanceToKeyword();
                continue;
            }
            if (string.equals("@prekin")) {
                this.token.advanceToKeyword();
                continue;
            }
            if (string.equals("@pdbfile")) {
                this.doPdbFile();
                continue;
            }
            if (string.equals("@command")) {
                this.doCommand();
                continue;
            }
            if (string.equals("@dimensions")) {
                this.doDimensions();
                continue;
            }
            if (string.equals("@dimension")) {
                this.doDimensions();
                continue;
            }
            if (string.equals("@dimminmax")) {
                this.doDimMinMax();
                continue;
            }
            if (string.equals("@dimscale")) {
                this.doDimScale();
                continue;
            }
            if (string.equals("@dimoffset")) {
                this.doDimOffset();
                continue;
            }
            if (string.endsWith("viewid")) {
                this.doViewID();
                continue;
            }
            if (string.endsWith("zoom")) {
                this.doZoom();
                continue;
            }
            if (string.endsWith("span")) {
                this.doSpan();
                continue;
            }
            if (string.endsWith("zslab")) {
                this.doClip();
                continue;
            }
            if (string.endsWith("zclip")) {
                this.doClip();
                continue;
            }
            if (string.endsWith("ztran")) {
                this.token.advanceToKeyword();
                continue;
            }
            if (string.endsWith("center")) {
                this.doCenter();
                continue;
            }
            if (string.endsWith("matrix")) {
                this.doMatrix();
                continue;
            }
            if (string.endsWith("axischoice")) {
                this.doAxisChoice();
                continue;
            }
            if (string.equals("@whitebackground")) {
                this.doWhiteBackground();
                continue;
            }
            if (string.equals("@whiteback")) {
                this.doWhiteBackground();
                continue;
            }
            if (string.equals("@whitebkg")) {
                this.doWhiteBackground();
                continue;
            }
            if (string.equals("@onewidth")) {
                this.doOnewidth();
                continue;
            }
            if (string.equals("@thinline")) {
                this.doThinline();
                continue;
            }
            if (string.equals("@perspective")) {
                this.doPerspective();
                continue;
            }
            if (string.equals("@flat")) {
                this.doFlat();
                continue;
            }
            if (string.equals("@flatland")) {
                this.doFlat();
                continue;
            }
            if (string.equals("@xytranslation")) {
                this.doFlat();
                continue;
            }
            if (string.equals("@listcolordominant")) {
                this.doListColorDominant();
                continue;
            }
            if (string.equals("@listcolordom")) {
                this.doListColorDominant();
                continue;
            }
            if (string.equals("@lens")) {
                this.doLens();
                continue;
            }
            if (string.endsWith("aspect")) {
                this.doAspect();
                continue;
            }
            if (string.equals("@master")) {
                this.doMaster();
                continue;
            }
            if (string.equals("@pointmaster")) {
                this.doPointmaster();
                continue;
            }
            if (string.equals("@colorset")) {
                this.doColorset();
                continue;
            }
            if (string.equals("@hsvcolor")) {
                this.doHsvColor();
                continue;
            }
            if (string.equals("@hsvcolour")) {
                this.doHsvColor();
                continue;
            }
            if (string.equals("@kinemage")) {
                this.doKinemage();
                continue;
            }
            if (string.equals("@group")) {
                this.doGroup();
                continue;
            }
            if (string.equals("@subgroup")) {
                this.doSubgroup();
                continue;
            }
            if (string.equals("@set")) {
                this.doSubgroup();
                continue;
            }
            if (string.equals("@vectorlist")) {
                this.doList("vector");
                continue;
            }
            if (string.equals("@vector")) {
                this.doList("vector");
                continue;
            }
            if (string.equals("@labellist")) {
                this.doList("label");
                continue;
            }
            if (string.equals("@label")) {
                this.doList("label");
                continue;
            }
            if (string.equals("@dotlist")) {
                this.doList("dot");
                continue;
            }
            if (string.equals("@dot")) {
                this.doList("dot");
                continue;
            }
            if (string.equals("@ringlist")) {
                this.doList("ring");
                continue;
            }
            if (string.equals("@ring")) {
                this.doList("ring");
                continue;
            }
            if (string.equals("@balllist")) {
                this.doList("ball");
                continue;
            }
            if (string.equals("@ball")) {
                this.doList("ball");
                continue;
            }
            if (string.equals("@spherelist")) {
                this.doList("sphere");
                continue;
            }
            if (string.equals("@sphere")) {
                this.doList("sphere");
                continue;
            }
            if (string.equals("@trianglelist")) {
                this.doList("triangle");
                continue;
            }
            if (string.equals("@triangle")) {
                this.doList("triangle");
                continue;
            }
            if (string.equals("@ribbonlist")) {
                this.doList("ribbon");
                continue;
            }
            if (string.equals("@ribbon")) {
                this.doList("ribbon");
                continue;
            }
            if (string.equals("@marklist")) {
                this.doList("mark");
                continue;
            }
            if (string.equals("@mark")) {
                this.doList("mark");
                continue;
            }
            if (string.equals("@arrowlist")) {
                this.doList("arrow");
                continue;
            }
            if (string.equals("@arrow")) {
                this.doList("arrow");
                continue;
            }
            this.error("Unrecognized keyword '" + string + "' will be ignored");
            this.token.advanceToKeyword();
        }
        if (this.kinemage != null) {
            this.kinemage.setBondRots(this.closeBondRots());
        }
    }

    void doKinemage() throws IOException {
        if (this.kinemage != null) {
            this.kinemage.setBondRots(this.closeBondRots());
        }
        this.kinemage = new Kinemage(DEFAULT_KINEMAGE_NAME + (this.kinemages.size() + 1));
        this.kinemages.add(this.kinemage);
        this.group = null;
        this.subgroup = null;
        this.list = null;
        this.viewMap = new HashMap<String, KView>();
        this.groupsByName = new HashMap<String, KGroup>();
        this.subgroupsByName = new HashMap<String, KGroup>();
        this.listsByName = new HashMap<String, KList>();
        this.bondRots = new TreeMap();
        this.closedBondRots = new ArrayList();
        this.token.advance();
        while (!this.token.isEOF() && !this.token.isKeyword()) {
            if (this.token.isInteger()) {
                this.kinemage.setName(DEFAULT_KINEMAGE_NAME + this.token.getInt());
            } else if (this.token.isIdentifier()) {
                this.kinemage.setName(this.token.getString());
            } else {
                this.error("Unrecognized token '" + this.token.getString() + "' will be ignored");
            }
            this.token.advance();
        }
    }

    void checkKinemage() {
        if (this.kinemage == null) {
            this.kinemage = new Kinemage(DEFAULT_KINEMAGE_NAME + (this.kinemages.size() + 1));
            this.kinemages.add(this.kinemage);
            this.group = null;
            this.subgroup = null;
            this.list = null;
            this.viewMap = new HashMap<String, KView>();
            this.groupsByName = new HashMap<String, KGroup>();
            this.subgroupsByName = new HashMap<String, KGroup>();
            this.listsByName = new HashMap<String, KList>();
            this.bondRots = new TreeMap();
            this.closedBondRots = new ArrayList();
            this.error("'" + this.token.getString() + "' was found before encountering @kinemage");
        }
    }

    void doGroup() throws IOException {
        this.checkKinemage();
        this.group = new KGroup(DEFAULT_GROUP_NAME);
        this.kinemage.add(this.group);
        this.subgroup = null;
        this.list = null;
        this.groupDimension = 3;
        this.token.advance();
        while (!(this.token.isEOF() || this.token.isKeyword() || this.token.isBOL())) {
            String string;
            if (this.token.isIdentifier()) {
                this.group.setName(this.token.getString());
                this.token.advance();
                continue;
            }
            if (this.token.isLiteral()) {
                string = this.token.getString();
                if (string.equals("animate")) {
                    this.group.setAnimate(true);
                } else if (string.equals("2animate")) {
                    this.group.set2Animate(true);
                } else if (string.equals("select")) {
                    this.group.setSelect(true);
                } else if (string.equals("off")) {
                    this.group.setOn(false);
                } else if (string.equals("dominant")) {
                    this.group.setDominant(true);
                } else if (string.equals("recessiveon") || string.equals("collapsable") || string.equals("collapsible")) {
                    this.group.setCollapsible(true);
                } else if (string.equals("nobutton")) {
                    this.group.setHasButton(false);
                } else if (string.equals("lens")) {
                    this.group.setLens(true);
                } else {
                    this.error("Unrecognized literal '" + string + "' will be ignored");
                }
                this.token.advance();
                continue;
            }
            if (this.token.isProperty()) {
                string = this.token.getString();
                this.token.advance();
                if (string.equals("master=")) {
                    if (this.token.isIdentifier()) {
                        this.kinemage.ensureMasterExists(this.token.getString());
                        this.group.addMaster(this.token.getString());
                    } else {
                        this.error("master= was not followed by an identifier");
                    }
                } else if (string.equals("clone=") || string.equals("instance=")) {
                    if (this.token.isIdentifier()) {
                        KGroup kGroup = this.groupsByName.get(this.token.getString());
                        if (kGroup != null) {
                            this.group.getChildren().addAll(kGroup.clone(string.equals("clone=")).getChildren());
                        }
                    } else {
                        this.error(string + " was not followed by an identifier");
                    }
                } else if (string.equals("dimension=")) {
                    if (this.token.isInteger()) {
                        this.groupDimension = this.token.getInt();
                    } else {
                        this.error(string + " was not followed by an integer");
                    }
                } else {
                    this.error("Unrecognized property '" + string + " " + this.token.getString() + "' will be ignored");
                }
                this.token.advance();
                continue;
            }
            this.error("Unrecognized token '" + this.token.getString() + "' will be ignored");
            this.token.advance();
        }
        this.groupsByName.put(this.group.getName(), this.group);
    }

    void checkGroup() {
        this.checkKinemage();
        if (this.group == null) {
            this.group = new KGroup(IMPLIED_GROUP_NAME);
            this.group.setHasButton(false);
            this.kinemage.add(this.group);
            this.subgroup = null;
            this.list = null;
            this.groupDimension = 3;
        }
    }

    void doSubgroup() throws IOException {
        this.checkGroup();
        this.subgroup = new KGroup(DEFAULT_GROUP_NAME);
        this.group.add(this.subgroup);
        this.list = null;
        this.subgroupDimension = 3;
        this.token.advance();
        while (!(this.token.isEOF() || this.token.isKeyword() || this.token.isBOL())) {
            String string;
            if (this.token.isIdentifier()) {
                this.subgroup.setName(this.token.getString());
                this.token.advance();
                continue;
            }
            if (this.token.isLiteral()) {
                string = this.token.getString();
                if (string.equals("off")) {
                    this.subgroup.setOn(false);
                } else if (string.equals("dominant")) {
                    this.subgroup.setDominant(true);
                } else if (string.equals("recessiveon") || string.equals("collapsable") || string.equals("collapsible")) {
                    this.subgroup.setCollapsible(true);
                } else if (string.equals("nobutton")) {
                    this.subgroup.setHasButton(false);
                } else if (string.equals("lens")) {
                    this.subgroup.setLens(true);
                } else {
                    this.error("Unrecognized literal '" + string + "' will be ignored");
                }
                this.token.advance();
                continue;
            }
            if (this.token.isProperty()) {
                string = this.token.getString();
                this.token.advance();
                if (string.equals("master=")) {
                    if (this.token.isIdentifier()) {
                        this.kinemage.ensureMasterExists(this.token.getString());
                        this.subgroup.addMaster(this.token.getString());
                    } else {
                        this.error("master= was not followed by an identifier");
                    }
                } else if (string.equals("clone=") || string.equals("instance=")) {
                    if (this.token.isIdentifier()) {
                        KGroup kGroup = this.subgroupsByName.get(this.token.getString());
                        if (kGroup != null) {
                            this.subgroup.getChildren().addAll(kGroup.clone(string.equals("clone=")).getChildren());
                        }
                    } else {
                        this.error(string + " was not followed by an identifier");
                    }
                } else if (string.equals("dimension=")) {
                    if (this.token.isInteger()) {
                        this.subgroupDimension = this.token.getInt();
                    } else {
                        this.error(string + " was not followed by an integer");
                    }
                } else {
                    this.error("Unrecognized property '" + string + " " + this.token.getString() + "' will be ignored");
                }
                this.token.advance();
                continue;
            }
            this.error("Unrecognized token '" + this.token.getString() + "' will be ignored");
            this.token.advance();
        }
        this.subgroupsByName.put(this.subgroup.getName(), this.subgroup);
    }

    void checkSubgroup() {
        this.checkGroup();
        if (this.subgroup == null) {
            this.subgroup = new KGroup(IMPLIED_GROUP_NAME);
            this.subgroup.setHasButton(false);
            this.group.add(this.subgroup);
            this.list = null;
            this.subgroupDimension = 3;
        }
    }

    void doList(String string) throws IOException {
        Object object;
        this.checkSubgroup();
        this.list = new KList(string, DEFAULT_GROUP_NAME);
        this.subgroup.add(this.list);
        this.list.setDimension(3);
        if (this.subgroupDimension != 3) {
            this.list.setDimension(this.subgroupDimension);
        } else if (this.groupDimension != 3) {
            this.list.setDimension(this.groupDimension);
        }
        if (string == "mark") {
            this.list.setStyle(1024);
        }
        this.token.advance();
        boolean bl = false;
        while (!(this.token.isEOF() || this.token.isKeyword() || this.token.isIdentifier() && bl || this.token.isBOL())) {
            if (this.token.isIdentifier()) {
                this.list.setName(this.token.getString());
                bl = true;
                this.token.advance();
                continue;
            }
            if (this.token.isLiteral()) {
                object = this.token.getString();
                if (((String)object).equals("off")) {
                    this.list.setOn(false);
                } else if (((String)object).equals("nobutton")) {
                    this.list.setHasButton(false);
                } else if (((String)object).equals("lens")) {
                    this.list.setLens(true);
                } else if (((String)object).startsWith("nohi")) {
                    this.list.setNoHighlight(true);
                } else if (((String)object).endsWith("bondrot")) {
                    double d = 0.0;
                    char c = ((String)object).charAt(0);
                    int n = -1;
                    n = Character.isDigit(c) ? Character.getNumericValue(c) : this.nonIntCount++;
                    this.token.advance();
                    if (this.token.isNumber()) {
                        d = this.token.getFloat();
                    } else {
                        this.error("angle for bondrot not number");
                    }
                    this.storeBondRot(n, this.list.getName(), d);
                } else if (((String)object).startsWith("screen")) {
                    this.list.setScreen(true);
                } else {
                    this.error("Unrecognized literal '" + (String)object + "' will be ignored");
                }
                this.token.advance();
                continue;
            }
            if (this.token.isProperty()) {
                object = this.token.getString();
                this.token.advance();
                if (((String)object).equals("color=") || ((String)object).equals("colour=")) {
                    if ((this.token.isLiteral() || this.token.isIdentifier()) && this.kinemage.getAllPaintMap().containsKey(this.token.getString())) {
                        this.list.setColor(this.kinemage.getPaintForName(this.token.getString()));
                    } else {
                        this.error("color= was followed by unknown color '" + this.token.getString() + "'");
                    }
                } else if (((String)object).equals("master=")) {
                    if (this.token.isIdentifier()) {
                        this.kinemage.ensureMasterExists(this.token.getString());
                        this.list.addMaster(this.token.getString());
                    } else {
                        this.error("master= was not followed by an identifier");
                    }
                } else if (((String)object).equals("clone=")) {
                    if (this.token.isIdentifier()) {
                        KList kList = this.listsByName.get(this.token.getString());
                        if (kList != null) {
                            this.list.getChildren().addAll(kList.clone(true).getChildren());
                        }
                    } else {
                        this.error("clone= was not followed by an identifier");
                    }
                } else if (((String)object).equals("instance=")) {
                    if (this.token.isIdentifier()) {
                        KList kList = this.listsByName.get(this.token.getString());
                        if (kList != null) {
                            this.list.setInstance(kList);
                        }
                    } else {
                        this.error("instance= was not followed by an identifier");
                    }
                } else if (((String)object).equals("radius=")) {
                    if (this.token.isNumber()) {
                        this.list.setRadius(this.token.getFloat());
                    } else {
                        this.error("radius= was not followed by a number");
                    }
                } else if (((String)object).equals("angle=")) {
                    if (this.token.isNumber()) {
                        this.list.setAngle(this.token.getFloat());
                    } else {
                        this.error("angle= was not followed by a number");
                    }
                } else if (((String)object).equals("alpha=")) {
                    if (this.token.isNumber()) {
                        double d = this.token.getFloat();
                        if (d < 0.0) {
                            d = 0.0;
                        } else if (d > 1.0) {
                            d = 1.0;
                        }
                        this.list.setAlpha((int)(d * 255.0 + 0.5));
                    } else {
                        this.error("alpha= was not followed by a number");
                    }
                } else if (((String)object).equals("width=")) {
                    if (this.token.isInteger()) {
                        this.list.setWidth(this.token.getInt());
                    } else {
                        this.error("width= was not followed by an integer");
                    }
                } else if (((String)object).equals("size=")) {
                    if (!this.token.isInteger()) {
                        this.error("size= was not followed by an integer");
                    }
                } else if (((String)object).equals("dimension=")) {
                    if (this.token.isInteger()) {
                        this.list.setDimension(this.token.getInt());
                    } else {
                        this.error((String)object + " was not followed by an integer");
                    }
                } else {
                    this.error("Unrecognized property '" + (String)object + " " + this.token.getString() + "' will be ignored");
                }
                this.token.advance();
                continue;
            }
            this.error("Unrecognized token '" + this.token.getString() + "' will be ignored");
            this.token.advance();
        }
        this.listsByName.put(this.list.getName(), this.list);
        object = null;
        while (!this.token.isEOF() && !this.token.isKeyword()) {
            object = this.doPoint(string, (KPoint)object, this.list.getDimension());
        }
        if (this.rotModeIsOn()) {
            this.storeRotList(this.list);
        }
    }

    KPoint doPoint(String string, KPoint kPoint, int n) throws IOException {
        AbstractPoint abstractPoint;
        String string2 = kPoint == null ? this.list.getName() : kPoint.getName();
        if (string.equals("vector")) {
            abstractPoint = new VectorPoint(string2, (VectorPoint)kPoint);
        } else if (string.equals("dot")) {
            abstractPoint = new DotPoint(string2);
        } else if (string.equals("mark")) {
            abstractPoint = new MarkerPoint(string2);
        } else if (string.equals("label")) {
            abstractPoint = new LabelPoint(string2);
        } else if (string.equals("triangle")) {
            abstractPoint = new TrianglePoint(string2, (TrianglePoint)kPoint);
        } else if (string.equals("ribbon")) {
            abstractPoint = new TrianglePoint(string2, (TrianglePoint)kPoint);
        } else if (string.equals("ring")) {
            abstractPoint = new RingPoint(string2);
        } else if (string.equals("ball")) {
            abstractPoint = new BallPoint(string2);
        } else if (string.equals("sphere")) {
            abstractPoint = new SpherePoint(string2);
        } else if (string.equals("arrow")) {
            abstractPoint = new ArrowPoint(string2, (VectorPoint)kPoint);
        } else {
            throw new IllegalArgumentException("Unrecognized list type '" + string + "'");
        }
        float[] fArray = null;
        if (n > 3) {
            fArray = new float[n];
            abstractPoint.setAllCoords(fArray);
        }
        boolean bl = false;
        int n2 = 0;
        while (!(this.token.isEOF() || this.token.isKeyword() || this.token.isIdentifier() && bl || n2 >= n)) {
            if (this.token.isIdentifier()) {
                bl = true;
                if (!this.token.getString().equals("\"")) {
                    abstractPoint.setName(this.token.getString());
                }
            } else if (this.token.isNumber()) {
                float f = this.token.getFloat();
                if (n2 == 0) {
                    abstractPoint.setX(f);
                } else if (n2 == 1) {
                    abstractPoint.setY(f);
                } else if (n2 == 2) {
                    abstractPoint.setZ(f);
                }
                if (fArray != null) {
                    fArray[n2] = f;
                }
                ++n2;
            } else if (this.token.isAspect()) {
                abstractPoint.setAspects(this.token.getString());
            } else if (this.token.isSingleQuote()) {
                abstractPoint.setPmMask(this.kinemage.toPmBitmask(this.token.getString(), true, true));
            } else if (this.token.isLiteral()) {
                String string3 = this.token.getString();
                if (string3.equals("P") || string3.equals("p") || string3.equals("M") || string3.equals("m")) {
                    if (!string.equals("triangle") && !string.equals("ribbon")) {
                        abstractPoint.setPrev(null);
                    }
                } else if (string3.equals("X") || string3.equals("x")) {
                    abstractPoint.setPrev(null);
                } else if (!(string3.equals("L") || string3.equals("l") || string3.equals("D") || string3.equals("d") || string3.equals("T") || string3.equals("t"))) {
                    if (string3.equals("U") || string3.equals("u")) {
                        abstractPoint.setUnpickable(true);
                    } else if (string3.equals("ghost")) {
                        abstractPoint.setGhost(true);
                    } else if (string3.startsWith("width")) {
                        try {
                            abstractPoint.setWidth(Integer.parseInt(string3.substring(5)));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (this.kinemage.getAllPaintMap().containsKey(string3)) {
                        abstractPoint.setColor(this.kinemage.getPaintForName(string3));
                    } else {
                        this.error("Unrecognized literal '" + string3 + "' will be ignored");
                    }
                }
            } else if (this.token.isProperty()) {
                String string4 = this.token.getString();
                this.token.advance();
                if (string4.equals("r=")) {
                    if (this.token.isNumber()) {
                        abstractPoint.setRadius(this.token.getFloat());
                    } else {
                        this.error("r= was not followed by a number");
                    }
                } else {
                    this.error("Unrecognized property '" + string4 + " " + this.token.getString() + "' will be ignored");
                }
            } else if (this.token.isComment()) {
                abstractPoint.setComment(this.token.getString());
            } else {
                this.error("Unrecognized token '" + this.token.getString() + "' will be ignored");
            }
            this.token.advance();
        }
        if (bl || n2 > 0) {
            this.list.add(abstractPoint);
            return abstractPoint;
        }
        this.error("Junk point will be ignored (no ID, no coordinates)");
        return null;
    }

    void doText() throws IOException {
        this.atText.append(this.token.advanceToKeyword().trim()).append("\n\n");
    }

    void doCaption() throws IOException {
        this.checkKinemage();
        this.atText.append("CAPTION for " + this.kinemage.getName() + ":\n    ");
        this.atText.append(this.token.advanceToKeyword().trim()).append("\n\n");
    }

    void doTitle() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isIdentifier()) {
            this.kinemage.setName(this.token.getString());
            this.token.advance();
        } else {
            this.error("@title was not followed by an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    void doCopyright() throws IOException {
        this.token.advance();
        if (this.token.isIdentifier()) {
            if (this.kinemage != null) {
                this.atText.append("'" + this.kinemage.getName() + "' is ");
            }
            this.atText.append("COPYRIGHT (C) ").append(this.token.getString()).append("\n\n");
            this.token.advance();
        } else {
            this.error("@copyright was not followed by an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    void doPdbFile() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isIdentifier()) {
            this.kinemage.atPdbfile = this.token.getString();
            this.token.advance();
        } else {
            this.error("@pdbfile was not followed by an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    void doCommand() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isIdentifier()) {
            this.kinemage.atCommand = this.token.getString();
            this.token.advance();
        } else {
            this.error("@command was not followed by an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    KView getView() {
        KView kView;
        this.checkKinemage();
        String string = this.token.getString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        char c = string.charAt(1);
        while (Character.isDigit(c)) {
            stringBuffer.append(c);
            c = string.charAt(++n);
        }
        String string2 = stringBuffer.toString();
        if (string2.equals(DEFAULT_GROUP_NAME)) {
            string2 = "1";
        }
        if ((kView = this.viewMap.get(string2)) == null) {
            kView = new KView(this.kinemage);
            this.kinemage.addView(kView);
            this.viewMap.put(string2, kView);
        }
        return kView;
    }

    void doViewID() throws IOException {
        KView kView = this.getView();
        this.token.advance();
        if (this.token.isIdentifier()) {
            kView.setName(this.token.getString());
            this.token.advance();
        } else {
            this.error("@viewid was not followed by an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    void doZoom() throws IOException {
        KView kView = this.getView();
        this.token.advance();
        if (this.token.isNumber()) {
            kView.setZoom(this.token.getFloat());
            this.token.advance();
        } else {
            this.error("@zoom was not followed by a number; found '" + this.token.getString() + "' instead");
        }
    }

    void doSpan() throws IOException {
        KView kView = this.getView();
        this.token.advance();
        if (this.token.isNumber()) {
            kView.setSpan(this.token.getFloat());
            this.token.advance();
        } else {
            this.error("@span was not followed by a number; found '" + this.token.getString() + "' instead");
        }
    }

    void doClip() throws IOException {
        KView kView = this.getView();
        this.token.advance();
        if (this.token.isNumber()) {
            kView.setClip(this.token.getFloat() / 200.0f);
            this.token.advance();
        } else {
            this.error("@zslab was not followed by a number; found '" + this.token.getString() + "' instead");
        }
    }

    void doCenter() throws IOException {
        KView kView = this.getView();
        try {
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            float f = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            float f2 = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            float f3 = this.token.getFloat();
            this.token.advance();
            kView.setCenter(f, f2, f3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("@center was not followed by 3 numbers; found '" + this.token.getString() + "' instead");
        }
    }

    void doAxisChoice() throws IOException {
        KView kView = this.getView();
        try {
            this.token.advance();
            if (!this.token.isInteger()) {
                throw new IllegalArgumentException();
            }
            int n = this.token.getInt();
            this.token.advance();
            if (!this.token.isInteger()) {
                throw new IllegalArgumentException();
            }
            int n2 = this.token.getInt();
            this.token.advance();
            if (!this.token.isInteger()) {
                throw new IllegalArgumentException();
            }
            int n3 = this.token.getInt();
            this.token.advance();
            kView.setViewingAxes(new int[]{Math.max(n - 1, 0), Math.max(n2 - 1, 0), Math.max(n3 - 1, 0)});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("@axischoice was not followed by 3 integers; found '" + this.token.getString() + "' instead");
        }
    }

    void doMatrix() throws IOException {
        KView kView = this.getView();
        try {
            float[][] fArray = new float[3][3];
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[0][0] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[1][0] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[2][0] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[0][1] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[1][1] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[2][1] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[0][2] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[1][2] = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            fArray[2][2] = this.token.getFloat();
            this.token.advance();
            kView.setMatrix(fArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("@matrix was not followed by 9 numbers; found '" + this.token.getString() + "' instead");
        }
    }

    void doWhiteBackground() throws IOException {
        this.checkKinemage();
        this.kinemage.atWhitebackground = true;
        this.token.advance();
    }

    void doOnewidth() throws IOException {
        this.checkKinemage();
        this.kinemage.atOnewidth = true;
        this.token.advance();
    }

    void doThinline() throws IOException {
        this.checkKinemage();
        this.kinemage.atThinline = true;
        this.token.advance();
    }

    void doPerspective() throws IOException {
        this.checkKinemage();
        this.kinemage.atPerspective = true;
        this.token.advance();
    }

    void doFlat() throws IOException {
        this.checkKinemage();
        this.kinemage.atFlat = true;
        this.token.advance();
    }

    void doListColorDominant() throws IOException {
        this.checkKinemage();
        this.kinemage.atListcolordominant = true;
        this.token.advance();
    }

    void doLens() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isNumber()) {
            this.kinemage.atLens = this.token.getDouble();
            this.token.advance();
        } else {
            this.error("@lens was not followed by a number; found '" + this.token.getString() + "' instead");
        }
    }

    void doColorset() throws IOException {
        this.checkKinemage();
        Map<String, KPaint> map = this.kinemage.getAllPaintMap();
        try {
            this.token.advance();
            if (!this.token.isIdentifier()) {
                throw new IllegalArgumentException();
            }
            String string = this.token.getString();
            this.token.advance();
            if (!this.token.isLiteral()) {
                throw new IllegalArgumentException();
            }
            String string2 = this.token.getString();
            if (!map.containsKey(string2)) {
                throw new IllegalArgumentException();
            }
            this.token.advance();
            KPaint kPaint = KPaint.createAlias(string, this.kinemage.getPaintForName(string2));
            this.kinemage.addPaint(kPaint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("@colorset was not followed by an identifier and a recognized color; found '" + this.token.getString() + "' instead");
        }
    }

    void doHsvColor() throws IOException {
        this.checkKinemage();
        try {
            float f;
            float f2;
            float f3;
            this.token.advance();
            if (!this.token.isIdentifier()) {
                throw new IllegalArgumentException();
            }
            String string = this.token.getString();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            float f4 = f3 = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            float f5 = f2 = this.token.getFloat();
            this.token.advance();
            if (!this.token.isNumber()) {
                throw new IllegalArgumentException();
            }
            float f6 = f = this.token.getFloat();
            this.token.advance();
            if (this.token.isNumber()) {
                f3 = this.token.getFloat();
                this.token.advance();
                if (this.token.isNumber()) {
                    f2 = this.token.getFloat();
                    this.token.advance();
                    if (this.token.isNumber()) {
                        f = this.token.getFloat();
                        this.token.advance();
                    }
                }
            }
            KPaint kPaint = KPaint.createLightweightHSV(string, f4, f5, f6, f3, f2, f);
            this.kinemage.addPaint(kPaint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("@hsvcolor was not followed by an identifier and 3 - 6 numbers; found '" + this.token.getString() + "' instead");
        }
    }

    void doMaster() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isIdentifier()) {
            MasterGroup masterGroup = this.kinemage.getMasterByName(this.token.getString());
            this.token.advance();
            while (!this.token.isEOF() && !this.token.isKeyword()) {
                if (this.token.isLiteral()) {
                    if (this.token.getString().equals("indent")) {
                        masterGroup.setIndent(true);
                    } else if (this.token.getString().equals("on")) {
                        masterGroup.setOnForced(true);
                    } else if (this.token.getString().equals("off")) {
                        masterGroup.setOnForced(false);
                    } else {
                        this.error("Unrecognized literal '" + this.token.getString() + "' will be ignored");
                    }
                } else {
                    this.error("Unrecognized token '" + this.token.getString() + "' will be ignored");
                }
                this.token.advance();
            }
        } else {
            this.error("@master was not followed by an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    void doPointmaster() throws IOException {
        this.checkKinemage();
        try {
            this.token.advance();
            if (!this.token.isSingleQuote()) {
                throw new IllegalArgumentException();
            }
            String string = this.token.getString();
            this.token.advance();
            if (!this.token.isIdentifier()) {
                throw new IllegalArgumentException();
            }
            String string2 = this.token.getString();
            this.token.advance();
            MasterGroup masterGroup = this.kinemage.getMasterByName(string2);
            masterGroup.setPmMask(string);
            while (!this.token.isEOF() && !this.token.isKeyword()) {
                if (this.token.isLiteral()) {
                    if (this.token.getString().equals("indent")) {
                        masterGroup.setIndent(true);
                    } else if (this.token.getString().equals("on")) {
                        masterGroup.setOnForced(true);
                    } else if (this.token.getString().equals("off")) {
                        masterGroup.setOnForced(false);
                    } else {
                        this.error("Unrecognized literal '" + this.token.getString() + "' will be ignored");
                    }
                } else {
                    this.error("Unrecognized token '" + this.token.getString() + "' will be ignored");
                }
                this.token.advance();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("@pointmaster was not followed by a single-quoted string and an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    void doAspect() throws IOException {
        this.checkKinemage();
        String string = this.token.getString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        char c = string.charAt(1);
        while (Character.isDigit(c)) {
            stringBuffer.append(c);
            c = string.charAt(++n);
        }
        String string2 = stringBuffer.toString();
        if (string2.equals(DEFAULT_GROUP_NAME)) {
            string2 = "1";
        }
        try {
            int n2 = Integer.parseInt(string2);
            this.token.advance();
            if (!this.token.isIdentifier()) {
                throw new IllegalArgumentException();
            }
            this.kinemage.createAspect(this.token.getString(), new Integer(n2));
            this.token.advance();
        }
        catch (NumberFormatException numberFormatException) {
            this.error("@aspect was not recognized; '" + string2 + "' is not an integer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("@aspect was not followed by an identifier; found '" + this.token.getString() + "' instead");
        }
    }

    void doDimensions() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isIdentifier()) {
            while (this.token.isIdentifier()) {
                this.kinemage.dimensionNames.add(this.token.getString());
                this.token.advance();
            }
        } else {
            this.error("@dimensions was not followed by 1+ identifiers; found '" + this.token.getString() + "' instead");
        }
    }

    void doDimMinMax() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isNumber()) {
            while (this.token.isNumber()) {
                this.kinemage.dimensionMinMax.add(new Double(this.token.getDouble()));
                this.token.advance();
            }
        } else {
            this.error("@dimminmax was not followed by 1+ numbers; found '" + this.token.getString() + "' instead");
        }
    }

    void doDimScale() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isNumber()) {
            while (this.token.isNumber()) {
                this.kinemage.dimensionScale.add(new Double(this.token.getDouble()));
                this.token.advance();
            }
        } else {
            this.error("@dimscale was not followed by 1+ numbers; found '" + this.token.getString() + "' instead");
        }
    }

    void doDimOffset() throws IOException {
        this.checkKinemage();
        this.token.advance();
        if (this.token.isNumber()) {
            while (this.token.isNumber()) {
                this.kinemage.dimensionOffset.add(new Double(this.token.getDouble()));
                this.token.advance();
            }
        } else {
            this.error("@dimoffset was not followed by 1+ numbers; found '" + this.token.getString() + "' instead");
        }
    }

    private void storeBondRot(int n, String string, double d) {
        Integer n2 = new Integer(n);
        SortedMap<Object, Object> sortedMap = new TreeMap();
        if (n != -1) {
            sortedMap = this.bondRots.tailMap(n2);
        }
        if (!sortedMap.isEmpty()) {
            for (BondRot bondRot : sortedMap.values()) {
                bondRot.setOpen(false);
                this.closedBondRots.add(bondRot);
            }
        }
        if (n != -1) {
            this.bondRots = new TreeMap<Integer, BondRot>(this.bondRots.headMap(n2));
        }
        BondRot bondRot = new BondRot(n, string, d);
        this.bondRots.put(n2, bondRot);
    }

    private void storeRotList(KList kList) {
        for (BondRot bondRot : this.bondRots.values()) {
            if (!bondRot.isOpen()) continue;
            bondRot.add(kList);
        }
    }

    private ArrayList<BondRot> closeBondRots() {
        if (this.bondRots != null) {
            for (BondRot bondRot : this.bondRots.values()) {
                bondRot.setOpen(false);
                this.closedBondRots.add(bondRot);
            }
            this.bondRots = null;
        }
        return this.closedBondRots;
    }

    public boolean rotModeIsOn() {
        return !this.bondRots.isEmpty();
    }

    public void Main() {
        System.out.println("Read " + this.kinemages.size() + " kinemages:");
        for (Kinemage kinemage : this.kinemages) {
            for (AGE aGE : KIterator.allNonPoints(kinemage)) {
                if (aGE instanceof Kinemage) {
                    System.out.println("  Kinemage: " + aGE.getName() + " (" + aGE.getChildren().size() + " groups)");
                    continue;
                }
                if (aGE instanceof KGroup && aGE.getDepth() == 1) {
                    System.out.println("    Group: " + aGE.getName() + " (" + aGE.getChildren().size() + " subgroups)");
                    continue;
                }
                if (aGE instanceof KGroup && aGE.getDepth() == 2) {
                    System.out.println("      Subgroup: " + aGE.getName() + " (" + aGE.getChildren().size() + " lists)");
                    continue;
                }
                if (!(aGE instanceof KList)) continue;
                System.out.println("        List: " + aGE.getName() + " (" + aGE.getChildren().size() + " points)");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            if (stringArray.length > 0) {
                System.err.println("*** Takes a kinemage on stdin or as first arg and writes structure to stdout.");
                inputStreamReader = new FileReader(stringArray[0]);
            }
            long l = System.currentTimeMillis();
            KinfileParser kinfileParser = new KinfileParser();
            kinfileParser.parse(new LineNumberReader(inputStreamReader));
            l = System.currentTimeMillis() - l;
            System.out.println("END OF FILE (" + l + " ms)");
            System.gc();
            System.out.println("Using " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " bytes");
            kinfileParser.Main();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(SoftLog.err);
        }
    }
}

