/*
 * Decompiled with CFR 0.152.
 */
package king.painters;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import king.core.KPaint;
import king.core.KPalette;
import king.core.Painter;

public class StandardPainter
implements Painter {
    protected static final boolean REALLY_PAINT = true;
    boolean forceAA;
    Graphics2D g = null;
    Font font = null;
    FontMetrics metrics = null;
    Rectangle clipRgn = new Rectangle(0, 0, 1, 1);
    int[] xPoints = new int[6];
    int[] yPoints = new int[6];

    public StandardPainter(boolean bl) {
        this.forceAA = bl;
    }

    public void paintBall(Paint paint, double d, double d2, double d3, double d4, boolean bl) {
        int n = (int)(2.0 * d4 + 0.5);
        if (n < 2) {
            n = 2;
        }
        this.g.setPaint(paint);
        this.g.fillOval((int)(d - d4), (int)(d2 - d4), n, n);
        try {
            Color color = (Color)paint;
            if (n >= 10 && color.getAlpha() == 255) {
                this.g.setPaint(KPaint.black);
                this.g.drawOval((int)(d - d4), (int)(d2 - d4), n, n);
            }
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            System.err.println("StandardPainter: tried painting with non-Color type of Paint");
        }
        if (bl) {
            double d5 = 0.5 * d4;
            n = (int)(0.3 * d4) + 1;
            this.g.setPaint(Color.white);
            this.g.fillOval((int)(d - d5), (int)(d2 - d5), n, n);
        }
    }

    public void paintDot(Paint paint, double d, double d2, double d3, int n) {
        int n2 = n / 2;
        this.g.setPaint(paint);
        this.g.fillRect((int)(d - (double)n2), (int)(d2 - (double)n2), n, n);
    }

    public void paintLabel(Paint paint, String string, double d, double d2, double d3) {
        this.g.setPaint(paint);
        this.g.setFont(this.font);
        this.g.drawString(string, (int)d, (int)d2);
    }

    public void paintMarker(Paint paint, double d, double d2, double d3, int n, int n2) {
        int n3 = (int)d;
        int n4 = (int)d2;
        int n5 = n;
        int n6 = 2 * n;
        int n7 = 3 * n;
        int n8 = 4 * n;
        int n9 = 5 * n;
        int n10 = 6 * n;
        int n11 = 7 * n;
        int n12 = 10 * n;
        int n13 = 11 * n;
        this.g.setPaint(paint);
        if ((n2 & 0x4000) != 0) {
            this.g.fillRect(n3 - n9, n4 - n9, n13, n13);
        } else if ((n2 & 0x400000) != 0) {
            this.g.fillOval(n3 - n9, n4 - n9, n13, n13);
        }
        if ((n2 & 0x2000) != 0) {
            this.g.fillRect(n3 - n7, n4 - n7, n11, n11);
        } else if ((n2 & 0x200000) != 0) {
            this.g.fillOval(n3 - n7, n4 - n7, n11, n11);
        }
        if ((n2 & 0x1000) != 0) {
            this.g.fillRect(n3 - n5, n4 - n5, n7, n7);
        } else if ((n2 & 0x100000) != 0) {
            this.g.fillOval(n3 - n5, n4 - n5, n7, n7);
        }
        if ((n2 & 1) != 0) {
            this.g.drawLine(n3, n4 - n5, n3, n4 + n5);
            this.g.drawLine(n3 - n5, n4, n3 + n5, n4);
        }
        if ((n2 & 2) != 0) {
            this.g.drawLine(n3, n4 - n7, n3, n4 + n7);
            this.g.drawLine(n3 - n7, n4, n3 + n7, n4);
        }
        if ((n2 & 4) != 0) {
            this.g.drawLine(n3, n4 - n9, n3, n4 + n9);
            this.g.drawLine(n3 - n9, n4, n3 + n9, n4);
        }
        if ((n2 & 8) != 0) {
            this.g.drawLine(n3 - n5, n4 - n9, n3 - n5, n4 + n9);
            this.g.drawLine(n3 + n5, n4 - n9, n3 + n5, n4 + n9);
            this.g.drawLine(n3 - n9, n4 - n5, n3 + n9, n4 - n5);
            this.g.drawLine(n3 - n9, n4 + n5, n3 + n9, n4 + n5);
        }
        if ((n2 & 0x10) != 0) {
            this.g.drawLine(n3 - n5, n4 - n5, n3 + n5, n4 + n5);
            this.g.drawLine(n3 - n5, n4 + n5, n3 + n5, n4 - n5);
        }
        if ((n2 & 0x20) != 0) {
            this.g.drawLine(n3 - n7, n4 - n7, n3 + n7, n4 + n7);
            this.g.drawLine(n3 - n7, n4 + n7, n3 + n7, n4 - n7);
        }
        if ((n2 & 0x40) != 0) {
            this.g.drawLine(n3 - n9, n4 - n9, n3 + n9, n4 + n9);
            this.g.drawLine(n3 - n9, n4 + n9, n3 + n9, n4 - n9);
        }
        if ((n2 & 0x80) != 0) {
            this.g.drawLine(n3 - n8, n4 - n9, n3 + n9, n4 + n8);
            this.g.drawLine(n3 - n9, n4 - n8, n3 + n8, n4 + n9);
            this.g.drawLine(n3 - n8, n4 + n9, n3 + n9, n4 - n8);
            this.g.drawLine(n3 - n9, n4 + n8, n3 + n8, n4 - n9);
        }
        if ((n2 & 0x100) != 0) {
            this.g.drawRect(n3 - n5, n4 - n5, n6, n6);
        }
        if ((n2 & 0x200) != 0) {
            this.g.drawRect(n3 - n7, n4 - n7, n10, n10);
        }
        if ((n2 & 0x400) != 0) {
            this.g.drawRect(n3 - n9, n4 - n9, n12, n12);
        }
        if ((n2 & 0x10000) != 0) {
            this.g.drawOval(n3 - n5, n4 - n5, n6, n6);
        }
        if ((n2 & 0x20000) != 0) {
            this.g.drawOval(n3 - n7, n4 - n7, n10, n10);
        }
        if ((n2 & 0x40000) != 0) {
            this.g.drawOval(n3 - n9, n4 - n9, n12, n12);
        }
    }

    public void paintSphereDisk(Paint paint, double d, double d2, double d3, double d4) {
        int n = (int)(2.0 * d4 + 0.5);
        if (n < 2) {
            n = 2;
        }
        this.g.setPaint(paint);
        this.g.fillOval((int)(d - d4), (int)(d2 - d4), n, n);
    }

    public void paintTriangle(Paint paint, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.g.setPaint(paint);
        this.xPoints[0] = (int)d;
        this.yPoints[0] = (int)d2;
        this.xPoints[1] = (int)d4;
        this.yPoints[1] = (int)d5;
        this.xPoints[2] = (int)d7;
        this.yPoints[2] = (int)d8;
        this.g.fillPolygon(this.xPoints, this.yPoints, 3);
    }

    public void paintVector(Paint paint, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        this.g.setPaint(paint);
        this.prettyLine((int)d, (int)d2, (int)d4, (int)d5, KPalette.lineWidths[n - 1][n2]);
    }

    void prettyLine(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = -n5 / 2;
        int n8 = n7 + n5;
        int n9 = Math.abs(n3 - n);
        if (n9 > (n6 = Math.abs(n4 - n2))) {
            if (n < n3) {
                this.xPoints[0] = n;
                this.xPoints[1] = n + n7;
                this.xPoints[2] = n;
                this.xPoints[3] = n3;
                this.xPoints[4] = n3 - n7;
                this.xPoints[5] = n3;
                this.yPoints[0] = n2 + n7;
                this.yPoints[1] = n2;
                this.yPoints[2] = n2 + n8;
                this.yPoints[3] = n4 + n8;
                this.yPoints[4] = n4;
                this.yPoints[5] = n4 + n7;
            } else {
                this.xPoints[0] = n;
                this.xPoints[1] = n - n7;
                this.xPoints[2] = n;
                this.xPoints[3] = n3;
                this.xPoints[4] = n3 + n7;
                this.xPoints[5] = n3;
                this.yPoints[0] = n2 + n7;
                this.yPoints[1] = n2;
                this.yPoints[2] = n2 + n8;
                this.yPoints[3] = n4 + n8;
                this.yPoints[4] = n4;
                this.yPoints[5] = n4 + n7;
            }
        } else if (n2 < n4) {
            this.xPoints[0] = n + n7;
            this.xPoints[1] = n;
            this.xPoints[2] = n + n8;
            this.xPoints[3] = n3 + n8;
            this.xPoints[4] = n3;
            this.xPoints[5] = n3 + n7;
            this.yPoints[0] = n2;
            this.yPoints[1] = n2 + n7;
            this.yPoints[2] = n2;
            this.yPoints[3] = n4;
            this.yPoints[4] = n4 - n7;
            this.yPoints[5] = n4;
        } else {
            this.xPoints[0] = n + n7;
            this.xPoints[1] = n;
            this.xPoints[2] = n + n8;
            this.xPoints[3] = n3 + n8;
            this.xPoints[4] = n3;
            this.xPoints[5] = n3 + n7;
            this.yPoints[0] = n2;
            this.yPoints[1] = n2 - n7;
            this.yPoints[2] = n2;
            this.yPoints[3] = n4;
            this.yPoints[4] = n4 + n7;
            this.yPoints[5] = n4;
        }
        this.g.fillPolygon(this.xPoints, this.yPoints, 6);
    }

    void fastLine(int n, int n2, int n3, int n4, int n5) {
        this.g.drawLine(n, n2, n3, n4);
        int n6 = -n5 / 2;
        int n7 = n6 + n5;
        if (Math.abs(n3 - n) > Math.abs(n4 - n2)) {
            int n8;
            for (n8 = n6; n8 < 0; ++n8) {
                this.g.drawLine(n, n2 + n8, n3, n4 + n8);
            }
            for (n8 = 1; n8 < n7; ++n8) {
                this.g.drawLine(n, n2 + n8, n3, n4 + n8);
            }
        } else {
            int n9;
            for (n9 = n6; n9 < 0; ++n9) {
                this.g.drawLine(n + n9, n2, n3 + n9, n4);
            }
            for (n9 = 1; n9 < n7; ++n9) {
                this.g.drawLine(n + n9, n2, n3 + n9, n4);
            }
        }
    }

    public void drawOval(Paint paint, double d, double d2, double d3, double d4, double d5) {
        this.g.setPaint(paint);
        this.g.drawOval((int)(d - d4 / 2.0), (int)(d2 - d5 / 2.0), (int)d4, (int)d5);
    }

    public void drawOval(Paint paint, int n, int n2, double d, double d2, double d3, double d4, double d5) {
        this.g.setPaint(paint);
        int n3 = (int)(d - d4 / 2.0 - (double)n / 2.0);
        int n4 = (int)(d2 - d5 / 2.0 - (double)n / 2.0);
        int n5 = (int)(d4 + (double)n);
        int n6 = (int)(d5 + (double)n);
        for (int i = 0; i < n; ++i) {
            this.g.drawOval(n3, n4, n5, n6);
            ++n3;
            ++n4;
            n5 -= 2;
            n6 -= 2;
        }
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
        if (this.forceAA) {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.font != null) {
            this.metrics = this.g.getFontMetrics(this.font);
        }
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.g != null) {
            this.metrics = this.g.getFontMetrics(font);
        }
    }

    public int getLabelWidth(String string) {
        return this.metrics.stringWidth(string);
    }

    public int getLabelAscent(String string) {
        return this.metrics.getAscent();
    }

    public int getLabelDescent(String string) {
        return this.metrics.getDescent();
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.clipRgn.setBounds(n, n2, n3, n4);
        this.g.setClip(this.clipRgn);
    }

    public void clearCanvas(Color color) {
        this.g.setColor(color);
        this.g.fillRect(this.clipRgn.x, this.clipRgn.y, this.clipRgn.width, this.clipRgn.height);
    }
}

