/*
 * Decompiled with CFR 0.152.
 */
package molikin.crayons;

import driftwood.moldb2.AtomState;
import driftwood.r3.Tuple3;
import molikin.AtomCrayon;
import molikin.BondCrayon;
import molikin.GuidePoint;
import molikin.RibbonCrayon;
import molikin.crayons.AbstractCrayon;

public class BfactorCrayon
extends AbstractCrayon
implements AtomCrayon,
BondCrayon,
RibbonCrayon {
    private static final String[] B_COLORS = new String[]{"blue", "purple", "magenta", "hotpink", "red", "orange", "gold", "yellow", "yellowtint", "white"};
    private static final double[] B_MAXVALS = new double[]{5.0, 10.0, 15.0, 20.0, 30.0, 40.0, 50.0, 60.0, 80.0};
    int colorIndex;
    double[] maxvals;
    String[] colors;

    public BfactorCrayon() {
        this(B_MAXVALS, B_COLORS);
    }

    protected BfactorCrayon(double[] dArray, String[] stringArray) {
        if (dArray.length + 1 > stringArray.length) {
            throw new IllegalArgumentException("Must have at least one more color than value-stop");
        }
        this.maxvals = (double[])dArray.clone();
        this.colors = (String[])stringArray.clone();
    }

    public void forAtom(AtomState atomState) {
        this.setValue(atomState.getTempFactor());
    }

    public void forBond(AtomState atomState, AtomState atomState2) {
        this.setValue(atomState.getTempFactor());
    }

    public void forRibbon(Tuple3 tuple3, GuidePoint guidePoint, GuidePoint guidePoint2, int n, int n2) {
        this.setValue(0.0);
    }

    protected void setValue(double d) {
        this.colorIndex = 0;
        while (this.colorIndex < this.maxvals.length && !(this.maxvals[this.colorIndex] > d)) {
            ++this.colorIndex;
        }
    }

    public String getColor() {
        return this.colors[this.colorIndex];
    }

    public String getKinString() {
        return this.getColor();
    }
}

