import QtQuick 2.0
import QtTest 1.0
import Friends 0.1

// See more details @ http://qt-project.org/doc/qt-5.0/qtquick/qml-testcase.html

Item {
    // The objects

    FriendsDispatcher {
        id: friends
    }

    SignalSpy {
        id: signalSpy
        target: friends
    }
    TestCase {
        name: "testFriendsDispatcher"

        function test_url_shorten () {
            var input = "http://www.python.org"
            var res = friends.urlShorten (input);
            compare (res, input.length.toString());
        }

        function test_features () {
            var input = ["facebook"]
            var res = friends.featuresForProtocol (input[0]);
            compare (res, input);
        }

        function test_uploadForAccountAsync () {
            var acct = 1;
            var uri = "file:///tmp/foo.png";
            var desc = "Something interesting to say";
            signalSpy.clear ();
            signalSpy.signalName = "onUploadComplete"
            friends.uploadForAccountAsync (acct, uri, desc)
            signalSpy.wait ();
            compare(1, signalSpy.count, "onUploadComplete emitted");
        }

        function test_sendforAccountAsync () {
            var acct = 1;
            var msg = "Something interesting to say";
            signalSpy.clear ();
            signalSpy.signalName = "onSendComplete"
            friends.sendForAccountAsync (acct, msg)
            signalSpy.wait ();
            compare(1, signalSpy.count, "onSendComplete emitted");
        }

        function test_sendAsync () {
            var msg = "Something interesting to say";
            signalSpy.clear ();
            signalSpy.signalName = "onSendComplete"
            friends.sendAsync (msg)
            signalSpy.wait ();
            compare(1, signalSpy.count, "onSendComplete emitted");
        }

        function test_sendReplyAsync () {
            var acct = 1;
            var msgId = "10";
            var msg = "Something interesting to say";
            signalSpy.clear ();
            signalSpy.signalName = "onSendComplete"
            friends.sendReplyAsync (acct, msgId, msg)
            signalSpy.wait ();
            compare(1, signalSpy.count, "onSendComplete emitted");
        }

        function test_retweetAsync () {
            var acct = 1;
            var msgId = "10";
            signalSpy.clear ();
            signalSpy.signalName = "onRetweetComplete"
            friends.retweetAsync (acct, msgId)
            signalSpy.wait ();
            compare(1, signalSpy.count, "onRetweetComplete emitted");
        }

        function test_likeAsync () {
            var acct = 1;
            var msgId = "10";
            signalSpy.clear ();
            signalSpy.signalName = "onLikeComplete"
            friends.likeAsync (acct, msgId)
            signalSpy.wait ();
            compare(1, signalSpy.count, "onLikeComplete emitted");
        }

        function test_unlikeAsync () {
            var acct = 1;
            var msgId = "10";
            signalSpy.clear ();
            signalSpy.signalName = "onUnlikeComplete"
            friends.unlikeAsync (acct, msgId)
            signalSpy.wait ();
            compare(1, signalSpy.count, "onUnlikeComplete emitted");
        }
    }

    StreamModel {
        id: streamModel
    }
    
    TestCase {
        name: "testStreamModel"
        
        function init() {
            console.debug(">> init");
            console.debug("<< init");    
        }
        
        function cleanup() {
            console.debug(">> cleanup");
            console.debug("<< cleanup");
        }
        
        function initTestCase() {
            console.debug(">> initTestCase");
            console.debug("<< initTestCase");
        }
        
        function cleanupTestCase() {
            console.debug(">> cleanupTestCase");
            console.debug("<< cleanupTestCase");
        }

        function test_streamModelStream() {
            streamModel.stream = "messages";
            compare(0, streamModel.count, "Test StreamModel row count filtered by stream");
        }

        function test_streamModelService() {
            streamModel.service = "twitter";
            compare(0, streamModel.count, "Test StreamModel row count filtered by service");
        }
        function test_streamModelAccount() {
            streamModel.account = 1;
            compare(0, streamModel.count, "Test StreamModel row count filtered by account");
        }
    }
}
