/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 *
 * Some Plextor commands got from PxScan and CDVDlib (C) Alexander Noe`
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */


#ifndef __PLEXTOR_FEATURES
#define __PLEXTOR_FEATURES 1

const char PLEX_GET_MODE	= 0x00;
const char PLEX_SET_MODE	= 0x10;

const char PLEX_MODE_SS_HIDE	= 0x01;
const char PLEX_MODE_VARIREC	= 0x02;
const char PLEX_MODE_GIGAREC	= 0x04;
const char PLEX_MODE_SILENT_DISC = 0x06;
const char PLEX_MODE_SILENT_TRAY = 0x07;
const char PLEX_MODE_SILENT	= 0x08;
const char PLEX_MODE_TESTWRITE_DVDPLUS	= 0x21;
const char PLEX_MODE_BITSET	= 0x22;
	const char PLEX_BITSET_R	= 0x0A;
	const char PLEX_BITSET_RDL	= 0x0E;
const char PLEX_MODE_SPDREAD	= 0xBB;

typedef struct {
	short	val;
	char	name[4];
} REC;

// GigaRec definitions
const int GIGAREC_06  = 0x83;
const int GIGAREC_07  = 0x82;
const int GIGAREC_08  = 0x81;
const int GIGAREC_09  = 0x84;
const int GIGAREC_10  = 0x00;
const int GIGAREC_11  = 0x04;
const int GIGAREC_12  = 0x01;
const int GIGAREC_13  = 0x02;
const int GIGAREC_14  = 0x03;

const REC gigarec_tbl[]={
	{ GIGAREC_06, "0.6" },
	{ GIGAREC_07, "0.7" },
	{ GIGAREC_08, "0.8" },
	{ GIGAREC_09, "0.9" },
	{ GIGAREC_10, "OFF" },
	{ GIGAREC_11, "1.1" },
	{ GIGAREC_12, "1.2" },
	{ GIGAREC_13, "1.3" },
	{ GIGAREC_14, "1.4" },
	{ 0xFF,"N/A" }
};

// VariRec definitions
const int VARIREC_CD		= 0x00;
const int VARIREC_DVD		= 0x10;

const int VARIREC_CD_STRATEGY	= 0x03;
const int VARIREC_DVD_STRATEGY	= 0x04;


const int VARIREC_PLUS_1	= 0x01;
const int VARIREC_PLUS_2	= 0x02;
const int VARIREC_PLUS_3	= 0x03;
const int VARIREC_PLUS_4	= 0x04;
const int VARIREC_NULL		= 0x00;
const int VARIREC_MINUS_1	= 0x81;
const int VARIREC_MINUS_2	= 0x82;
const int VARIREC_MINUS_3	= 0x83;
const int VARIREC_MINUS_4	= 0x84;

const REC varirec_pwr_tbl[]={
	{ VARIREC_MINUS_4,"-4" },
	{ VARIREC_MINUS_3,"-3" },
	{ VARIREC_MINUS_2,"-2" },
	{ VARIREC_MINUS_1,"-1" },
	{ VARIREC_NULL,   " 0" },
	{ VARIREC_PLUS_1, "+1" },
	{ VARIREC_PLUS_2, "+2" },
	{ VARIREC_PLUS_3, "+3" },
	{ VARIREC_PLUS_4, "+4" },
	{ 0xFF,"N/A" }
};

typedef char str16[16];

const int varirec_max_str_cd=7;
const str16 varirec_str_cd_tbl[]={
	"Default",
	"Azo",
	"Cyanine",
	"PhtaloCyanine A",
	"PhtaloCyanine B",
	"PhtaloCyanine C",
	"PhtaloCyanine D"
};

const int varirec_max_str_dvd=9;
const str16 varirec_str_dvd_tbl[]={
	"Default",
	"Strategy0",
	"Strategy1",
	"Strategy2",
	"Strategy3",
	"Strategy4",
	"Strategy5",
	"Strategy6",
	"Strategy7"
};

// Silent Mode definitions
const int SILENT_CD_WR_48X = 0x08;
const int SILENT_CD_WR_32X = 0x06;
const int SILENT_CD_WR_24X = 0x05;
const int SILENT_CD_WR_16X = 0x03;
const int SILENT_CD_WR_8X  = 0x01;
const int SILENT_CD_WR_4X  = 0x00;

const REC silent_cd_wr_tbl[]={
	{ SILENT_CD_WR_48X, "48X" },
	{ SILENT_CD_WR_32X, "32X" },
	{ SILENT_CD_WR_24X, "24X" },
	{ SILENT_CD_WR_16X, "16X" },
	{ SILENT_CD_WR_8X,   "8X" },
	{ SILENT_CD_WR_4X,   "4X" },
	{ 0xFF, "max" }
};

const int SILENT_CD_RD_48X = 0x05;
const int SILENT_CD_RD_40X = 0x04;
const int SILENT_CD_RD_32X = 0x03;
const int SILENT_CD_RD_24X = 0x02;
const int SILENT_CD_RD_8X  = 0x01;
const int SILENT_CD_RD_4X  = 0x00;

const REC silent_cd_rd_tbl[]={
	{ SILENT_CD_RD_48X, "48X" },
	{ SILENT_CD_RD_40X, "40X" },
	{ SILENT_CD_RD_32X, "32X" },
	{ SILENT_CD_RD_24X, "24X" },
	{ SILENT_CD_RD_8X,   "8X" },
	{ SILENT_CD_RD_4X,   "4X" },
	{ 0xFF, "max" }
};

const int SILENT_DVD_WR_16X = 0x06;
const int SILENT_DVD_WR_12X = 0x05;
const int SILENT_DVD_WR_8X  = 0x03;
const int SILENT_DVD_WR_6X  = 0x01;
const int SILENT_DVD_WR_4X  = 0x00;

const REC silent_dvd_wr_tbl[]={
	{ SILENT_DVD_WR_16X, "16X" },
	{ SILENT_DVD_WR_12X, "12X" },
	{ SILENT_DVD_WR_8X,   "8X" },
	{ SILENT_DVD_WR_6X,   "6X" },
	{ SILENT_DVD_WR_4X,   "4X" },
	{ 0xFF, "max" }
};

const int SILENT_DVD_RD_16X = 0x04;
const int SILENT_DVD_RD_12X = 0x03;
const int SILENT_DVD_RD_8X  = 0x02;
const int SILENT_DVD_RD_5X  = 0x01;
const int SILENT_DVD_RD_2X  = 0x00;

const REC silent_dvd_rd_tbl[]={
	{ SILENT_DVD_RD_16X, "16X" },
	{ SILENT_DVD_RD_12X, "12X" },
	{ SILENT_DVD_RD_8X,   "8X" },
	{ SILENT_DVD_RD_5X,   "5X" },
	{ SILENT_DVD_RD_2X,   "2X" },
	{ 0xFF, "max" }
};

const int SILENT_CD          = 0x01;
const int SILENT_DVD         = 0x05;

const int SILENT_ACCESS_FAST = 0x00;
const int SILENT_ACCESS_SLOW = 0x02;

// PX-716+ Autostrategy definitions
const int AS_OFF	= 0x00;
const int AS_AUTO	= 0x01;
// PX-755+ AS extentions
const int AS_FORCED	= 0x04;
const int AS_ON		= 0x08;

const int ASDB_ENABLE	= 0x01;
const int ASDB_DISABLE	= 0x00;
const int ASDB_DELETE	= 0xFF;

const int ASDB_CRE_QUICK   = 0x01;
const int ASDB_CRE_FULL    = 0x05;
const int ASDB_REPLACE     = 0x00;
const int ASDB_ADD         = 0x02;

const int AS_MEDIACK_QUICK = 0x11;
const int AS_MEDIACK_ADV   = 0x31;

const int PLEXERASER_QUICK = 0x11;
const int PLEXERASER_FULL  = 0x31;

extern int plextor_get_TLA(drive_info* drive);
// PoweRec
extern int plextor_set_powerec(drive_info* drive);
extern int plextor_get_powerec(drive_info* drive);
// silent mode
extern void plextor_print_silentmode_state(drive_info* drive);
extern int plextor_get_silentmode(drive_info* drive);
extern int plextor_set_silentmode_tray(drive_info* drive, int disc_type, int permanent);
extern int plextor_set_silentmode_disc(drive_info* drive, int disc_type, int permanent);
extern int plextor_set_silentmode_disable(drive_info* drive, int permanent);
// GigaRec
extern void print_gigarec_value(drive_info* drive);
extern int plextor_set_gigarec(drive_info* drive);
extern int plextor_get_gigarec(drive_info* drive);
// VariRec
extern void print_varirec(drive_info* drive, int disc_type);
extern int plextor_set_varirec(drive_info* drive, int disc_type);
extern int plextor_get_varirec(drive_info* drive, int disc_type);
// SpeedRead
extern void print_speedread_state(drive_info* drive);
extern int plextor_set_speedread(drive_info* drive, int state);
extern int plextor_get_speedread(drive_info* drive);
// Hide-CDR / SingleSession
extern void print_hcdr_state(drive_info* drive);
extern void print_sss_state(drive_info* drive);
extern int plextor_get_hidecdr_singlesession(drive_info* drive);
extern int plextor_set_hidecdr(drive_info* drive, int state);
extern int plextor_set_singlesession(drive_info* drive, int state);
// Bitsetting
extern int plextor_get_bitset(drive_info* drive, int disc_type);
extern int plextor_set_bitset(drive_info* drive, int disc_type);
// Simulation on DVD+
extern int plextor_get_testwrite_dvdplus(drive_info* drive);
extern int plextor_set_testwrite_dvdplus(drive_info* drive);
// PlexEraser
extern int plextor_plexeraser(drive_info* drive);
// AUTOSTRATEGY
// get/set autostrategy state
extern int plextor_print_autostrategy_state(drive_info* drive);
extern int plextor_get_autostrategy(drive_info* drive);
extern int plextor_set_autostrategy(drive_info* drive);
// read autostrategy database
extern int plextor_get_autostrategy_db_entry_count(drive_info* drive);
extern int plextor_get_autostrategy_db(drive_info* drive);//, void* database);
// use action = ASDB_ENABLE/DISABLE/DELETE
extern int plextor_modify_autostrategy_db(drive_info* drive, int index, int action);
extern int plextor_create_strategy(drive_info* drive, int mode);
extern int plextor_media_check(drive_info* drive, int mode);
// PX-755/760 Auth
extern int px755_get_auth_code(drive_info* drive,char* auth_code);
extern int px755_send_auth_code(drive_info* drive,char* auth_code);
extern int px755_clear_auth_status(drive_info* drive);
extern int px755_calc_auth_code(char* auth_code);

#endif //__PLEXTOR_FEATURES
