/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */


#ifndef __qpxtool_mmc
#define __qpxtool_mmc

#include <qpx_const.h>
#include <transport.h>
#include <common_functions.h>

#ifndef __USE_QTHREAD
#include <pthread.h>
#endif

typedef char	str_vendor[9];
typedef char	str_dev[16];
typedef char	str_if[16];
typedef char	str_lo[64];
typedef char	str8[8];

const unsigned int rpc_phase_max=2;
const	str8	rpc_phase[rpc_phase_max+1]={
	"n/a",
	"RPC-I",
	"RPC-II"
};

const unsigned int spindowns=16;
const	str8	spindown_tbl[spindowns+1]={
	"vendor","125ms","250ms","500ms","1s","2s","4s","8s",
	"16s","32s","1min","2min","4min","8min","16min","32min",
	"unknown"
};

const unsigned int iface_id_max=8;
const	str_if	iface_list[iface_id_max+2]={
	"Unspecified\0",
	"SCSI\0",
	"ATAPI\0",
	"IEEE1394\0",
	"IEEE1394A\0",
	"Fibre Channel\0",
	"IEEE1394B\0",
	"Serial ATAPI\0",
	"USB (1.1/2.0)\0",
	"<Unknown>\0",
};

const	str_if	disc_status_list[4]= {
	"Blank",
	"Incomplete",
	"Finalized",
	"Random Access",
//	"[READ_DISK_INFO error]",
};

const	str_if	session_status_list[4]= {
	"Empty",
	"Incomplete",
	"Reserved",
	"Complete",
//	"[READ_DISK_INFO error]",
};

const	str_lo	loader_list[8]={
	"Caddy/Slot",
	"Tray",
	"Pop-up",
	"<reserved>",
	"Changer (individual discs)",
	"Changer (cartridge mechanism)",
	"<reserved>",
	"<reserved>"
};

const   str8 track_mode[16]={
	"Blank","<1>","Audio","<3>",
	"Data","<5>","<6>","Packet",
	"<8>","<9>","<10>","<11>",
	"<12>","<13>","<14>","<15>"
};

const   str8 data_mode[16]={
	"<0>","Mode1","Mode2","<3>",
	"<4>","<5>","<6>","<7>",
	"<8>","<9>","<10>","<11>",
	"<12>","<13>","<14>",""
};

#if defined(__linux)
const	int	_devcnt=58;
const	str_dev _devtbl[_devcnt]={
		"/dev/hda\0", "/dev/hdb\0", "/dev/hdc\0", "/dev/hdd\0",
		"/dev/hde\0", "/dev/hdf\0", "/dev/hdg\0", "/dev/hdh\0",
		"/dev/hdi\0", "/dev/hdj\0", "/dev/hdk\0", "/dev/hdl\0",
		"/dev/hdm\0", "/dev/hdn\0", "/dev/hdo\0", "/dev/hdp\0",
		"/dev/hdq\0", "/dev/hdr\0", "/dev/hds\0", "/dev/hdt\0",
		"/dev/hdu\0", "/dev/hdv\0", "/dev/hdw\0", "/dev/hdx\0",
		"/dev/hdy\0", "/dev/hdz\0",

		"/dev/sr0\0", "/dev/sr1\0", "/dev/sr2\0", "/dev/sr3\0",
		"/dev/sr4\0", "/dev/sr5\0", "/dev/sr6\0", "/dev/sr7\0",
		"/dev/sr8\0", "/dev/sr9\0", "/dev/sr10\0","/dev/sr11\0",
		"/dev/sr12\0","/dev/sr13\0","/dev/sr14\0","/dev/sr15\0",

		"/dev/sr16\0","/dev/sr17\0","/dev/sr18\0","/dev/sr19\0",
		"/dev/sr20\0","/dev/sr21\0","/dev/sr22\0","/dev/sr23\0",
		"/dev/sr24\0","/dev/sr25\0","/dev/sr26\0","/dev/sr27\0",
		"/dev/sr28\0","/dev/sr29\0","/dev/sr30\0","/dev/sr31\0",
};
#else
const	int	_devcnt=64;
const	str_dev _devtbl[_devcnt]={
		"/dev/acd0\0","/dev/acd1\0","/dev/acd2\0","/dev/acd3\0",
		"/dev/acd4\0","/dev/acd5\0","/dev/acd6\0","/dev/acd7\0",
		"/dev/acd8\0","/dev/acd9\0","/dev/acd10\0","/dev/acd11\0",
		"/dev/acd12\0","/dev/acd13\0","/dev/acd14\0","/dev/acd15\0",

		"/dev/acd16\0","/dev/acd17\0","/dev/acd18\0","/dev/acd19\0",
		"/dev/acd20\0","/dev/acd21\0","/dev/acd22\0","/dev/acd23\0",
		"/dev/acd24\0","/dev/acd25\0","/dev/acd26\0","/dev/acd27\0",
		"/dev/acd28\0","/dev/acd29\0","/dev/acd30\0","/dev/acd31\0",

		"/dev/cd0\0", "/dev/cd1\0", "/dev/cd2\0","/dev/cd3\0",
		"/dev/cd4\0", "/dev/cd5\0", "/dev/cd6\0","/dev/cd7\0",
		"/dev/cd8\0", "/dev/cd9\0", "/dev/cd10\0","/dev/cd11\0",
		"/dev/cd12\0","/dev/cd13\0","/dev/cd14\0","/dev/cd15\0",

		"/dev/cd16\0","/dev/cd17\0","/dev/cd18\0","/dev/cd19\0",
		"/dev/cd20\0","/dev/cd21\0","/dev/cd22\0","/dev/cd23\0",
		"/dev/cd24\0","/dev/cd25\0","/dev/cd26\0","/dev/cd27\0",
		"/dev/cd28\0","/dev/cd29\0","/dev/cd30\0","/dev/cd31\0",
};
#endif

const int ERR_NO_DEV   = 0x0002;
const int ERR_NO_SCSI  = 0x0003;
const int ERR_NO_MMC   = 0x0004;

const unsigned short FEATURE_PROFILE_LIST		=0x0000;
const unsigned short FEATURE_CORE			= 0x001;
const unsigned short FEATURE_MORPHING			= 0x002;
const unsigned short FEATURE_REMOVABLE_MEDIA		= 0x003;
const unsigned short FEATURE_WRITE_PROTECT		= 0x004;
const unsigned short FEATURE_RANDOM_READABLE		= 0x010;
const unsigned short FEATURE_MULTI_READ			= 0x01D;
const unsigned short FEATURE_CD_READ			= 0x01E;
const unsigned short FEATURE_DVD_READ			= 0x01F;
const unsigned short FEATURE_RANDOM_WRITABLE		= 0x020;
const unsigned short FEATURE_INCREMENTAL_STREAMING_WRITABLE = 0x021;
const unsigned short FEATURE_SECTOR_ERASABLE		= 0x022;
const unsigned short FEATURE_FORMATTABLE		= 0x023;
const unsigned short FEATURE_DEFECT_MANAGEMENT		= 0x024;
const unsigned short FEATURE_WRITE_ONCE			= 0x025;
const unsigned short FEATURE_RESTRICTED_OVERWRITE	= 0x026;
const unsigned short FEATURE_CD_RW_CAV_WRITE		= 0x027;
const unsigned short FEATURE_MRW			= 0x028;
const unsigned short FEATURE_ENHANCED_DEFECT_REPORTING	= 0x029;
const unsigned short FEATURE_DVD_PLUS_RW		= 0x02A;
const unsigned short FEATURE_DVD_PLUS_R			= 0x02B;
const unsigned short FEATURE_RIGID_RESTRICTED_OVERWRITE	= 0x02C;
const unsigned short FEATURE_CD_TRACK_AT_ONCE		= 0x02D;
const unsigned short FEATURE_CD_MASTERING		= 0x02E;
const unsigned short FEATURE_DVD_R_RW_WRITE		= 0x02F;
const unsigned short FEATURE_DDCD_READ			= 0x030;
const unsigned short FEATURE_DDCD_R_WRITE		= 0x031;
const unsigned short FEATURE_DDCD_RW_WRITE		= 0x032;
const unsigned short FEATURE_LAYER_JUMP_RECORDING	= 0x033;
const unsigned short FEATURE_CD_RW_MEDIA_WRITE_SUPPORT 	= 0x037;
const unsigned short FEATURE_DVD_PLUS_R_DOUBLE_LAYER	= 0x03B;
const unsigned short FEATURE_BD_READ		= 0x040;
const unsigned short FEATURE_BD_WRITE		= 0x041;
//const unsigned short FEATURE_BD_R_POW		= 0x042 ????;
const unsigned short FEATURE_POWER_MANAGEMENT		= 0x100;
const unsigned short FEATURE_SMART			= 0x101;
const unsigned short FEATURE_EMBEDDED_CHANGER		= 0x102;
const unsigned short FEATURE_CD_AUDIO_ANALOG_PLAY	= 0x103;
const unsigned short FEATURE_MICROCODE_UPGRADE		= 0x104;
const unsigned short FEATURE_TIMEOUT			= 0x105;
const unsigned short FEATURE_DVD_CSS			= 0x106;
const unsigned short FEATURE_REAL_TIME_STREAMING	= 0x107;
const unsigned short FEATURE_LOGICAL_UNIT_SERIAL_NUMBER	= 0x108;
const unsigned short FEATURE_MEDIA_SERIAL_NUMBER	= 0x109;
const unsigned short FEATURE_DISC_CONTROL_BLOCKS	= 0x10A;
const unsigned short FEATURE_DVD_CPRM			= 0x10B;
const unsigned short FEATURE_FIRMWARE_DATE		= 0x10C;

const char MMC_TEST_UNIT_READY		= 0x00;
const char MMC_REQUEST_SENSE		= 0x03;
const char MMC_FORMAT_UNIT		= 0x04;
const char MMC_INQUIRY			= 0x12;
const char MMC_MODE_SELECT6		= 0x15;
const char MMC_MODE_SENSE6		= 0x1A;
const char MMC_START_STOP_UNIT		= 0x1B;
const char MMC_PREVENT_ALLOW_MEDIUM_REMIVAL	= 0x1E;
const char MMC_READ_FORMAT_CAPACITIES	= 0x23;
const char MMC_READ_RECORDED_CAPACITY	= 0x25;
const char MMC_READ			= 0x28;
const char MMC_WRITE			= 0x2A;
const char MMC_SEEK			= 0x2B;
const char MMC_WRITE_AND_VERIFY		= 0x2E;
const char MMC_VERIFY			= 0x2F;
const char MMC_SYNC_CACHE		= 0x35;
const char MMC_READ_SUB_CHANNEL		= 0x42;
const char MMC_READ_TOC_PMA_ATIP	= 0x43;
const char MMC_READ_HEADER		= 0x44;
const char MMC_PLAY_AUDIO		= 0x45;
const char MMC_GET_CONFIGURATION	= 0x46;
const char MMC_PLAY_AUDIO_MSF		= 0x47;
const char MMC_GET_EVENT_STATUS_NOTIFICATION	= 0x4A;
const char MMC_PAUSE_RESUME		= 0x4B;
const char MMC_STOP_PLAY_SCAN		= 0x4E;
const char MMC_READ_DISC_INFORMATION	= 0x51;
const char MMC_READ_TRACK_INFORMATION	= 0x52;
const char MMC_RESERVE_TRACK		= 0x53;
const char MMC_SEND_OPC_INFORMATION	= 0x54;
const char MMC_MODE_SELECT10		= 0x55;
const char MMC_REPAIR_TRACK		= 0x58;
const char MMC_READ_MASTER_CUE		= 0x59;
const char MMC_MODE_SENSE10		= 0x5A;
const char MMC_CLOSE_TRACK_SESSION	= 0x5B;
const char MMC_READ_BUFFER_CAPACITY	= 0x5C;
const char MMC_SEND_CUE_SHEET		= 0x5D;
const char MMC_BLANK			= 0xA1;
const char MMC_SEND_EVENT		= 0xA2;
const char MMC_SEND_KEY			= 0xA3;
const char MMC_REPORT_KEY		= 0xA4;
const char MMC_PLAY_AUDIO_12		= 0xA5;
const char MMC_LOAD_UNLOAD		= 0xA6;
const char MMC_SET_READ_AHEAD		= 0xA7;
const char MMC_READ_DVD			= 0xA8;
const char MMC_GET_PERFORMANCE		= 0xAC;
const char MMC_READ_DVD_STRUCTURE	= 0xAD;
const char MMC_SET_STREAMING		= 0xB6;
const char MMC_READ_CD_MSF		= 0xB9;
const char MMC_SCAN			= 0xBA;
const char MMC_SET_SPEED		= 0xBB;
const char MMC_PLAY_CD			= 0xBC;
const char MMC_MECHANISM_STATUS		= 0xBD;
const char MMC_READ_CD			= 0xBE;

const char CMD_PLEX_GET_AUTH		= 0xD4;
const char CMD_PLEX_SEND_AUTH		= 0xD5;

const char CMD_PLEX_ERASER		= 0xE3;
const char CMD_PLEX_AS_RD		= 0xE4;
const char CMD_PLEX_AS_WR		= 0xE5;

const char CMD_PLEX_MODE		= 0xE9;
const char CMP_PLEX_QCHECK		= 0xEA;
const char CMD_PLEX_PREC_SPD		= 0xEB;
const char CMD_PLEX_MODE2		= 0xED;

const char CMD_PLEX_EEPROM_READ		= 0xF1;

const char CMD_PLEX_SCAN_TA_FETE	= 0xF3;
const char CMD_PLEX_FETE_READOUT	= 0xF5;

/*const char MMC_	= 0x00;*/

const int PROFILE_NONE		= 0x0000;
const int PROFILE_NON_REMOVABLE	= 0x0001;
const int PROFILE_REMOVABLE	= 0x0002;
const int PROFILE_MOPTIC_E	= 0x0003;
const int PROFILE_OPTIC_WO	= 0x0004;
const int PROFILE_AS_MO		= 0x0005;
const int PROFILE_CD_ROM	= 0x0008;
const int PROFILE_CD_R		= 0x0009;
const int PROFILE_CD_RW		= 0x000A;
const int PROFILE_DVD_ROM	= 0x0010;
const int PROFILE_DVD_R_SEQ	= 0x0011;
const int PROFILE_DVD_RAM	= 0x0012;
const int PROFILE_DVD_RW_RESTOV	= 0x0013;
const int PROFILE_DVD_RW_SEQ	= 0x0014;
const int PROFILE_DVD_R_DL_SEQ	= 0x0015;
const int PROFILE_DVD_R_DL_JUMP	= 0x0016;
const int PROFILE_DVD_PLUS_RW	= 0x001A;
const int PROFILE_DVD_PLUS_R	= 0x001B;
const int PROFILE_DVD_PLUS_R_DL	= 0x002B;
const int PROFILE_DDCD_ROM	= 0x0020;
const int PROFILE_DDCD_R	= 0x0021;
const int PROFILE_DDCD_RW	= 0x0022;
const int PROFILE_NO_PROFILE	= 0xFFFF;

const int DISC_NODISC	  = 0x00000000;

const int DISC_CDROM      = 0x00000001;
const int DISC_CDR        = 0x00000002;
const int DISC_CDRW       = 0x00000004;
const int DISC_CD	  = DISC_CDROM | DISC_CDR | DISC_CDRW;

const int DISC_CDRWSUBT   = 0x70000000;
const int DISC_CDRWMS     = 0x10000000;
const int DISC_CDRWHS     = 0x20000000;
const int DISC_CDRWUS     = 0x30000000;
const int DISC_CDRWUSP    = 0x40000000;

const int DISC_DVDROM     = 0x00000008;
const int DISC_DVDRAM     = 0x00000010;
const int DISC_DVDminusR  = 0x00000020;
const int DISC_DVDminusRWS= 0x00000040;
const int DISC_DVDminusRWR= 0x00000080;
const int DISC_DVDminusRDL= 0x00000100;
const int DISC_DVDminusRDLJ=0x00000200;

const int DISC_DVDplusRW  = 0x00000400;
const int DISC_DVDplusR   = 0x00000800;
const int DISC_DVDplusRDL = 0x00001000;

const int DISC_DVDminus   = DISC_DVDminusR | DISC_DVDminusRWS | DISC_DVDminusRWR | DISC_DVDminusRDL | DISC_DVDminusRDLJ;
const int DISC_DVDplus    = DISC_DVDplusRW | DISC_DVDplusR | DISC_DVDplusRDL;
const int DISC_DVD	  = DISC_DVDROM | DISC_DVDRAM | DISC_DVDminus | DISC_DVDplus;

const int DISC_DDCD_ROM   = 0x00002000;
const int DISC_DDCD_R     = 0x00004000;
const int DISC_DDCD_RW    = 0x00008000;
const int DISC_DDCD	  = DISC_DDCD_ROM | DISC_DDCD_R | DISC_DDCD_RW;

const int DISC_UN	  = 0x80000000;

const	str_dev _book_type_tbl[16]={
		"DVD-ROM", "DVD-RAM", "DVD-R ", "DVD-RW",
		"unknown","unknown","unknown","unknown",
		"unknown", "DVD+RW", "DVD+R","unknown",
		"unknown","unknown", "DVD+R DL", "unknown"
};

const int BOOK_DVD_ROM	  = 0x00;
const int BOOK_DVD_RAM    = 0x01;
const int BOOK_DVD_R      = 0x02;
const int BOOK_DVD_RW     = 0x03;
const int BOOK_DVD_PRW    = 0x09;
const int BOOK_DVD_PR     = 0x0A;
const int BOOK_DVD_PR_DL  = 0x0E;

const int COMMAND_FAILED  = -0x01;

const int Media_BLANK     = 0x80;
const int Media_NOTBLANK  = 0x7F;
const int Media_NoMedia   = 0x00;
const int Media_CD        = 0x01;
const int Media_DVD	  = 0x02;

const int CAP_REMOVABLE_MEDIA		= 0x00000001;
const int CAP_MORPHING			= 0x00000002;
const int CAP_EMBEDDED_CHANGER		= 0x00000004;
const int CAP_MICROCODE_UPGRADE		= 0x00000008;
const int CAP_SMART			= 0x00000010;
const int CAP_REAL_TIME_STREAMING	= 0x00000020;
const int CAP_POWER_MANAGEMENT		= 0x00000040;
const int CAP_DEFECT_MANAGEMENT		= 0x00000080;
const int CAP_DVD_CSS			= 0x00000100;
const int CAP_DVD_CPRM			= 0x00000200;
const int CAP_C2			= 0x00000400;
const int CAP_CD_TEXT			= 0x00000800;
const int CAP_CD_AUDIO			= 0x00001000;
const int CAP_DAE			= 0x00002000;
const int CAP_ACCURATE_STREAM		= 0x00004000;

const int CAP_COMPOSITE			= 0x00010000;
const int CAP_DIGITAL_PORT_1		= 0x00020000;
const int CAP_DIGITAL_PORT_2		= 0x00040000;
const int CAP_MULTISESSION		= 0x00080000;
const int CAP_MODE2_FORM1		= 0x00100000;
const int CAP_MODE2_FORM2		= 0x00200000;
const int CAP_TEST_WRITE		= 0x00400000;
const int CAP_READ_BAR_CODE		= 0x00800000;
const int CAP_UPC			= 0x01000000;
const int CAP_ISRC			= 0x02000000;
const int CAP_SIDE_CHANGE		= 0x04000000;
const int CAP_LOCK			= 0x08000000;
const int CAP_EJECT			= 0x10000000;

//const int CAP_		= 0x00000000;

const int CAP_SET_CD_SPEED		= 0x80000000;
const int NCAP_SET_CD_SPEED		= 0x7FFFFFFF;

//						 RW
const int DEVICE_CD_ROM		= 0x00000001; // +
const int DEVICE_CD_R		= 0x00000002; // ++
const int DEVICE_CD_RW		= 0x00000004; // ++
const int DEVICE_DVD_ROM	= 0x00000008; // +
const int DEVICE_DVD_RAM	= 0x00000010; // ++
const int DEVICE_DVD_R		= 0x00000020; // ++
const int DEVICE_DVD_RW		= 0x00000040; // +-
const int DEVICE_DVD_R_DL	= 0x00000080; // +-
const int DEVICE_DVD_PLUS_R	= 0x00000100; // ++
const int DEVICE_DVD_PLUS_RW	= 0x00000200; // ++
const int DEVICE_DVD_PLUS_R_DL	= 0x00000400; // ++
const int DEVICE_DVD		= DEVICE_DVD_ROM | DEVICE_DVD_RAM | DEVICE_DVD_R | DEVICE_DVD_RW | DEVICE_DVD_R_DL
				| DEVICE_DVD_PLUS_R | DEVICE_DVD_PLUS_RW | DEVICE_DVD_PLUS_R_DL;
const int DEVICE_MRW		= 0x00000800; // ++
const int DEVICE_DDCD_R		= 0x00001000; // ++
const int DEVICE_DDCD_RW	= 0x00002000; // ++
const int DEVICE_BD_ROM		= 0x00004000; // -
const int DEVICE_BD_R		= 0x00008000; // --
const int DEVICE_BD_RE		= 0x00010000; // --


const int ERR_INVALID_OPCODE	= 0x00052000;
const int ERR_NO_MEDIUM		= 0x00023A00;
const int ERR_NO_ERROR		= 0x00000000;

// **** Vendors definition 
const int WR_GENERIC      = 0x00000000;
const int WR_PLEXTOR      = 0x00000001;
const int WR_PIONEER      = 0x00000002;
const int WR_NEC          = 0x00000003;
const int WR_LITEON       = 0x00000004;
const int RD_BENQ         = 0x00000005;
const int WR_BENQ         = 0x00000006;

#define VENDORS 6
const str_vendor vendor[VENDORS+1] = {
	"Generic ",
	"PLEXTOR ",
	"PIONEER ",
	"_NEC    ",
	"LITE-ON ",
	"BENQ ROM",
	"BENQ    "
};

// Vendor-specififc features
const int PX_POWEREC	= 0x00000001;
const int PX_GIGAREC	= 0x00000002;
const int PX_VARIREC_CD	= 0x00000004;
const int PX_VARIREC_DVD= 0x00000008;
const int PX_HCDRSS	= 0x00000010;
const int PX_SPDREAD	= 0x00000020;
const int PX_SECUREC	= 0x00000040;
const int PX_SILENT	= 0x00000080;
const int PX_ASTRATEGY	= 0x00000100;
const int PX_BITSET_R	= 0x00000200;
const int PX_BITSET_RDL	= 0x00000400;
const int PX_SIMUL_PLUS	= 0x00000800;
const int PX_ERASER     = 0x00001000;

// Plextor devices
const int PLEXTOR_OLD     = 0x00000001;
const int PLEXTOR_PREMIUM = 0x00000002;
const int PLEXTOR_708A2   = 0x00000003;
const int PLEXTOR_712     = 0x00000004;
const int PLEXTOR_716     = 0x00000005;
//const int PLEXTOR_755     = 0x00000006;
const int PLEXTOR_760     = 0x00000006;

//Pioneer devices
const int PIO_OLD	  = 0x00000001;
const int PIO_DVR_106	  = 0x00000002;
const int PIO_DVR_107	  = 0x00000003;
const int PIO_DVR_108	  = 0x00000004;
const int PIO_DVR_109	  = 0x00000005;
const int PIO_DVR_110	  = 0x00000006;
const int PIO_DVR_111	  = 0x00000007;

//Nec devices
const int NEC_OLD	  = 0x00000001;
const int NEC_3520	  = 0x00000002;
const int NEC_3530	  = 0x00000003;
const int NEC_3540	  = 0x00000004;
const int NEC_4550	  = 0x00000005;
const int NEC_4570	  = 0x00000006;
const int NEC_4650	  = 0x00000007;

//LiteOn devices
const int LTN_OLD	  = 0x00000001;
const int LTN_LTR_52327	  = 0x00000002;
const int LTN_SOHW_811S	  = 0x00000003;
const int LTN_SOHW_812S	  = 0x00000004;
const int LTN_SOHW_832S	  = 0x00000005;
const int LTN_SOHW_1653S  = 0x00000006;
const int LTN_SOHW_1673S  = 0x00000007;
const int LTN_SOHW_1693S  = 0x00000008;
const int LTN_SHW_1635S   = 0x00000009;

//BenQ devices
const int BENQ_OLD	  = 0x00000001;
const int BENQ_DV1650V	  = 0x00000002;
const int BENQ_DW1620	  = 0x00000003;
const int BENQ_DW1640	  = 0x00000004;
//
// **** end of devices list

const int CHK_RD	= 0x00000001;
const int CHK_WR	= 0x00000002;
const int CHK_CX	= 0x00000004;
const int CHK_JB_CD	= 0x00000008;
const int CHK_PIE	= 0x00000010;
const int CHK_PIF	= 0x00000020;
const int CHK_POE	= 0x00000040;
const int CHK_POF	= 0x00000080;
const int CHK_PI = CHK_PIE | CHK_PIF;
const int CHK_PO = CHK_POE | CHK_POF;
const int CHK_JB_DVD	= 0x00000100;
const int CHK_TA	= 0x00000200;
const int CHK_FETE	= 0x00000400;

typedef struct{
	msf	lin;
	char*	name;
} manuf;

typedef struct{
	int	n;
	int	session;
	int	track_mode;
	int	data_mode;
	int	start;
	msf	msf_start;
	int	next_writable;
	msf	msf_next;
	int	free;
	int	packet_size;
	int	size;
	msf	time;
	int	last_recorded;
	msf	msf_last;
	int	end;
	msf	msf_end;
}track_info;

typedef struct{
	int	test;
	int	idx;
	int	lba;
	int	block,blocks;
	float	speed_kb;
	float	speed_x;
	int	speed_h;
	int	err_total;
	int	err_max;
	int	err_cur;
	float	err_avg;
	int	pit;
	int	land;
	float	jmax;
	float	jmin;
	float	bmax;
	float	bmin;
	long	time;
	int	nte, ote;
	int	nfe, ofe;
	int	ext;
}block_data;

typedef	struct {
	char	MID[48];	// MediaID for DVD, manufacturer for CD
	int 	disc_type;	// CD/DVD subtype
	int 	book_type;	// Book type (for DVD)
	int 	layers;		// Layers num (for DVD)
	int	sectsize;
	int	capacity;	// Recorded capacity in sectors
	msf	capacity_msf;
	int	capacity_free;	// Free sectors
	msf	capacity_free_msf;
	int	capacity_total;	// Total sectors
	msf	capacity_total_msf;
	int	last_lead_out;
	int	dstatus;	// Empty/Apeendable/Complete
	int	sstatus;
	int	sessions;
	int	tracks;
	int	erasable;
	char	writer[0x3F];
} media_info;

const int speed_tbl_size=64;
const int STATUS_OPEN		=0x0001;
const int STATUS_MEDIA_PRESENT	=0x0002;
const int STATUS_LOCK		=0x0004;

typedef struct {
	int	status;
	int	interval;
	int	tests;
	unsigned short	spindown_idx;
	unsigned int	speed_idx;
	int	speed_mult;
	int	speed_tbl[speed_tbl_size];
	int	speed_tbl_kb[speed_tbl_size];
	int	wr_speed_tbl[speed_tbl_size];
	int	wr_speed_tbl_kb[speed_tbl_size];
	int	scan_speed_cd;
	int	scan_speed_dvd;
	int 	read_speed_kb;
	int 	read_speed_cd;
	int 	read_speed_dvd;
	int 	max_read_speed_kb;
	int 	max_read_speed_cd;
	int 	max_read_speed_dvd;
	int 	max_write_speed_kb;
	int 	max_write_speed_cd;
	int 	max_write_speed_dvd;
	int 	write_speed_kb;
	int 	write_speed_cd;
	int 	write_speed_dvd;
} drive_parms;

typedef struct {
	int	lba_s;
	int	spd_s;
	int	lba_e;
	int	spd_e;
} perf_desc;

struct _Exx {
	int*	BLER;
	int*	E11;
	int*	E21;
	int*	E31;
	int*	E12;
	int*	E22;
	int*	E32;
	int	tot[7];
	int	max[7];
	float	avg[7];
	int	color[7];
};

typedef struct
{
	char	type;
	char	len;
	char	state;
	char	read_speed;
	char	write_speed;
	char	access_speed;
	char	eject_speed;
	char	load_speed;
} plex_silent;

typedef struct {
	unsigned char	number;
	unsigned char	type;  // 0x25 == -R, 0xA1 == +R
	char            MID[12];
	unsigned char	crap2;
	unsigned char	enabled;
	char		counter[2];
	unsigned char	speed;
	unsigned char	crap3[13];
} as_entry;

typedef struct {
	char		sizeb[2];
	char		crap1[4];
	char		dbcnt;
	char		entry_size;
	as_entry	entry[31];
	char		state;
	int		size;
} plex_as;

typedef struct {
	char	gigarec;	// Current GigaRec value
	char	gigarec_disc;	// GigaRec value of inserted CD
	char	powerec_state;	// Current PoweRec state
	unsigned short	powerec_spd;	// Current PoweRec recomended speed
	char	varirec_state_cd;	// Current VariRec CD state
	char	varirec_pwr_cd;		// Current VariRec CD LaserPower
	char	varirec_str_cd;		// Current VariRec CD Strategy
	char	varirec_state_dvd;	// Current VariRec DVD state
	char	varirec_pwr_dvd;	// Current VariRec DVD LaserPower
	char	varirec_str_dvd;	// Current VariRec DVD Strategy
	char	hcdr;		// Hide CD-R State
	char	sss;		// SingleSession State
	char	spdread;	// SpeedRead
	char	testwrite_dvdplus; // Simulation on DVD+R(W)
	char	plexeraser;	// PlexEraser mode
} plex_features;

typedef struct {
	unsigned char phase;
	unsigned char region;
	unsigned char ch_u;
	unsigned char ch_v;
} rpc_state;

class drive_info {
public:
	drive_info();
	drive_info(char* _device);
	~drive_info();

#ifndef __USE_QTHREAD
	pthread_t*	test_thread_id;
#endif
//	bool	isBusy();
//	bool	lock();
//	bool	unlock();
//	void	wait_free();

	Scsi_Command	cmd;
	void	cmd_clear();
	int	err;
	
	char*	device;		// device adress
	char	ven[9];		// vendor string
	int	ven_ID;		// drive vendor ID
	char	dev[17];	// model string
	int	dev_ID;		// model ID
	char	fw[5];		// FirmWare
	char	serial[17];	// drive serial#
	char	TLA[5];		// TLA# - only rof Plextor PX-712, PX-716

	int	z;

	unsigned int	buffer_size;	 // drive buffer size
	unsigned int	capabilities;	 // common capabilities
	unsigned int	rd_capabilities; // read capabilities
	unsigned int	wr_capabilities; // write capabilities
	unsigned int	ven_features;	// vendor-specific features
	unsigned int	chk_features;	// media check features

	unsigned int	iface_id;
	str_if		iface;
	unsigned int	loader_id;

	short		book_plus_r;
	short		book_plus_rw;
	short		book_plus_rdl;

	plex_features	plextor;
	plex_as		astrategy;
	plex_silent	plextor_silent;
	media_info	media;
	drive_parms	parms;
	perf_desc	perf;

	char*		rd_buf;
	unsigned char*	ATIP;
	int		ATIP_len;
	char		mmc;

	rpc_state	rpc;
private:
	bool	busy;
};

const int drive_info_size=sizeof(drive_info);

extern int inquiry(drive_info* drive);
extern int test_unit_ready(drive_info* drive);
extern int request_sense(drive_info* drive, char add);
extern void drivecpy(drive_info* dst, drive_info* src);
extern void read_rpc_state(drive_info* drive);
extern void read_disc_regions(drive_info* drive);
extern void SpinUpCD(drive_info* drive);
extern void SpinUpDVD(drive_info* drive);
extern int get_configuration(drive_info* drive, int feature_number, char* data_length, int* current);
extern void detect_iface(drive_info* drive);
extern void detect_capabilities(drive_info* drive);
extern int get_profiles(drive_info* drive);
extern int read_atip(drive_info* drive);
extern int read_track_info(drive_info* drive, track_info* track);
extern int read_capacity(drive_info* drive);
extern int read_free(drive_info* drive);
extern int read_disc_information(drive_info* drive);
extern int convert_to_ID (drive_info* drive);
extern int determine_cd_type(drive_info* drive);
//extern int determine_cdrw_subtype(drive_info* drive);
extern int read_mediaid_dvd(drive_info* drive);
extern int determine_disc_type(drive_info* drive);
extern int mode_sense(drive_info* drive, int page, int page_control, int dest_len);
extern int mode_select(drive_info* drive, int dest_len);
extern int get_spindown(drive_info* drive);
extern int set_spindown(drive_info* drive);
extern int get_performance(drive_info* drive);
extern int get_write_speed(drive_info* drive);
extern int get_write_speed_tbl(drive_info* drive);
extern int get_read_speed(drive_info* drive);
extern int set_streaming(drive_info* drive);
extern int set_read_speed(drive_info* drive);
extern int get_media_status(drive_info* drive);
extern int load_eject(drive_info* drive, bool load);
extern int get_lock(drive_info* drive);
extern int set_lock(drive_info* drive);

extern int play_audio_msf(drive_info* drive, int beg, int end);
extern int play_audio(drive_info* drive, int beg, short int len);
extern int read_cd(drive_info* drive, int lba, int sector_count);
extern int read(drive_info* drive, int lba, int sector_count);
extern int read_one_ecc_block(drive_info* drive, int lba);
extern int get_drive_serial_number(drive_info* drive);
extern int read_buffer_capacity(drive_info* drive);
extern int read_writer_info(drive_info* drive);
extern int detect_mm_capabilities(drive_info* drive);
extern int detect_check_capabilities(drive_info* drive);

#endif
