/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>

#include <qpx_transport.h>
#include <qpx_mmc.h>
#include <common_functions.h>

#include "media_check_benq_rom.h"

const int cnt_max_cd = 4;
const int cnt_max_dvd = 4;
int cnt;
int _c1[cnt_max_cd];
int _c2[cnt_max_cd];
//int _cu[cnt_max_cd];
int _lba;
int _pie[cnt_max_dvd];
int _pif[cnt_max_dvd];

// ************* Scan init commands *********
int benq_rom_init_scan(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xF1;
	drive->cmd[2] = 0xFF;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,4))){
		sperror ("benq_rom_init_cx_scan",drive->err);
		return drive->err;
	}
	cnt=0;
	return 0;
}

int benq_rom_cx_do_one_interval(drive_info* drive, int* lba, int* BLER,
	int* E11, int* E21, int* E31, int* E12, int* E22, int* E32)
{
	int len = 34;
	if (!(cnt%cnt_max_cd)) {
		drive->cmd_clear();
		drive->cmd[0] = 0x78;
		if (!*lba) { drive->cmd[5] = 0x01; drive->cmd[6] = 0x00; len=32; }
		else { drive->cmd[5] = 0x00; drive->cmd[6] = 0x01; }
		drive->cmd[8] = 0x20;
		drive->cmd[10]= 0x10;
		if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,len))){
			sperror ("benq_rom_cx_do_one_interval",drive->err);
			return drive->err;
		}
		for (int i=0; i<4; i++) {
			_c1[i] = swap2(drive->rd_buf+4+i*4);
			_c2[i] = swap2(drive->rd_buf+6+i*4);
//			_lba=((int)drive->rd_buf[0] * 4500 + (int)drive->rd_buf[3] * 75 + (int)drive->rd_buf[2]);
		}
		cnt = 0;
	}
	*BLER = _c1[cnt];
	*E11 = 0;
	*E21 = 0;
	*E31 = 0;
	*E12 = 0;
	*E22 = _c2[cnt];
	*E32 = 0;//_cu[cnt];
	*lba+=75;
	cnt++;
//	*lba = _lba;
	return 0;
}

int benq_rom_jitter_CD_do_one_interval(drive_info* drive, int* lba, int* jitter, short int* beta, int blklen)
{
//*
	if (!*lba) {
		drive->cmd_clear();
		drive->cmd[0] = 0x78;
		drive->cmd[5] = 0x01;
		drive->cmd[6] = 0x00;
		drive->cmd[8] = 0x20;
		drive->cmd[10]= 0x10;
		if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,32))){
			sperror ("benq_rom_jitter_cd_do_one_interval",drive->err);
			return drive->err;
		}
		*lba+=75;
	}
	drive->cmd_clear();
	drive->cmd[0] = 0x78;
	drive->cmd[5] = 0x00;
	drive->cmd[6] = 0x01;
	drive->cmd[8] = 0x20;
	drive->cmd[10]= 0x10;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,34))){
		sperror ("benq_rom_jitter_cd_do_one_interval",drive->err);
		return drive->err;
	}
	*jitter = 20*(int)drive->rd_buf[0x20];
	*beta = 0;
//	*lba=((int)drive->rd_buf[0] * 4500 + (int)drive->rd_buf[3] * 75 + (int)drive->rd_buf[2]);
	*lba+=75;
	return 0;
}

int benq_rom_pie_pif_do_one_interval(drive_info* drive, int* lba, int* pie, int* pif, int* pof)
{
	if (!(cnt%cnt_max_cd)) {
		drive->cmd_clear();
		drive->cmd[0] = 0x78;
		if (!*lba) { drive->cmd[6] = 0x00; drive->cmd[7] = 0x10; }
		else { drive->cmd[6] = 0x01; drive->cmd[7] = 0x00; }
		drive->cmd[8] = 0x22;
		drive->cmd[10]= 0x10;
		if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,34))){
			sperror ("benq_rom_pie_pif_do_one_interval",drive->err);
			return drive->err;
		}
		for (int i=0; i<4; i++) {
			_pie[i] = swap2(drive->rd_buf+4+i*4);
			_pif[i] = swap2(drive->rd_buf+6+i*4);
//			_lba=((int)drive->rd_buf[0] * 4500 + (int)drive->rd_buf[3] * 75 + (int)drive->rd_buf[2]);
		}
		cnt = 0;
	}
	*pie = _pie[cnt];
	*pif = _pif[cnt];
	*pof = 0;
	*lba+=0x100;
//	printf("BenQ Pi SCAN: cnt=%d\n",cnt);
	cnt++;
//	*lba = _lba;
	return 0;
}

int benq_rom_jitter_DVD_do_16_ecc(drive_info* drive, int* lba, int* jitter, short int* beta)
{
	drive->cmd_clear();
	drive->cmd[0] = 0x78;
	if (!*lba) { drive->cmd[6] = 0x00; drive->cmd[7] = 0x10; }
	else { drive->cmd[6] = 0x01; drive->cmd[7] = 0x00; }
	drive->cmd[8] = 0x22;
	drive->cmd[10]= 0x10;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,34))){
		sperror ("benq_rom_cx_do_one_interval",drive->err);
		return drive->err;
	}
	*jitter = 20*(int)drive->rd_buf[0x20];
	*beta = 0;
//	*lba=((int)drive->rd_buf[0] * 4500 + (int)drive->rd_buf[3] * 75 + (int)drive->rd_buf[2]);
	*lba+= 0x400;
	return 0;
}

// ************* END SCAN COMMAND *********
int benq_rom_cx_end_scan(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0x78;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,32))){
		sperror ("benq_rom_end_scan_cd",drive->err);
		return drive->err;
	}
	printf("\n");
	return 0;
}

int benq_rom_pi_end_scan(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0x78;
	drive->cmd[7] = 0x40;
	drive->cmd[8] = 0x22;
	drive->cmd[10]= 0x10;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,34))){
		sperror ("benq_rom_end_scan_dvd",drive->err);
		return drive->err;
	}
	return 0;
}

scan_commands commands_list_benq_rom = {
	benq_rom_init_scan,	benq_rom_cx_do_one_interval,		benq_rom_cx_end_scan,
	benq_rom_init_scan,	benq_rom_jitter_CD_do_one_interval,	benq_rom_cx_end_scan,

	NULL,			NULL,					NULL,
	NULL,			NULL,					NULL,
	NULL,			NULL,					NULL,
	benq_rom_init_scan,	benq_rom_pie_pif_do_one_interval,	benq_rom_pi_end_scan,
	benq_rom_init_scan,	benq_rom_jitter_DVD_do_16_ecc,		benq_rom_cx_end_scan,
};

scan_commands commands_benq_rom()  { return commands_list_benq_rom; }
