/***************************************************************************
                          qsstv.cpp  -  QSSTV
                             -------------------
    begin                : Thu May 24 2001
    copyright            : (C) 2001 by Johan Maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qpixmap.h>
#include <qpngio.h>
#include <qwindowsstyle.h>
#include <qnetwork.h>
#include <stdlib.h>
#include "qsstvglobal.h"
#include "dspfunc.h"
#include "sstvrx.h"
#include "sstvtx.h"
#include "repeater.h"
#include "cpixmap.h"
#include "thumbwindow.h"
#include <qjpegio.h>
#include "configtable.h"
#include "icons/marble.xpm"


int main( int argc, char ** argv )
{
//  qInitPngIO();
// qInitJpegIO();

 	QApplication::setColorSpec( QApplication::ManyColor );
  QApplication qApp( argc, argv );
	qApp.setStyle(new QWindowsStyle);

	QPixmap background(marble_xpm);
	QColor backCol( 227,227,227 );
	QColorGroup active(qApp.palette().active());
	QColorGroup disabled(qApp.palette().disabled());
	active.setBrush(QColorGroup::Background,QBrush(backCol, background));
	disabled.setBrush(QColorGroup::Background,QBrush(backCol, background));
	QPalette newPalette( active, disabled, active );
  qApp.setPalette(newPalette, TRUE ); 	
  qApp.setFont(QFont("helvetica", 10));

  loadIcons();
  Initialize();
	qInitNetworkProtocols();
	//read the configfile

  dsp=new dspFunctions();
  tw = new thumbWindow(0,0); // tw must be initialized before tx and rx
  tx = new sstvTX(0,0);      // tx must be initialized before rx and rep
  rep= new repeater;         // rep must be initialized before rx
  rx = new sstvRX(0,0);

  qApp.setMainWidget(rx);
  tx->setRightJustification(TRUE);
  rx->setRightJustification(TRUE);
  tw->setRightJustification(TRUE);
  rx->setCaption( "QSSTV Receive" ); 
  tx->setCaption( "QSSTV Transmit" );
  tw->setCaption( "QSSTV Thumbnails");

  rx->setIcon(*qsstvIcon);
  tx->setIcon(*qsstvIcon);
  tw->setIcon(*qsstvIcon);
  tx->show();
  rx->show();
  tw->show();
	//qsstvDebug("%d %s %s",argc,argv[0],argv[1]);
  int result=qApp.exec();
  configFile.saveActiveOptions(configTable);
  return result;
}










