#ifndef SSTVRX_H
#define SSTVRX_H
#include <qwidget.h>
#include "rxtxcommon.h"
#include "rxwindow.h"
#include "dspfunc.h"

class ftp;

enum edetectionState {DETECTSTART,DETECTED};
enum efreqReturn {FDETECTWAIT,FDETECTOK,FDETECTMAXEXCEED,FDETECTFAILED};


#define AUTODETLEN  8  // must be a power of 2 !!!
#define MAXPIXELS 640

struct sautodetect
{
  float syncDuration; //also use for fax black
  float syncDurationW;
  short unsigned int readPointer;
};

class sstvRX : public rxWindow, rxtxCommon
{ 
  Q_OBJECT
public:
  sstvRX(QWidget *p=0 ,const char *n=0, WFlags f=0);
  ~sstvRX();
  bool bincomingImage;
public slots:
  void slotStart();
  void slotStop();
  void slotTXEnd();
  void slotTop();
  void slotResync();
  void slotVisButton(bool b);
  void slotFilterChange(int fil);
  void slotPostFilterChange(int fil);
  void slotSSTVDecode();
 	void slotFAXDecode();
 	void slotSSTVFAX(int i);
 	void slotLeftMouseBtn(QMouseEvent *e);
  void slotDump();
  void slotStopDump();
  void slotPlot();
  void slotRecord();

private:

	bool resyncFlag;
	float syncWidth;
  //frequency measurement
  float averageFrequency;
  float frequencyError;
  bool testAverageFrequency(float freq,float error);
	bool faxAnalyseSync();
  float ff1;
	float ff2;
	float	fd1;
	float	fd2;
	int detectError;
  unsigned int  currentMode;
  efreqReturn freqResult;
  float pulseDuration;
  uint autoDetectCounter;
  uint detectedSamples;
  uint threshold;
  uint threshold_end;
  edetectionState detectState;
  sautodetect syncArray[AUTODETLEN];
  unsigned int syncDetectCounter;
	bool robotResync;
	ftp *ftpPtr;
	enum efilterType selectedFilter;
	enum epostFilterType selectedPostFilter;
  unsigned char pixbuf0[MAXPIXELS];
  unsigned char pixbuf1[MAXPIXELS];
  unsigned char pixbuf2[MAXPIXELS];
  unsigned char pixbuf3[MAXPIXELS];
  unsigned char *buf;
  unsigned int syncInPixel;
	uchar lut[256];
	
  int tempColor;
  unsigned int tempColorCounter;
	void initReceive();
	void gotoState(eTxRxState s);
	void gotoFaxState(efaxState s);
	efreqReturn getFaxPixels();
	bool getData();
	void armFrequencyDetection();
	void reposition(int len);
	void changeMode (uint tc);
	efreqReturn waitForEndTone(float freq,float bandwidth);
	efreqReturn waitForTonePulse(float freq,float bandwidth,float minimumDuration);
	efreqReturn measureFrequency(float duration,float delay=0);
	efreqReturn measureFrequencyEndTime(double endTime);
	void shiftSyncArray();
	bool analyseSync();
	void initAnalyseSync();
	void switchSyncDetect(bool t);
	void endOfImage();
	void nextSubline(uint line);
	efreqReturn calcPixel(double);
	void stopDump();
	void buildLUT();
	bool faxInversePolarity;
	bool faxRunning;
	void reset();
};




inline bool sstvRX::getData()
{
	if(dsp->getDemodulatedData(sample))
		{
#ifdef  DEBUGQSSTV
			if(dumpActive)
				{
					sendToDebugger();
				}
			sampleCounter++;
#endif			
			imageSampleCounter++;
			stateSampleCounter++;
			return TRUE;
		}
	return FALSE;
}

inline void sstvRX::reposition(int len)
{
	dsp->reposition(len);
  stateSampleCounter-=len;
 	imageSampleCounter-=len;

 	
#ifdef  DEBUGQSSTV
  if(dumpActive)
    {
    	sampleCounter-=len;
      deb->rewind(len);
    }
#endif
}

extern sstvRX *rx;

#endif








