/***************************************************************************
                          vumeter.h  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QVUMETER_H
#define QVUMETER_H

#ifndef QT_H
#include "qframe.h"
#endif // QT_H

/**vumeter - bar or needle representation
  *@author
  */

class VUMeter: public QFrame
{
    Q_OBJECT
public:
    VUMeter( QWidget *parent=0, const char *name=0, WFlags f=0 );
    VUMeter( int totalSteps, QWidget *parent=0, const char *name=0,
		  WFlags f=0 );

    int		totalSteps() const;
    int		progress()   const;

    void	show();
    void	UseNeedle(bool needle=TRUE)
      {
				Needle=needle;
      }
public slots:
    void	reset();
    void	setTotalSteps( int totalSteps );
    void	setProgress( int progress );

protected:
    void	drawContents( QPainter * );
    
private:
    int		total_steps;
    int		progress_val;
    int		percentage;
    QString	progress_str;
    bool        Needle;
private:	// Disabled copy constructor and operator=
    VUMeter( const VUMeter & );
    VUMeter &operator=( const VUMeter & );
};


inline int VUMeter::totalSteps() const
{
    return total_steps;
}

inline int VUMeter::progress() const
{
    return progress_val;
}

#endif // VUMETER_H



