#include "qsstvglobal.h"
#include "sstvparam.h"


double lineTimeTable[MAXLINES+1];
sSSTVParam sstvparam;

/** table of line durations starting with 0*/
void setupLineTimeTable(uint t)
{
  int i;
  for (i=0;i<=SSTVTable[t].numberOfLines;i++)
    {
      lineTimeTable[i]= (SSTVTable[t].imageTime*((double)i))/(double)SSTVTable[t].numberOfLines;
    }
}



int initializeParamString(const char *s)
{
  uint t;
  t=lookupModeString(s);
  initializeTable(t);
  return t;
}


int initializeParamCode(uint viscode)
{
  uint t;
  t=lookupModeCode(viscode);
  initializeTable(t);
  return t;
}


int  initializeTable(uint index)
{
  int i;
  if (index < NUMBEROFRXMODES)
    {     
      strcpy(sstvparam.name,SSTVTable[index].name);
      strcpy(sstvparam.shortName,SSTVTable[index].shortName);

      sstvparam.hs =SSTVTable[index].hs;
      sstvparam.bp =SSTVTable[index].bp;
      sstvparam.f1 =SSTVTable[index].f1;
      sstvparam.f2 =SSTVTable[index].f2;
      sstvparam.f3 =SSTVTable[index].f3;
      sstvparam.f4 =SSTVTable[index].f4;
      sstvparam.f5 =SSTVTable[index].f5;
      sstvparam.fp =SSTVTable[index].fp;

      sstvparam.imageTime=SSTVTable[index].imageTime;
      sstvparam.numberOfPixels=SSTVTable[index].numberOfPixels;
      sstvparam.numberOfLines=SSTVTable[index].numberOfLines;
      sstvparam.VISCode=SSTVTable[index].VISCode;
      sstvparam.colorScheme=SSTVTable[index].colorScheme;
      for (i=0;i<NUMBEROFSTATES;i++)
				{
     			sstvparam.a[i]=SSTVTable[index].a[i];
				}
      setupLineTimeTable(index);
      return 1;
    } 
  else
    {
      return 0;
    }
}


uint lookupModeString(const char *s)
{
  int t=0;
  do
    {
      if (strcmp(s,SSTVTable[t].shortName)==0)
	{
	  break;
	}
      t++;
    }
  while (t<NUMBEROFRXMODES);
  return t;
}



uint lookupModeCode(uint x)
{
  int t=0;
  do
    {
      if (SSTVTable[t].VISCode==x)
	{
	  break;
	}
      t++;
    }
  while (t<NUMBEROFRXMODES);
  return t;
}

const char* getMode(uint t)
{
  if (t<NUMBEROFRXMODES)
    {
      return(SSTVTable[t].shortName);
    }
  else
    {
      return NULL;
    }
}

int modeLookup(float lineLength)
{
  int i;
  float errLine, totalError;
  totalError=9999999;
  int lmode=NUMBEROFRXMODES;
  for (i=0;i<NUMBEROFRXMODES;i++)
    {
      errLine=1-lineLength/(SSTVTable[i].imageTime/((float)SSTVTable[i].numberOfLines));
      errLine*=errLine;
      if(errLine<totalError)
				{
	  			lmode=i;
	  			totalError=errLine;
				}
    }
  if (totalError>0.001)
    {
      return -1;
    }
  else
    {
      return lmode;
    }
}








const char *RXModesText[NUMBEROFRXMODES]=
{
  "Martin 1",
  "Martin 2",
  "Scottie 1",
  "Scottie 2",
  "Scottie DX",
  "Wr.SC2 180",
  "Robot 36",
  "Robot 72",
  "P3",
  "P5",
  "P7"

};

const char *TXModesText[NUMBEROFTXMODES]=
{
  "Martin 1",
  "Martin 2",
  "Scottie 1",
  "Scottie 2",
  "Scottie DX",
  "Wr.SC2 180",
  "Robot 36",
  "Robot 72",
  "P3",
  "P5",
  "P7"
};



sSSTVParam SSTVTable[NUMBEROFRXMODES]=
{
  {"Martin 1",     "M1"   ,
   {0.0050,0.0030,1200},    //hs   associated with PHASET1
   {0.0007,0.0007,1500},    //bp   associated with PHASET2
   {0.0005,0.0005,1500},		//f1   associated with PHASET9
   {0.0005,0.0005,1500},    //f2   associated with PHASETA
   {0,0,0},                 //f3   associated with PHASETB
   {0,0,0},                 //f4   associated with PHASETC
   {0,0,0},                 //f5   associated with PHASETD
   {0.0002,0.0002,1500},    //fp   associated with PHASETE
   114.29017,
   320,
   256,
   0xAC,
   GBR,
   {
     PHASET1,             // PHASET0  start new line
     PHASET2,             // PHASET1  get sync
     PHASET4,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASET9,             // PHASET6  get green line
     PHASETA,             // PHASET7  get blue line
     PHASETE,             // PHASET8  get red  line
     PHASET5,             // PHASET9  F1500
     PHASET3,             // PHASETA  F1900A
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     NEXTRGB,             // PHASETE  frontporch
     PHASET0,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  },

  {"Martin 2",     "M2"   ,
   {0.0050,0.0030,1200},
   {0.0007,0.0006,1500},
   {0.0006,0.0005,1500},
   {0.0006,0.0005,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0.0004,0.0004,1500},
   58.060288,
   320,
   256,
   0x28,
   GBR,
   {
     PHASET1,             // PHASET0  start new line
     PHASET2,             // PHASET1  get sync
     PHASET4,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASET9,             // PHASET6  get green line
     PHASETA,             // PHASET7  get blue line
     PHASETE,             // PHASET8  get red  line
     PHASET5,             // PHASET9  F1500
     PHASET3,             // PHASETA  F1900A
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     NEXTRGB,             // PHASETE  frontporch
     PHASET0,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  },

  {"Scottie 1",     "S1"   ,
   {0.0090,0.0070,1200},
   {0.0010,0.0010,1500},
   {0.0015,0.0015,1500},
   {0.0015,0.0015,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0.000,0.000,0},
   109.62432,
   320,
   256,
   0x3c,
   GBR2,
   {
     PHASET9,             // PHASET0  start new line
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETA,             // PHASET6  get green line
     PHASETE,             // PHASET7  get blue line
     NEXTRGB,             // PHASET8  get red  line
     PHASET4,             // PHASET9  f1
     PHASET5,             // PHASETA  f2
     PHASET1,             // PHASETB  f3
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     PHASET1,             // PHASETE  frontporch
     PHASET0,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  },

  {"Scottie 2",     "S2"   ,
   {0.0090,0.0070,1200},
   {0.0015,0.0015,1500},
   {0.0015,0.0015,1500},
   {0.0015,0.0015,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   71.08915,
   320,
   256,
   0xb8,
   GBR2,
   {
     PHASET9,             // PHASET0  start new line
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETA,             // PHASET6  get green line
     PHASETE,             // PHASET7  get blue line
     NEXTRGB,             // PHASET8  get red  line
     PHASET4,             // PHASET9  blanking1
     PHASET5,             // PHASETA  blanking2
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     PHASET1,             // PHASETE  frontporch
     PHASET0,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  },

  {"Scottie DX",     "SDX"   ,
   {0.0090,0.0060,1200},
   {0.0010,0.0010,1500},
   {0.0015,0.0015,1500},
   {0.0015,0.0015,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   268.8768,
   320,
   256,
   0xcc,
   GBR2,
   {
     PHASET9,             // PHASET0  start new line
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETA,             // PHASET6  get green line
     PHASET1,             // PHASET7  get blue line
     NEXTRGB,             // PHASET8  get red  line
     PHASET4,             // PHASET9  blanking1
     PHASET5,             // PHASETA  blanking2
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     PHASET1,             // PHASETE  frontporch
     PHASET0,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  },

  {"Wraase SC2 180",     "WSc2_180"   ,
   {0.0046,0.0020,1200},
   {0.0005,0.0005,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0.0005,0.0005,1500},
   182.0275,
   320,
   256,
   0xB7,
   RGB,
   {
     PHASET1,             // PHASET0  start new line
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASET5,             // PHASET6  get green line
     PHASETE,             // PHASET7  get blue line
     PHASET4,             // PHASET8  get red  line
     PHASET1,             // PHASET9  F1500
     PHASET1,             // PHASETA  F1900A
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     NEXTRGB,             // PHASETE  frontporch
     PHASET0,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  },

  {"Robot 36",     "R36"   ,
   {0.0090,0.0020,1200},		//hs associated with PHASET1
   {0.0030,0.0030,1500},    //bp associated with PHASET2
   {0.0045,0.0045,1500},    //f1 associated with PHASET9 odd line
   {0.0000,0.0000,2300},    //f2 associated with PHASET9/A even line
   {0.0015,0.0015,1900},    //f3 associated with PHASETB
   {0.0000,0.0000,1900},    //f4 associated with PHASETC
   {0,0,0},                 //f5 associated with PHASETD
   {0.0004,0.0004,1500},    //fp associated with PHASETE
   36.00001,
   320,
   240,
   0x88,
   XYZOE,
   {
     PHASET1,             // PHASET0  detect end of viscode
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETE,             // PHASET6  get green line
     PHASET3,             // PHASET7  get blue line
     PHASET9,             // PHASET8  get red  line
     PHASETB,             // PHASET9  blanking 1 /F1500
     PHASET1,             // PHASETA  blanking 2
     PHASET4,             // PHASETB
     PHASET1,             // PHASETC
     PHASET1,             // PHASETD  future
     NEXTXYZOE,         	// PHASETE  frontporch
     PHASET1,             // NEXTRGB
     PHASET0,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  },

  {"Robot 72",     "R72"   ,
   {0.0090,0.0020,1200},
   {0.0030,0.0030,1500},
   {0.0045,0.0045,1500},
   {0.0045,0.0045,2300},
   {0.0015,0.0015,1900},
   {0.0015,0.0015,1900},
   {0,0,0},
   {0.004,0.004,1500},
   72,
   320,
   240,
   0x0C,
   XYZOE2,
  {
     PHASET1,             // PHASET0  detect end of viscode
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETA,             // PHASET6  get green line
     PHASETE,             // PHASET7  get blue line
     PHASET9,             // PHASET8  get red  line
     PHASETB,             // PHASET9  F1500
     PHASETC,             // PHASETA  F2300
     PHASET4,             // PHASETB  F1900A
     PHASET5,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     NEXTXYZOE2,       // PHASETE  frontporch
     PHASET1,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET0              // NEXTXYZOE2
   }
  },
  {"P3",     "P3"   ,
   {0.0052,0.0020,1200},
   {0.00104,0.00104,1500},
   {0.00104,0.00104,1500},
   {0.00104,0.00104,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0.0010,0.0010,1500},
   203.051,
   640,
   496,
   0x71,
   RGB,
  {
     PHASET1,             // PHASET0  detect end of viscode
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETA,             // PHASET6  get green line
     NEXTRGB,             // PHASET7  get blue line
     PHASET9,             // PHASET8  get red  line
     PHASET4,             // PHASET9  F1500
     PHASET5,             // PHASETA  F1900A
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     PHASET0,             // PHASETE  frontporch
     PHASETE,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  }

,
  {"P5",     "P5"   ,
   {0.0078,0.0020,1200},
   {0.0016,0.0016,1500},
   {0.0016,0.0016,1500},
   {0.0016,0.0016,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0.0010,0.0010,1500},
   304.576,
   640,
   496,
   0x72,
   RGB,
  {
     PHASET1,             // PHASET0  detect end of viscode
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETA,             // PHASET6  get green line
     NEXTRGB,             // PHASET7  get blue line
     PHASET9,             // PHASET8  get red  line
     PHASET4,             // PHASET9  F1500
     PHASET5,             // PHASETA  F1900A
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     PHASET0,             // PHASETE  frontporch
     PHASETE,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }
  }
,
  {"P7",     "P7"   ,
   {0.0104,0.0020,1200},
   {0.0021,0.0021,1500},
   {0.0021,0.0021,1500},
   {0.0021,0.0021,1500},
   {0,0,0},
   {0,0,0},
   {0,0,0},
   {0.0010,0.0010,1500},
   406.102,
   640,
   496,
   0xF3,
   RGB,
  {
     PHASET1,             // PHASET0  detect end of viscode
     PHASET2,             // PHASET1  get sync
     PHASET3,             // PHASET2  get backporch
     PHASET8,             // PHASET3  set red line
     PHASET6,             // PHASET4  set green line
     PHASET7,             // PHASET5  set  blue line
     PHASETA,             // PHASET6  get green line
     NEXTRGB,             // PHASET7  get blue line
     PHASET9,             // PHASET8  get red  line
     PHASET4,             // PHASET9  F1500
     PHASET5,             // PHASETA  F1900A
     PHASET1,             // PHASETB  F2300
     PHASET1,             // PHASETC  F1900B
     PHASET1,             // PHASETD  future
     PHASET0,             // PHASETE  frontporch
     PHASETE,             // NEXTRGB
     PHASET1,             // NEXTXYZOE
     PHASET1              // NEXTXYZOE2
   }  
  }

};    









