/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DISPATCHER_H
#define DISPATCHER_H
#include "global.h"
#include "dispatchevents.h"
#include "sstvparam.h"

#include "buffermanag.h"

class soundIO;
class editor;
class rxFunction;
class txFunction;

/**
@author Johan Maes
*/
class dispatcher : public QObject
{
	Q_OBJECT

public:

	dispatcher();
	~dispatcher();
	void init();
	void startRX();
  void restartRX();
  void resyncRX();
	void startTX();

	void startCalibration();
  void saveRxImage();
  void setTXImage(QString fn);
  void setTXImage(QImage *im);
  bool rxBusy();
  bool txBusy();
  void sendImage();
  void setupTX(esstvMode m);
  void setupRX(esstvMode m);
  void sendTone(double duration,double freq);
  void sendSweepTone(double duration,double lowerFreq,double upperFreq);
	void customEvent( QEvent * e );
public slots:
	void slotSoundControl();
	void slotCalibFinished(int result);

signals:
  void statusMessageRX(QString message);
  void statusMessageTX(QString message);

protected:
     void timerEvent(QTimerEvent *event);

private:
	int calibResult;
	void readSettings();
	void writeSettings();

	int tpNumber;
	bool addNoise;
	DSPFLOAT noiseLevel;
	bool editorActive;
	editor *ed;
  imageViewer *iv;
	void stopTX();
	void stopRX();
	void stopRXTX();

  void activatePTT(bool b);
	int serialP;
  rxFunction *rxFuncPtr;
  txFunction *txFuncPtr;
  int txTimeCounter;
  int prTimerIndex;
  int logTimerIndex;
  bool rxRestart;

};

#endif

