#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QComboBox>
#include <QPushButton>
#include <QLabel>

namespace Ui {
  class MainWindow;
  }

class mainWindow : public QMainWindow
{
  Q_OBJECT
  
public:
  explicit mainWindow(QWidget *parent = 0);
  ~mainWindow();
  void init();
  void setNewFont();
  void setPTT(bool p);
  void setBSRPushButton(bool b);

private slots:
  void slotConfigure();
  void slotExit();
  void slotResetLog();
  void slotLogSettings();
  void slotCalibrate();
  void slotAboutQt();
  void slotAboutQSSTV();
  void slotDocumentation();
//  void slotTest();
  void slotSendID();
  void slotSendBSR();
//  void slotSendFIX();
  void slotSendWfText();
#ifndef QT_NO_DEBUG
  void slotShowDataScope();
  void slotShowSyncScope();
  void slotScopeOffset();

#endif
private:
  Ui::MainWindow *ui;
  void closeEvent ( QCloseEvent *e );
  void readSettings();
  void writeSettings();
  QComboBox *transmissionModeComboBox;
  QPushButton *wfTextPushButton;
  QPushButton *fixPushButton;
  QPushButton *bsrPushButton;
  QPushButton *idPushButton;
  QLabel pttText;
  QLabel *pttIcon;

};

#endif // MAINWINDOW_H
