/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the tools applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDBUSEXTRATYPES_H
#define QDBUSEXTRATYPES_H

// define some useful types for D-BUS

#include <QtCore/qvariant.h>
#include <QtCore/qstring.h>
#include <QtDBus/qdbusmacros.h>

QT_BEGIN_HEADER

struct QDBUS_EXPORT QDBusObjectPath
{
    inline QDBusObjectPath() { }

    inline explicit QDBusObjectPath(const char *path)
        : value(QString::fromLatin1(path))
    { check(); }

    inline explicit QDBusObjectPath(const QLatin1String &path)
        : value(path)
    { check(); }

    inline explicit QDBusObjectPath(const QString &path)
        : value(path)
    { check(); }

    QString value;

private:
    void check();
};
Q_DECLARE_METATYPE(QDBusObjectPath)

struct QDBUS_EXPORT QDBusSignature
{
    inline QDBusSignature() { }

    inline explicit QDBusSignature(const char *signature)
        : value(QString::fromLatin1(signature))
    { check(); }

    inline explicit QDBusSignature(const QLatin1String &signature)
        : value(signature)
    { check(); }

    inline explicit QDBusSignature(const QString &signature)
        : value(signature)
    { check(); }

    QString value;

private:
    void check();
};
Q_DECLARE_METATYPE(QDBusSignature)

struct QDBusVariant
{
    inline QDBusVariant() { }
    inline explicit QDBusVariant(const QVariant &variant) : value(variant) { }
    QVariant value;
};
Q_DECLARE_METATYPE(QDBusVariant)

QT_END_HEADER

#endif
