/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtOpenGL module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QWINDOWSURFACE_EGL_P_H
#define QWINDOWSURFACE_EGL_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of the QEGLWindowSurface class.  This header file may change from
// version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qglobal.h>
#include <QPaintDevice>
#include "private/qwindowsurface_qws_p.h"
#include <GLES/egl.h>

class QPaintDevice;
class QPoint;
class QRegion;
class QSize;
class QWidget;
class QGLContext;

class QEGLWindowSurfacePrivate;

class QEGLWindowSurface : public QWSWindowSurface
{
    Q_DECLARE_PRIVATE(QEGLWindowSurface)
public:
    QEGLWindowSurface(QWidget *widget);
    QEGLWindowSurface();
    ~QEGLWindowSurface();

    QPaintDevice *paintDevice();

    void scroll(const QRegion &area, int dx, int dy);

    bool isValidFor(const QWidget*) const { return true; }
    const QImage image() const { return QImage(); }

    virtual bool chooseContext(QGLContext *context, const QGLContext *shareContext) = 0;
    QGLContext *context() const;

    // remove virtual when we have a better data() function
    virtual GLuint textureId() const = 0;

protected:
    // remove virtual when we have a better data() function
    virtual void setTextureId(GLuint texId) = 0;

    void setContext(QGLContext *context);

private:
    QEGLWindowSurfacePrivate *d_ptr;
};


#endif // QWINDOWSURFACE_EGL_P_H
