/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the $MODULE$ of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QSCRIPTEXTQOBJECT_P_H
#define QSCRIPTEXTQOBJECT_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qscriptecmacore_p.h"
#include "qscriptclassdata_p.h"
#include "qscriptfunction_p.h"
#include "qscriptengine.h"

#ifndef QT_NO_QOBJECT

#include <QtCore/QPointer>
#include <QtCore/QObject>

namespace QScript {

class ExtQObject: public Ecma::Core
{
public:
    ExtQObject(QScriptEnginePrivate *engine, QScriptClassInfo *classInfo);
    virtual ~ExtQObject();

    inline QScriptClassInfo *classInfo() const { return m_classInfo; }

    virtual void execute(QScriptContextPrivate *context);

    class Instance: public QScriptFunction {
    public:
        Instance() { }
        virtual ~Instance()
        {
            if (ownership == QScriptEngine::ScriptOwnership)
                delete value;
        }

        static Instance *get(const QScriptValueImpl &object, QScriptClassInfo *klass);

        virtual void execute(QScriptContextPrivate *context);

    public:
        QPointer<QObject> value;
        bool isConnection;
        QScriptEngine::ValueOwnership ownership;
    };

    inline Instance *get(const QScriptValueImpl &object) const
        { return Instance::get(object, classInfo()); }

    void newQObject(QScriptValueImpl *result, QObject *value,
                    QScriptEngine::ValueOwnership ownership = QScriptEngine::QtOwnership,
                    bool isConnection = false);

protected:
    static QScriptValueImpl method_findChild(QScriptContextPrivate *context, QScriptEnginePrivate *eng, QScriptClassInfo *classInfo);
    static QScriptValueImpl method_findChildren(QScriptContextPrivate *context, QScriptEnginePrivate *eng, QScriptClassInfo *classInfo);
    static QScriptValueImpl method_toString(QScriptContextPrivate *context, QScriptEnginePrivate *eng, QScriptClassInfo *classInfo);

    QScriptClassInfo *m_classInfo;
};

class ConnectionQObject: public QObject
{
public:
    ConnectionQObject(const QMetaMethod &m, const QScriptValueImpl &sender,
                      const QScriptValueImpl &receiver, const QScriptValueImpl &slot);
    ~ConnectionQObject();

    static const QMetaObject staticMetaObject;
    virtual const QMetaObject *metaObject() const;
    virtual void *qt_metacast(const char *);
    virtual int qt_metacall(QMetaObject::Call, int, void **argv);

    void execute(void **argv);

    void mark(int generation);
    bool hasTarget(const QScriptValueImpl &, const QScriptValueImpl &) const;

private:
    QMetaMethod m_method;
    QScriptValue m_self;
    QScriptValueImpl m_sender;
    QScriptValueImpl m_receiver;
    QScriptValueImpl m_slot;
    bool m_hasReceiver;
};

class QtFunction: public QScriptFunction
{
public:
    QtFunction(QObject *object, int initialIndex, bool maybeOverloaded)
        : m_object(object), m_initialIndex(initialIndex),
          m_maybeOverloaded(maybeOverloaded)
        { }

    virtual ~QtFunction();

    virtual void execute(QScriptContextPrivate *context);

    virtual Type type() const { return QScriptFunction::Qt; }

    inline QObject *object() const { return m_object; }
    inline const QMetaObject *metaObject() const { return m_object->metaObject(); }
    inline int initialIndex() const { return m_initialIndex; }
    inline bool maybeOverloaded() const { return m_maybeOverloaded; }
    bool createConnection(const QScriptValueImpl &self,
                          const QScriptValueImpl &receiver,
                          const QScriptValueImpl &slot);
    bool destroyConnection(const QScriptValueImpl &self,
                           const QScriptValueImpl &receiver,
                           const QScriptValueImpl &slot);

private:
    QPointer<QObject> m_object;
    QList<QPointer<QObject> > m_connections;
    int m_initialIndex;
    bool m_maybeOverloaded;
};

class ExtQMetaObject: public Ecma::Core
{
public:
    ExtQMetaObject(QScriptEnginePrivate *engine, QScriptClassInfo *classInfo);
    virtual ~ExtQMetaObject();

    inline QScriptClassInfo *classInfo() const { return m_classInfo; }

    virtual void execute(QScriptContextPrivate *context);

    class Instance: public QScriptFunction {
    public:
        Instance() { value = 0; ctor.invalidate(); }
        virtual ~Instance() { }

        static Instance *get(const QScriptValueImpl &object, QScriptClassInfo *klass);

        virtual void execute(QScriptContextPrivate *context);

    public:
        const QMetaObject *value;
        QScriptValueImpl ctor;
    };

    inline Instance *get(const QScriptValueImpl &object) const
        { return Instance::get(object, classInfo()); }

    void newQMetaObject(QScriptValueImpl *result, const QMetaObject *value,
                        const QScriptValueImpl &ctor = QScriptValueImpl());

protected:
    static QScriptValueImpl method_className(QScriptContextPrivate *context, QScriptEnginePrivate *eng, QScriptClassInfo *classInfo);

    QScriptClassInfo *m_classInfo;
};

} // namespace QScript

#endif // QT_NO_QOBJECT

#endif // QSCRIPTEXTQOBJECT_P_H
