/* Copyright (C) 2004 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#include "config.h"

#include "missing.h"

#include <cstdlib>
#include <cctype>
#include <cstring>
#include <qstring.h>

int
memicmp( const char* s1, const char* s2, size_t len )
{
	// TODO: Hmm, are variable-size arrays really not in ISO C++?
	//char x1[len];
	//char x2[len];

	char* x1 = new char[len];
	char* x2 = new char[len];

	for (size_t i = 0; i < len; ++i) {
		x1[i] = std::tolower(s1[i]);
		x2[i] = std::tolower(s2[i]);
	}
	int ret = std::memcmp(x1, x2, len);
	delete[] x1;
	delete[] x2;
	return ret;
}


int
stricmp( const char* s1, const char* s2 )
{
	return QString::localeAwareCompare(QString(s1).lower(), QString(s2).lower());
}


int
strnicmp( const char* s1, const char* s2, size_t n )
{
	QString qs1(s1);
	QString qs2(s2);

	qs1.truncate(n);
	qs2.truncate(n);

	return QString::localeAwareCompare(qs1.lower(), qs2.lower());
}
