/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef CPPGENERATOR_H
#define CPPGENERATOR_H

#include "generator.h"
#include "metajava.h"

class CppGenerator : public Generator
{
    Q_OBJECT

public:
    virtual QString subDirectoryForClass(const MetaJavaClass *cls) const
    {
        return "cpp/" + cls->package().replace(".", "_") + "/";
    }

    static void writeTypeInfo(QTextStream &s, const MetaJavaType *type, Option option = NoOption);
    static void writeFunctionSignature(QTextStream &s, const MetaJavaFunction *java_function,
                                const MetaJavaClass *implementor = 0,
                                const QString &name_prefix = QString(),
                                Option option = NoOption,
                                const QString &classname_prefix = QString(),
                                const QStringList &extra_arguments = QStringList(),
                                int numArguments = -1);
    static void writeFunctionArguments(QTextStream &s, const MetaJavaArgumentList &arguments,
                                Option option = NoOption,
                                int numArguments = -1);

    QString signalWrapperPrefix() const { return "__qt_signalwrapper_"; }

    bool shouldGenerate(const MetaJavaClass *java_class) const {
        return !java_class->isNamespace() && !java_class->isInterface()
            && !java_class->typeEntry()->isVariant()
            && (java_class->typeEntry()->codeGeneration() & TypeEntry::GenerateCpp);
    }

    static QString shellClassName(const MetaJavaClass *java_class) {
        return java_class->generateShellClass()
               ? "QtJambiShell_" + java_class->name()
               : java_class->qualifiedCppName();
    }

};


#endif // CPPGENERATOR_H
