/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GAMEANIMATION_H
#define GAMEANIMATION_H

#include "gamenamespace.h"

#include <QtCore/QObject>
#include <QtCore/QTime>
#include <QtGui/QImage>

class GameAnimation: public QObject
{
    Q_OBJECT
public:
    GameAnimation(Game::AnimationType type);
    ~GameAnimation();

    inline void addFrame(const QImage &image) { m_frames.append(image); }

    inline void setSpeed(int speed)
    {
        m_speed = speed;
    }
    inline void setLooping(bool on)
    {
        m_looping = on;
    }
    inline void setCurrentFrame(int current_frame) { m_current_frame = current_frame; m_time.restart(); }

    inline Game::AnimationType type() const { return m_type; }
    inline int speed() const { return m_speed; }
    inline bool isLooping() const { return m_looping; }
    QImage currentFrame() const { return frame(m_current_frame); }
    inline QImage frame(int index) const
    {
        if (index >= 0 && index < m_frames.size())
            return m_frames.at(index);
        else
            return QImage();
    }

public slots:
    bool update();

signals:
    void finished();

private:
    QList<QImage> m_frames;
    Game::AnimationType m_type;
    int m_speed;
    bool m_looping;
    int m_current_frame;
    QTime m_time;
};

#endif
